/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.formatter.HTMLFmter;
import edu.wisc.game.rest.ColorMap;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.GameService2;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.rest.TrialList;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.sql.ImageObject;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.sql.PredefinedBoardGameGenerator;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/CheckPlanService")
public class CheckPlanService
extends GameService2 {
    private static HTMLFmter fm = new HTMLFmter(null);

    @POST
    @Path(value="/checkRules")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String checkRulesHtml(@FormParam(value="rulesText") String rulesText) {
        Vector<String> v = new Vector<String>();
        int errcnt = 0;
        String info = null;
        String title = "Checking a rule set";
        String title1 = "Checking a rule set";
        v.add(fm.h1(title1));
        v.add(fm.para("Input:<br>" + fm.pre(rulesText)));
        try {
            RuleSet rules = new RuleSet(rulesText);
            v.add(fm.para("The rules have been compiled as follows:"));
            v.add(fm.para(fm.tt(rules.toSrc().replaceAll("\n", "<br>"))));
        }
        catch (Exception ex) {
            if (info != null) {
                v.add(fm.para(info));
            }
            v.add(fm.para("Error: " + ex));
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            String s = fm.pre(sw.toString());
            v.add(fm.para(fm.wrap("small", "Details:" + s)));
            ++errcnt;
        }
        v.add("<hr>");
        if (errcnt > 0) {
            v.add(fm.para("Found " + errcnt + " errors. You may want to fix them before inviting players into this experiment plan"));
        } else {
            v.add(fm.para("Found no errors."));
        }
        String body = String.join((CharSequence)"\n", v);
        return fm.html(title, body);
    }

    @POST
    @Path(value="/checkPlan")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String checkPlanHtml(@FormParam(value="exp") String exp) {
        exp = exp.trim();
        Vector<String> v = new Vector<String>();
        int errcnt = 0;
        String title = "Checking experiment plan " + exp;
        String title1 = "Checking experiment plan " + fm.tt(exp);
        v.add(fm.h1(title1));
        v.add(fm.h2("Checking the color map"));
        v.add(fm.para("Note: the same global color map is used for shape-and-color-tuple objects in all experiment plans. It is ignored as far as image-and-properties-based objects are concerned."));
        ColorMap cm = new ColorMap();
        Object o = cm.get("error");
        if (o != null && o.equals(Boolean.TRUE)) {
            v.add(fm.para("Error: " + cm.get("errmsg")));
            ++errcnt;
        }
        Vector<String> rows = new Vector<String>();
        for (String key : cm.keySet()) {
            if (key.equals("error") || key.equals("errmsg")) continue;
            String hexColor = "#" + cm.getHex(key, false);
            rows.add(fm.tr(fm.td(key) + fm.td("bgcolor=\"" + (String)hexColor + "\"", fm.space(10))));
        }
        v.add(fm.table("border='1'", rows));
        v.add(fm.para("Loaded the total of " + rows.size() + " colors"));
        v.add(fm.h2("Checking the trial lists"));
        String info = null;
        try {
            Vector<String> lists = TrialList.listTrialLists(exp);
            v.add(fm.para("Found " + lists.size() + " trial lists for experiment plan " + fm.tt(exp)));
            for (String key : lists) {
                v.add(fm.h3("Checking trial list " + fm.tt(key)));
                TrialList trialList = new TrialList(exp, key);
                if (trialList.error) {
                    v.add(fm.para("Error: failed to create trial list <tt>" + key + "</tt>. Error=" + trialList.errmsg));
                    ++errcnt;
                    continue;
                }
                int npara = trialList.size();
                v.add(fm.para("... the trial list has " + npara + " parameter set(s)"));
                int j = 0;
                for (ParaSet para : trialList) {
                    v.add(fm.para("Checking para set no. " + ++j + " out of " + npara + "..."));
                    para.checkImages();
                    boolean ipb = para.images != null;
                    TreeMap<String, TreeSet<String>> propValues = new TreeMap<String, TreeSet<String>>();
                    if (ipb) {
                        v.add(fm.para("This is an image-and-properties-based para set, which uses " + para.images.length + " images:"));
                        rows = new Vector();
                        for (String k : para.images) {
                            String z = "<img width='80' src=\"../../GetImageServlet?image=" + k + "\">";
                            ImageObject io = ImageObject.obtainImageObjectPlain(null, k, false);
                            rows.add(fm.tr(fm.td(k) + fm.td(z) + fm.td(io.listProperties())));
                            for (String p : io.keySet()) {
                                TreeSet<String> h = (TreeSet<String>)propValues.get(p);
                                if (h == null) {
                                    h = new TreeSet<String>();
                                    propValues.put(p, h);
                                }
                                h.add((String)io.get(p));
                            }
                        }
                        v.add(fm.table("border='1'", rows));
                        v.add(fm.para("All properties used by the objects involved in this trial list, and all values found for these properties, are listed in the following table:"));
                        rows.clear();
                        rows.add(fm.tr(fm.th("Property") + fm.th("Values")));
                        for (String p : propValues.keySet()) {
                            rows.add(fm.tr(fm.td(p) + fm.td(Util.joinNonBlank(", ", (Collection)propValues.get(p)))));
                        }
                        v.add(fm.table("border='1'", rows));
                    } else {
                        v.add(fm.para("Images are not used in this para set, which means that this is a shapes-and-colors para set"));
                        para.checkColors(cm);
                        if (para.colors == null) {
                            v.add(fm.para("Colors are not used in this para set"));
                        } else {
                            v.add(fm.para("Para set uses " + para.colors.length + " color(s):"));
                            rows = new Vector();
                            for (Piece.Color color : para.colors) {
                                String hexColor = "#" + cm.getHex(color, false);
                                rows.add(fm.tr(fm.td(color.toString()) + fm.td("bgcolor=\"" + hexColor + "\"", fm.space(10))));
                            }
                            v.add(fm.table("border='1'", rows));
                        }
                        para.checkShapes();
                        if (para.shapes == null) {
                            v.add(fm.para("Shapes are not used in this para set"));
                        } else {
                            v.add(fm.para("Para set uses " + para.shapes.length + " shape(s):"));
                            rows = new Vector();
                            for (Piece.Shape shape : para.shapes) {
                                String sh = shape.toString();
                                String z = "<img width='80' src=\"../../GetImageServlet?image=" + (String)sh + "\">";
                                rows.add(fm.tr(fm.td(sh) + fm.td(z)));
                            }
                            v.add(fm.table("border='1'", rows));
                        }
                    }
                    info = "The rule set name = " + para.getRuleSetName();
                    GameGenerator gg = GameGenerator.mkGameGenerator(Episode.random, para);
                    info = null;
                    Game game = gg.nextGame();
                    if (gg instanceof PredefinedBoardGameGenerator) {
                        v.add(fm.para("Checking predefined boards..."));
                        ((PredefinedBoardGameGenerator)gg).checkShapesAndColors(cm);
                    }
                    RuleSet rules = gg.getRules();
                    v.add(fm.para("The rules have been compiled as follows:"));
                    v.add(fm.para(fm.tt(rules.toSrc().replaceAll("\n", "<br>"))));
                    if (ipb) {
                        TreeMap<String, TreeSet<String>> w = rules.listAllPropValues();
                        for (String p : w.keySet()) {
                            TreeSet h = (TreeSet)propValues.get(p);
                            if (h == null) {
                                v.add(fm.para("Warning: Rule set " + para.getRuleSetName() + " makes use of property <tt>" + p + "</tt>, which does not appear in any of the image-based objects of this parameter set. Therefore, any references to this property in the rule set won't affect the game."));
                            }
                            TreeSet z = new TreeSet();
                            z.addAll(w.get(p));
                            z.removeAll(h);
                            if (z.isEmpty()) continue;
                            v.add(fm.para("Warning: When rule set " + para.getRuleSetName() + " has conditions referring to property <tt>" + p + "</tt>, it makes use of " + z.size() + " values of this property (<tt>" + Util.joinNonBlank(", ", z) + "</tt>), which do not appear in any of the image-based objects of this parameter set."));
                        }
                        continue;
                    }
                    for (Piece.Shape shape : rules.listAllShapes()) {
                        File f = Files.getSvgFile(shape);
                        if (f.canRead()) continue;
                        v.add(fm.para("Warning: Rule set " + para.getRuleSetName() + " mentions shape " + shape + ", for which no SVG file exists. Was a different shape intended?"));
                        ++errcnt;
                    }
                    for (Piece.Color color : rules.listAllColors()) {
                        if (cm.hasColor(color)) continue;
                        v.add(fm.para("Warning: Rule set " + para.getRuleSetName() + " mentions color " + color + ", which is not listed in the color map file. Was a different color intended?"));
                        ++errcnt;
                    }
                }
            }
        }
        catch (Exception ex) {
            if (info != null) {
                v.add(fm.para(info));
            }
            v.add(fm.para("Error: " + ex));
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            String s = fm.pre(sw.toString());
            v.add(fm.para(fm.wrap("small", "Details:" + s)));
            ++errcnt;
        }
        v.add("<hr>");
        if (errcnt > 0) {
            v.add(fm.para("Found " + errcnt + " errors. You may want to fix them before inviting players into this experiment plan"));
        } else {
            v.add(fm.para("Found no errors."));
        }
        String body = String.join((CharSequence)"\n", v);
        return fm.html(title, body);
    }

    @POST
    @Path(value="/clearTables")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String clearTables() {
        AllRuleSets.clearAll();
        ImageObject.clearTable();
        String title = "Clearing server tables";
        Vector<String> v = new Vector<String>();
        v.add(fm.para("Rule table cleared"));
        String body = String.join((CharSequence)"\n", v);
        return fm.html(title, body);
    }
}

