/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.Files;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.CsvData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ColorMap")
public class ColorMap
extends HashMap<String, Object> {
    public ColorMap() {
        this.put("error", false);
        this.put("errmsg", "No error");
        try {
            File base = new File(Files.inputDir, "colors");
            File f = new File(base, "colors.csv");
            if (!f.exists()) {
                throw new IOException("File does not exist: " + f);
            }
            if (!f.canRead()) {
                throw new IOException("Cannot read file: " + f);
            }
            CsvData csv = new CsvData(f, true, false, null);
            for (CsvData.LineEntry _e : csv.entries) {
                CsvData.BasicLineEntry e = (CsvData.BasicLineEntry)_e;
                String key = e.getKey().toUpperCase();
                if (e.nCol() != 4) {
                    throw new IOException("Invalid entry in file " + f + ": expected 4 columns, found " + e.nCol() + ": " + e);
                }
                Vector<Integer> v = new Vector<Integer>();
                for (int j = 1; j <= 3; ++j) {
                    Integer q = new Integer(e.getCol(j));
                    if (q < 0 || q > 255) {
                        throw new IOException("Invalid value (" + q + ") in column " + j + " in file " + f + ", Line: " + e);
                    }
                    v.add(q);
                }
                this.put(key, v);
            }
        }
        catch (Exception ex) {
            this.put("error", true);
            this.put("errmsg", ex.getMessage());
        }
    }

    public String getHex(Piece.Color color, boolean brighten) {
        return this.getHex(color.toString(), brighten);
    }

    public String getHex(String name, boolean brighten) {
        Vector<Integer> q = (Vector<Integer>)this.get(name.toUpperCase());
        if (q == null) {
            return null;
        }
        if (brighten) {
            Vector<Integer> z = new Vector<Integer>();
            Iterator iterator = q.iterator();
            while (iterator.hasNext()) {
                int x = (Integer)iterator.next();
                z.add((x + 255) / 2);
            }
            q = z;
        }
        return ColorMap.vectorToHex(q);
    }

    private static String vectorToHex(Vector<Integer> q) {
        if (q == null || q.size() != 3) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        for (int x : q) {
            out.printf("%02X", x);
        }
        out.flush();
        return baos.toString();
    }

    public boolean hasColor(Piece.Color color) {
        Object o = this.get(color.toString());
        return o != null && o instanceof Vector;
    }
}

