/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/FileUploadResource")
public class FileUploadResource {
    @Path(value="/file")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Response uploadFile(@DefaultValue(value="") @FormDataParam(value="tags") String tags, @FormDataParam(value="file") InputStream file, @FormDataParam(value="file") FormDataContentDisposition fileDisposition) {
        String fileName = fileDisposition.getFileName();
        this.saveFile(file, fileName);
        String fileDetails = "File saved at /Volumes/Drive2/temp/file/" + fileName + " with tags " + tags;
        System.out.println(fileDetails);
        return Response.ok((Object)fileDetails).build();
    }

    @Path(value="/files2")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Response uploadFiles(FormDataMultiPart multiPart) {
        List bodyParts = multiPart.getFields("files");
        StringBuffer fileDetails = new StringBuffer("");
        for (int i = 0; i < bodyParts.size(); ++i) {
            BodyPartEntity bodyPartEntity = (BodyPartEntity)((FormDataBodyPart)bodyParts.get(i)).getEntity();
            String fileName = ((FormDataBodyPart)bodyParts.get(i)).getContentDisposition().getFileName();
            this.saveFile(bodyPartEntity.getInputStream(), fileName);
            fileDetails.append(" File saved at /Volumes/Drive2/temp/file/" + fileName);
        }
        BodyPartEntity bodyPartEntity = (BodyPartEntity)multiPart.getField("file2").getEntity();
        String file2Name = multiPart.getField("file2").getFormDataContentDisposition().getFileName();
        this.saveFile(bodyPartEntity.getInputStream(), file2Name);
        fileDetails.append(" File saved at /Volumes/Drive2/temp/file/" + file2Name);
        fileDetails.append(" Tag Details : " + multiPart.getField("tags").getValue());
        System.out.println(fileDetails);
        return Response.ok((Object)fileDetails.toString()).build();
    }

    private void saveFile(InputStream file, String name) {
        try {
            java.nio.file.Path path = FileSystems.getDefault().getPath("/Volumes/Drive2/temp/file/" + name, new String[0]);
            Files.copy(file, path, new CopyOption[0]);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }
}

