/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.TrialList;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.Logging;
import edu.wisc.game.util.Tools;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;

public class Files {
    static File savedDir = new File("/opt/tomcat/saved");
    static File inputDir = new File("/opt/tomcat/game-data");
    static final String RULES_EXT = ".txt";

    public static void setInputDir(String path) {
        inputDir = new File(path);
    }

    public static void setSavedDir(String path) {
        savedDir = new File(path);
    }

    static void testWriteDir(File d) throws IOException {
        if (d.exists()) {
            if (!d.isDirectory() || !d.canWrite()) {
                throw new IOException("Not a writeable directory: " + d);
            }
        } else if (!d.mkdirs()) {
            throw new IOException("Failed to create directory: " + d);
        }
    }

    public static File guessesFile(String playerId) throws IOException {
        File d = new File(savedDir, "guesses");
        Files.testWriteDir(d);
        File f = new File(d, playerId + ".guesses.csv");
        return f;
    }

    public static File boardsFile(String playerId) throws IOException {
        return Files.boardsFile(playerId, false);
    }

    public static File boardsFile(String playerId, boolean readOnly) throws IOException {
        File d = new File(savedDir, "boards");
        if (!readOnly) {
            Files.testWriteDir(d);
        }
        File f = new File(d, playerId + ".boards.csv");
        return f;
    }

    public static File transcriptsFile(String playerId) throws IOException {
        return Files.transcriptsFile(playerId, false);
    }

    public static File transcriptsFile(String playerId, boolean readOnly) throws IOException {
        File d = new File(savedDir, "transcripts");
        if (!readOnly) {
            Files.testWriteDir(d);
        }
        return new File(d, playerId + ".transcripts.csv");
    }

    public static File detailedTranscriptsFile(String playerId) throws IOException {
        File d = new File(savedDir, "detailed-transcripts");
        Files.testWriteDir(d);
        return new File(d, playerId + ".detailed-transcripts.csv");
    }

    static File trialListMainDir() {
        return new File(inputDir, "trial-lists");
    }

    public static File shapesDir() {
        return new File(inputDir, "shapes");
    }

    public static File rulesFile(String ruleSetName) throws IOException {
        if (ruleSetName == null || ruleSetName.equals("")) {
            throw new IOException("Rule set name not specified");
        }
        return Files.inputFile(ruleSetName, "rules", RULES_EXT);
    }

    public static boolean rulesCanBeCached(String ruleSetName) {
        return !ruleSetName.startsWith("/");
    }

    public static File initialBoardFile(String boardName) throws IOException {
        if (boardName == null || boardName.equals("")) {
            throw new IOException("Board name not specified");
        }
        return Files.inputFile(boardName, "boards", ".json");
    }

    public static File inputBoardSubdir(String boardSubdirName) throws IOException {
        if (boardSubdirName.startsWith("/")) {
            return new File(boardSubdirName);
        }
        File d = new File(inputDir, "boards");
        return new File(d, boardSubdirName);
    }

    private static File inputFile(String name, String subdir, String ext) throws IOException {
        if (name == null || ((String)name).equals("")) {
            throw new IOException("File name not specified");
        }
        if (((String)name).startsWith("/")) {
            return new File((String)name);
        }
        File base = new File(inputDir, subdir);
        if (!((String)name).endsWith(ext)) {
            name = (String)name + ext;
        }
        return new File(base, (String)name);
    }

    static Vector<String> listInputs(String subdir, String ext) throws IOException {
        return Files.listInputs(new File(inputDir, subdir), ext);
    }

    static Vector<String> listInputs(File dir, String ext) throws IOException {
        File[] files = dir.listFiles();
        Vector<String> v = new Vector<String>();
        for (File cf : files) {
            String fname;
            if (!cf.isFile() || !(fname = cf.getName()).endsWith(ext)) continue;
            v.add(fname.substring(0, fname.length() - ext.length()));
        }
        return v;
    }

    public static File getSvgFile(Piece.Shape shape) {
        return Files.getSvgFile(shape.toString());
    }

    public static File getSvgFile(String shape) {
        return new File(Files.shapesDir(), shape.toLowerCase() + ".svg");
    }

    public static File getImageFile(String shape) {
        File f = new File(Files.shapesDir(), shape);
        if (f.exists()) {
            return f;
        }
        f = new File(Files.shapesDir() + ".svg", shape);
        if (f.exists()) {
            return f;
        }
        f = new File(Files.shapesDir(), shape.toLowerCase() + ".svg");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    static Vector<String> listAllShapesRecursively() throws IOException {
        return Files.listAllShapesRecursively("", Files.shapesDir());
    }

    static Vector<String> listAllShapesRecursively(String prefix, File dir) throws IOException {
        File[] files;
        String ext = ".svg";
        Vector<String> v = new Vector<String>();
        if (!dir.canRead()) {
            throw new IOException("Directory not readable: " + dir);
        }
        Logging.info("Reading dir: " + dir);
        for (File cf : files = dir.listFiles()) {
            String fname = cf.getName();
            if (cf.isDirectory()) {
                v.addAll(Files.listAllShapesRecursively(prefix + fname + "/", cf));
                continue;
            }
            if (!cf.isFile() || !fname.endsWith(".svg")) continue;
            v.add(prefix + fname.substring(0, fname.length() - ".svg".length()));
        }
        return v;
    }

    public static String[] listSAllExperimentPlans() throws IOException {
        return Files.listSAllExperimentPlansInTree(null);
    }

    public static String[] listSAllExperimentPlansInTree(String subdir) throws IOException {
        File root = Files.trialListMainDir();
        if (subdir != null && subdir.length() > 0) {
            root = new File(root, subdir);
        }
        Object[] a = Files.listAllExperimentPlanDirsInTree(root);
        Arrays.sort(a);
        if (subdir != null && subdir.length() > 0) {
            for (int j = 0; j < a.length; ++j) {
                a[j] = subdir + "/" + (String)a[j];
            }
        }
        return a;
    }

    private static String[] listAllExperimentPlanDirsInTree(File root) throws IOException {
        File[] files = root.listFiles();
        if (files == null) {
            throw new IOException("Cannot read directory " + root);
        }
        Vector<Object> v = new Vector<Object>();
        for (File cf : files) {
            if (!cf.isDirectory()) continue;
            String fname = cf.getName();
            if (TrialList.listTrialLists(cf).size() > 0) {
                v.add(fname);
            }
            for (String x : Files.listAllExperimentPlanDirsInTree(cf)) {
                v.add(fname + File.separator + x);
            }
        }
        return v.toArray(new String[0]);
    }

    public static String[] listAllRuleSetsInTree(String s) throws IOException {
        File root = new File(inputDir, "rules");
        if (s.length() > 0) {
            root = new File(root, s);
        }
        Object[] w = Files.listAllRuleSetsInTree(root);
        Arrays.sort(w);
        if (s.length() > 0) {
            for (int j = 0; j < w.length; ++j) {
                w[j] = s + "/" + (String)w[j];
            }
        }
        return w;
    }

    private static String[] listAllRuleSetsInTree(File root) throws IOException {
        if (!root.isDirectory()) {
            throw new IOException(root + " is not a directory");
        }
        File[] files = root.listFiles();
        Vector<Object> v = new Vector<Object>();
        for (File cf : files) {
            String fname = cf.getName();
            if (cf.isDirectory()) {
                for (String x : Files.listAllRuleSetsInTree(cf)) {
                    v.add(fname + File.separator + x);
                }
                continue;
            }
            if (!cf.isFile() || !fname.endsWith(RULES_EXT)) continue;
            v.add(fname.substring(0, fname.length() - RULES_EXT.length()));
        }
        return v.toArray(new String[0]);
    }

    public static String listSAllExperimentPlansHtml() throws IOException {
        Vector<String> v = new Vector<String>();
        for (String exp : Files.listSAllExperimentPlans()) {
            v.add(Tools.radio("exp", exp, exp, false));
        }
        return String.join((CharSequence)"<br>\n", v);
    }

    static File launchDir() {
        return new File(inputDir, "launch");
    }

    public static File getLaunchFileAPP() {
        return new File(Files.launchDir(), "launch-app.csv");
    }

    public static File getLaunchFileMLC() {
        return new File(Files.launchDir(), "launch-mlc.csv");
    }

    public static File modifierFile(String modifierName) throws IOException {
        if (modifierName == null || modifierName.equals("")) {
            throw new IOException("Modifier name not specified");
        }
        return Files.inputFile(modifierName, "modifiers", ".csv");
    }
}

