/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.FileWriteReport;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.NewEpisodeWrapper;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.rest.PlayerResponse;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.Piece;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.Vector;
import javax.json.JsonObject;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/GameService")
public class GameService {
    Episode dummyEpisode = new Episode();

    @GET
    @Path(value="/pieceX")
    @Produces(value={"application/xml"})
    public Piece getPiece1() {
        Piece p = new Piece(Piece.Shape.SQUARE, Piece.Color.BLACK, 0, 0);
        return p;
    }

    @GET
    @Path(value="/piece")
    @Produces(value={"application/json"})
    public Piece getPiece2() {
        Piece p = new Piece(Piece.Shape.SQUARE, Piece.Color.BLACK, 0, 0);
        return p;
    }

    @GET
    @Path(value="/boardX")
    @Produces(value={"application/xml"})
    public Board getBoard1() {
        return new Board();
    }

    @GET
    @Path(value="/board")
    @Produces(value={"application/json"})
    public Board getBoard2() {
        return new Board();
    }

    @GET
    @Path(value="/hello1")
    @Produces(value={"application/json"})
    public String getHello1() {
        Board b = new Board();
        return "Hello: " + b.toString();
    }

    @GET
    @Path(value="/hello2")
    @Produces(value={"application/json"})
    public String getHello2() {
        Board b = new Board();
        JsonObject jo = JsonReflect.reflectToJSONObject(b, true);
        return "Hello: " + jo.toString();
    }

    @POST
    @Path(value="/getBoard")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Board getBoard(@FormParam(value="id") String id) {
        EntityManager em = Main.getEM();
        Board b = (Board)em.find(Board.class, (Object)id);
        if (b == null) {
            return null;
        }
        return b;
    }

    @POST
    @Path(value="/saveBoard")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Board saveBoard(Board b) {
        System.out.println("saveBoard(" + b.getName() + ")");
        b.persistNewBoard();
        return b;
    }

    @POST
    @Path(value="/writeFile")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public FileWriteReport writeFile(@FormParam(value="dir") String dir, @FormParam(value="file") String file, @FormParam(value="append") String appendString, @FormParam(value="data") String data) {
        try {
            boolean append;
            boolean bl = append = appendString != null && appendString.trim().equalsIgnoreCase("true");
            if (file == null) {
                throw new IOException("File name not specified");
            }
            if ((file = file.trim()).length() == 0) {
                throw new IOException("Empty file name");
            }
            if (data == null) {
                throw new IOException("No data supplied");
            }
            String[] pp = dir == null ? new String[]{} : dir.trim().split("/");
            File d = Files.savedDir;
            if (pp.length > 0) {
                for (String p : pp) {
                    if (p.length() == 0) continue;
                    if (p.startsWith(".") || p.indexOf("..") >= 0) {
                        throw new IOException("Invalid path: " + dir);
                    }
                    d = new File(d, p);
                }
            }
            Files.testWriteDir(d);
            File f = new File(d, file);
            if (f.exists() && !append) {
                throw new IOException("File already exists, and append=" + append + ": " + f);
            }
            PrintWriter w = new PrintWriter(new FileWriter(f, append));
            w.print(data);
            w.close();
            return new FileWriteReport(f, f.length());
        }
        catch (IOException ex) {
            FileWriteReport r = new FileWriteReport();
            r.setError(true);
            r.setErrmsg(ex.getMessage());
            return r;
        }
    }

    @GET
    @Path(value="/getParaSet")
    @Produces(value={"application/json"})
    public ParaSet getParam(@QueryParam(value="name") String name) {
        return new ParaSet(name);
    }

    @POST
    @Path(value="/newEpisode")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public NewEpisodeWrapper newEpisode(@FormParam(value="rules") String rules, @DefaultValue(value="0") @FormParam(value="pieces") int pieces, @DefaultValue(value="0") @FormParam(value="shapes") int shapes, @DefaultValue(value="0") @FormParam(value="colors") int colors, @DefaultValue(value="null") @FormParam(value="board") String boardName) {
        return new NewEpisodeWrapper(rules, pieces, shapes, colors, boardName);
    }

    @GET
    @Path(value="/display")
    @Produces(value={"application/json"})
    public Episode.Display display(@QueryParam(value="episode") String episodeId) {
        Episode epi = EpisodeInfo.locateEpisode(episodeId);
        if (epi == null) {
            Episode episode = this.dummyEpisode;
            Objects.requireNonNull(episode);
            return new Episode.Display(episode, -6, "# Invalid episode ID");
        }
        Episode episode = epi;
        Objects.requireNonNull(episode);
        return new Episode.Display(episode, -8, "Display requested");
    }

    @POST
    @Path(value="/move")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Episode.Display move(@FormParam(value="episode") String episodeId, @FormParam(value="x") int x, @FormParam(value="y") int y, @FormParam(value="bx") int bx, @FormParam(value="by") int by, @FormParam(value="cnt") int cnt) {
        Episode epi = EpisodeInfo.locateEpisode(episodeId);
        if (epi == null) {
            Episode episode = this.dummyEpisode;
            Objects.requireNonNull(episode);
            return new Episode.Display(episode, -6, "# Invalid episode ID");
        }
        try {
            return epi.doMove(y, x, by, bx, cnt);
        }
        catch (IOException ex) {
            Episode episode = epi;
            Objects.requireNonNull(episode);
            return new Episode.Display(episode, -2, ex.getMessage());
        }
    }

    @POST
    @Path(value="/startTrial")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public PlayerResponse startTrial(@FormParam(value="playerId") String playerId, @DefaultValue(value="null") @FormParam(value="exp") String exp) {
        return new PlayerResponse(playerId, exp, -1);
    }

    @GET
    @Path(value="/listRules")
    @Produces(value={"application/json"})
    public Vector<String> listRules() {
        try {
            return Files.listInputs("rules", ".txt");
        }
        catch (IOException ex) {
            return null;
        }
    }

    @GET
    @Path(value="/listInitialBoards")
    @Produces(value={"application/json"})
    public Vector<String> listInitialBoards() {
        try {
            return Files.listInputs("boards", ".json");
        }
        catch (IOException ex) {
            return null;
        }
    }

    @GET
    @Path(value="/getParaSetHtml")
    @Produces(value={"text/html"})
    public String getParamHtml(@QueryParam(value="name") String name) {
        ParaSet para = this.getParam(name);
        String s = "Para:<br><em>" + para + "</em>";
        s = "<html><body>" + s + "</body></html>";
        return s;
    }
}

