/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.ActivateBonusWrapper;
import edu.wisc.game.rest.ColorMap;
import edu.wisc.game.rest.FileWriteReport;
import edu.wisc.game.rest.GiveUpWrapper;
import edu.wisc.game.rest.GuessWriteReport;
import edu.wisc.game.rest.ListShapesWrapper;
import edu.wisc.game.rest.NewEpisodeWrapper2;
import edu.wisc.game.rest.PlayerResponse;
import edu.wisc.game.rest.UserResponse;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.util.Logging;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/GameService2")
public class GameService2 {
    private static Episode dummyEpisode = new Episode();

    @POST
    @Path(value="/registerUser")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public UserResponse registerUser(@DefaultValue(value="null") @FormParam(value="email") String email, @DefaultValue(value="null") @FormParam(value="nickname") String nickname, @DefaultValue(value="false") @FormParam(value="anon") boolean anon) {
        return new UserResponse(email, nickname, anon);
    }

    @POST
    @Path(value="/player")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public PlayerResponse player(@DefaultValue(value="null") @FormParam(value="playerId") String playerId, @DefaultValue(value="null") @FormParam(value="exp") String exp, @DefaultValue(value="-1") @FormParam(value="uid") int uid) {
        return new PlayerResponse(playerId, exp, uid);
    }

    @POST
    @Path(value="/mostRecentEpisode")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public NewEpisodeWrapper2 mostRecentEpisode(@FormParam(value="playerId") String playerId) {
        return new NewEpisodeWrapper2(playerId, true, false, false);
    }

    @POST
    @Path(value="/newEpisode")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public NewEpisodeWrapper2 newEpisode(@FormParam(value="playerId") String playerId, @DefaultValue(value="false") @FormParam(value="activateBonus") boolean activateBonus, @DefaultValue(value="false") @FormParam(value="giveUp") boolean giveUp) {
        return new NewEpisodeWrapper2(playerId, false, activateBonus, giveUp);
    }

    @GET
    @Path(value="/display")
    @Produces(value={"application/json"})
    public Episode.Display display(@QueryParam(value="episode") String episodeId) {
        Episode epi = EpisodeInfo.locateEpisode(episodeId);
        if (epi == null) {
            Episode episode = dummyEpisode;
            Objects.requireNonNull(episode);
            return new Episode.Display(episode, -6, "# Invalid episode ID");
        }
        return epi.mkDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/move")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Episode.Display move(@FormParam(value="episode") String episodeId, @FormParam(value="x") int x, @FormParam(value="y") int y, @FormParam(value="bx") int bx, @FormParam(value="by") int by, @FormParam(value="cnt") int cnt) {
        Episode.Display rv = null;
        Episode epi = EpisodeInfo.locateEpisode(episodeId);
        if (epi == null) {
            Episode episode = dummyEpisode;
            Objects.requireNonNull(episode);
            return new Episode.Display(episode, -6, "# Invalid episode ID: " + episodeId);
        }
        try {
            Episode.Display display = rv = epi.doMove(y, x, by, bx, cnt);
            return display;
        }
        catch (Exception ex) {
            System.err.print("/move: " + ex);
            ex.printStackTrace(System.err);
            Episode episode = epi;
            Objects.requireNonNull(episode);
            Episode.Display display = rv = new Episode.Display(episode, -2, ex.getMessage());
            return display;
        }
        finally {
            Logging.info("move(epi=" + episodeId + ", (" + x + "," + y + ") to (" + bx + "," + by + "), cnt=" + cnt + "), return " + JsonReflect.reflectToJSONObject(rv, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/pick")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Episode.Display move(@FormParam(value="episode") String episodeId, @FormParam(value="x") int x, @FormParam(value="y") int y, @FormParam(value="cnt") int cnt) {
        Episode.Display rv = null;
        Episode epi = EpisodeInfo.locateEpisode(episodeId);
        if (epi == null) {
            Episode episode = dummyEpisode;
            Objects.requireNonNull(episode);
            return new Episode.Display(episode, -6, "# Invalid episode ID: " + episodeId);
        }
        try {
            Episode.Display display = rv = epi.doPick(y, x, cnt);
            return display;
        }
        catch (Exception ex) {
            System.err.print("/pick: " + ex);
            ex.printStackTrace(System.err);
            Episode episode = epi;
            Objects.requireNonNull(episode);
            Episode.Display display = rv = new Episode.Display(episode, -2, ex.getMessage());
            return display;
        }
        finally {
            Logging.info("pick(epi=" + episodeId + ", (" + x + "," + y + "), cnt=" + cnt + "), return " + JsonReflect.reflectToJSONObject(rv, true));
        }
    }

    @POST
    @Path(value="/activateBonus")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public ActivateBonusWrapper activateBonus(@FormParam(value="playerId") String playerId) {
        return new ActivateBonusWrapper(playerId);
    }

    @POST
    @Path(value="/giveUp")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public GiveUpWrapper giveUp(@FormParam(value="playerId") String playerId, @FormParam(value="seriesNo") int seriesNo) {
        return new GiveUpWrapper(playerId);
    }

    @POST
    @Path(value="/guess")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public FileWriteReport guess(@FormParam(value="episode") String episodeId, @FormParam(value="data") String text, @DefaultValue(value="-1") @FormParam(value="confidence") int confidence) {
        return GuessWriteReport.writeGuess(episodeId, text, confidence);
    }

    @GET
    @Path(value="/colorMap")
    @Produces(value={"application/json"})
    public ColorMap colorMap() {
        return new ColorMap();
    }

    @GET
    @Path(value="/listShapes")
    @Produces(value={"application/json"})
    public ListShapesWrapper listShapes() {
        return new ListShapesWrapper();
    }

    @GET
    @Path(value="/getVersion")
    @Produces(value={"application/json"})
    public String getVersion() {
        return "4.002";
    }
}

