/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.formatter.HTMLFmter;
import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.ActivateBonusWrapper;
import edu.wisc.game.rest.FileWriteReport;
import edu.wisc.game.rest.GameService2;
import edu.wisc.game.rest.GiveUpWrapper;
import edu.wisc.game.rest.GuessWriteReport;
import edu.wisc.game.rest.NewEpisodeWrapper2;
import edu.wisc.game.rest.PlayerResponse;
import edu.wisc.game.rest.ResponseBase;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.PlayerInfo;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/GameService2Html")
public class GameService2Html
extends GameService2 {
    private static HTMLFmter fm = new HTMLFmter(null);

    @POST
    @Path(value="/playerHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String playerHtml(@DefaultValue(value="null") @FormParam(value="playerId") String playerId, @DefaultValue(value="null") @FormParam(value="exp") String exp, @DefaultValue(value="-1") @FormParam(value="uid") int uid) {
        PlayerResponse pr = new PlayerResponse(playerId, exp, uid);
        Vector<Object> v = new Vector<Object>();
        boolean canPlay = false;
        v.add("Response: " + fm.para("" + JsonReflect.reflectToJSONObject(pr, true)));
        Object title = "?";
        if (pr.getError()) {
            v.add(fm.para("Error happened: " + pr.getErrmsg()));
            title = "Error";
        } else if (pr.getNewlyRegistered()) {
            v.add(fm.para("Successfully registered new player"));
            canPlay = true;
            title = "Registered player " + playerId;
        } else if (pr.getExperimentPlan().equals(exp) && !pr.getAlreadyFinished()) {
            v.add(fm.para("This player already exists, but it is associated with the same experiment plan, and you can play more episodes"));
            canPlay = true;
            title = "Reusing player " + playerId;
        } else {
            v.add(fm.para("A player with this name already exists; experimentPlan=" + pr.getExperimentPlan() + "; alreadyFinished=" + pr.getAlreadyFinished()));
            title = "Player " + playerId + " already exists";
        }
        if (canPlay) {
            Object form = "Now, you can start (or resume) playing!<br>";
            form = (String)form + fm.hidden("playerId", playerId) + fm.br();
            form = (String)form + "<button type='submit'>Play an episode!</button>";
            form = fm.wrap("form", "method='post' action='newEpisodeHtml'", (String)form);
            v.add(fm.para((String)form));
        }
        String body = String.join((CharSequence)"\n", v);
        return fm.html((String)title, body);
    }

    @POST
    @Path(value="/mostRecentEpisodeHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String mostRecentEpisodeHtml(@FormParam(value="playerId") String playerId) {
        return this.newOrRecentEpisodeHtml(playerId, true, false, false);
    }

    @POST
    @Path(value="/newEpisodeHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String newEpisodeHtml(@FormParam(value="playerId") String playerId, @DefaultValue(value="false") @FormParam(value="activateBonus") boolean activateBonus, @DefaultValue(value="false") @FormParam(value="giveUp") boolean giveUp) {
        return this.newOrRecentEpisodeHtml(playerId, false, activateBonus, giveUp);
    }

    private String newOrRecentEpisodeHtml(String playerId, boolean recent, boolean activateBonus, boolean giveUp) {
        ResponseBase w;
        Object body = "";
        if (activateBonus) {
            w = new ActivateBonusWrapper(playerId);
            body = (String)body + fm.h4("Activate") + fm.para("" + JsonReflect.reflectToJSONObject(w, true)) + fm.hr();
        }
        if (giveUp) {
            w = new GiveUpWrapper(playerId);
            body = (String)body + fm.h4("Give up") + fm.para("" + JsonReflect.reflectToJSONObject(w, true)) + fm.hr();
        }
        w = new NewEpisodeWrapper2(playerId, recent, false, false);
        String episodeId = ((NewEpisodeWrapper2)w).getEpisodeId();
        String head = episodeId + " : " + (recent ? "mostRecentEpisode" : "newEpisode");
        body = (String)body + fm.h4("Response") + fm.para("" + JsonReflect.reflectToJSONObject(w, true));
        body = (String)body + fm.hr();
        EpisodeInfo epi = (EpisodeInfo)EpisodeInfo.locateEpisode(episodeId);
        body = w.getError() ? (((NewEpisodeWrapper2)w).getAlreadyFinished() ? (String)body + fm.para("The player has finished all episodes. Completion code = " + ((NewEpisodeWrapper2)w).getCompletionCode()) : (String)body + fm.para("Error: " + w.getErrmsg())) : (String)body + GameService2Html.moveForm(((NewEpisodeWrapper2)w).getDisplay(), episodeId);
        return fm.html(head, (String)body);
    }

    @POST
    @Path(value="/moveHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String moveHtml(@FormParam(value="episode") String episodeId, @FormParam(value="x") int x, @FormParam(value="y") int y, @FormParam(value="bx") int bx, @FormParam(value="by") int by, @FormParam(value="cnt") int cnt) {
        Episode.Display d = this.move(episodeId, x, y, bx, by, cnt);
        String head = episodeId + " : MOVE " + x + " " + y + " " + bx + " " + by;
        Object body = "";
        body = (String)body + fm.h1(head);
        body = (String)body + fm.h4("Response") + fm.para("" + JsonReflect.reflectToJSONObject(d, true));
        body = (String)body + fm.hr();
        body = (String)body + GameService2Html.moveForm(d, episodeId);
        return fm.html(head, (String)body);
    }

    @POST
    @Path(value="/pickHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String pickHtml(@FormParam(value="episode") String episodeId, @FormParam(value="x") int x, @FormParam(value="y") int y, @FormParam(value="cnt") int cnt) {
        Episode.Display d = this.move(episodeId, x, y, cnt);
        String head = episodeId + " : PICK " + x + " " + y;
        Object body = "";
        body = (String)body + fm.h1(head);
        body = (String)body + fm.h4("Response") + fm.para("" + JsonReflect.reflectToJSONObject(d, true));
        body = (String)body + fm.hr();
        body = (String)body + GameService2Html.moveForm(d, episodeId);
        return fm.html(head, (String)body);
    }

    private static String showHistoryAndPosition(EpisodeInfo epi, EpisodeInfo.ExtendedDisplay d) {
        Object body;
        if (epi == null) {
            body = fm.para("No episode in memory");
        } else {
            body = fm.h4("Player's history") + fm.para("All episodes, completed and incomplete, are listed below, one series per line. The format for each episode is:<br>[EpisodeID; FC=finishCode g-if-guess-saved; MainOrBonus; moveCnt/initPieceCnt; $reward]") + fm.wrap("pre", epi.getPlayer().report()) + fm.hr() + fm.h4("Current position") + fm.para(epi.graphicDisplay(true));
            if (epi.isBonus()) {
                DecimalFormat df = new DecimalFormat("#.##");
                body = (String)body + fm.para("Moves left: " + df.format(d.getMovesLeftToStayInBonus()));
            }
        }
        return (String)body + fm.hr();
    }

    private static String moveForm(Episode.Display _d, String episodeId) {
        if (!(_d instanceof EpisodeInfo.ExtendedDisplay)) {
            return fm.para("Cannot cast to  EpisodeInfo.ExtendedDisplay");
        }
        EpisodeInfo.ExtendedDisplay d = (EpisodeInfo.ExtendedDisplay)_d;
        Object body = "";
        EpisodeInfo epi = (EpisodeInfo)EpisodeInfo.locateEpisode(episodeId);
        body = (String)body + GameService2Html.showHistoryAndPosition(epi, d);
        if (d.getFinishCode() == 0) {
            Vector<String> cells = new Vector<String>();
            Object formA = "";
            formA = (String)formA + fm.hidden("episode", episodeId);
            formA = (String)formA + fm.hidden("cnt", "" + d.getNumMovesMade());
            Object form = formA = (String)formA + "x = " + fm.input("x", null, 2) + "; y = " + fm.input("y", null, 2) + fm.br();
            form = (String)form + "Bucket x = " + fm.input("bx", null, 2) + "; Bucket y = " + fm.input("by", null, 2) + fm.br();
            form = (String)form + "<input type='submit'>";
            form = fm.wrap("form", "method='post' action='moveHtml'", (String)form);
            form = fm.h4("Your next move") + fm.para((String)form);
            cells.add((String)form);
            if (epi.xgetPara().isFeedbackSwitchesFree()) {
                form = formA;
                form = (String)form + "<input type='submit'>";
                form = fm.wrap("form", "method='post' action='pickHtml'", (String)form);
                form = fm.h4("or, Try to pick a piece to see if it's moveable") + fm.para((String)form);
                cells.add((String)form);
            }
            body = (String)body + fm.table("border='1'", fm.rowExtra("valign='top'", cells));
        } else {
            body = (String)body + fm.para("Game over - no move possible. Finish code=" + d.getFinishCode());
        }
        body = (String)body + fm.hr();
        if (d.getFinishCode() != 0 && !d.getGuessSaved()) {
            Object form = "";
            form = (String)form + "episode = " + fm.input("episode", episodeId) + fm.br();
            form = (String)form + "Enter your guess below:" + fm.br() + fm.input("data", null, 80) + fm.br() + "Confidence=" + fm.input("confidence", "5", 2) + fm.br();
            form = (String)form + "<input type='submit'>";
            form = fm.wrap("form", "method='post' action='guessHtml'", (String)form);
            form = fm.h4("Your guess") + fm.para((String)form);
            body = (String)body + (String)form + fm.hr();
        }
        return body;
    }

    @POST
    @Path(value="/guessHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String guessHtml(@FormParam(value="episode") String episodeId, @FormParam(value="data") String guessText, @DefaultValue(value="-1") @FormParam(value="confidence") int confidence) {
        FileWriteReport _r = GuessWriteReport.writeGuess(episodeId, guessText, confidence);
        EpisodeInfo epi = (EpisodeInfo)EpisodeInfo.locateEpisode(episodeId);
        if (epi == null) {
            String msg = "Episode not loaded: " + episodeId;
            return fm.html(msg, msg);
        }
        PlayerInfo x = epi.getPlayer();
        String head = episodeId + " : Guess";
        Object body = "";
        body = (String)body + fm.h4("Response") + fm.para("" + JsonReflect.reflectToJSONObject(_r, true));
        body = (String)body + fm.hr();
        body = (String)body + fm.h4("What the player can do next");
        if (_r instanceof GuessWriteReport && epi != null) {
            GuessWriteReport r = (GuessWriteReport)_r;
            PlayerInfo.TransitionMap map = r.getTransitionMap();
            Vector<String> rows = new Vector<String>();
            for (PlayerInfo.Transition key : map.keySet()) {
                PlayerInfo.Action val = (PlayerInfo.Action)((Object)map.get((Object)key));
                Vector<String> v = new Vector<String>();
                v.add("" + key);
                v.add("" + val);
                String action = "newEpisodeHtml";
                String form = "<form method='post' action='" + action + "'>\n";
                form = form + fm.hidden("playerId", x.getPlayerId());
                if (val == PlayerInfo.Action.ACTIVATE) {
                    form = form + fm.hidden("activateBonus", "true");
                } else if (val == PlayerInfo.Action.GIVE_UP) {
                    form = form + fm.hidden("giveUp", "true");
                }
                String text = key == PlayerInfo.Transition.MAIN ? "Next episode (non-bonus)" : (key == PlayerInfo.Transition.BONUS ? (val == PlayerInfo.Action.ACTIVATE ? "Activate Bonus" : "Next bonus episode") : (key == PlayerInfo.Transition.NEXT ? (val == PlayerInfo.Action.DEFAULT ? "Start the next series" : "Give up on this series and start the next") : (key == PlayerInfo.Transition.END ? (val == PlayerInfo.Action.DEFAULT ? "Finish" : "Give up on this (last) series and end the expriment") : "Error - unknown action")));
                form = form + "<input type='submit'></form>\n";
                v.add(text);
                v.add(form);
                rows.add(fm.row(v));
            }
            body = (String)body + fm.wrap("table", "border=1", String.join((CharSequence)"\n", rows)) + fm.br();
        }
        return fm.html(head, (String)body);
    }

    private String transitionButton(String action, String episodeId, String text) {
        return "<form method='post' action='" + action + "'><strong>" + text + "</strong><input type='submit'></form>";
    }
}

