/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.formatter.HTMLFmter;
import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.GameService;
import edu.wisc.game.rest.NewEpisodeWrapper;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import java.util.Vector;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/GameServiceHtml")
public class GameServiceHtml
extends GameService {
    private static HTMLFmter fm = new HTMLFmter(null);

    @POST
    @Path(value="/newEpisodeHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String newEpisodeHtml(@FormParam(value="rules") String rules, @DefaultValue(value="0") @FormParam(value="pieces") int pieces, @DefaultValue(value="0") @FormParam(value="shapes") int shapes, @DefaultValue(value="0") @FormParam(value="colors") int colors, @DefaultValue(value="null") @FormParam(value="board") String boardName) {
        boolean recent = false;
        Object body = "";
        NewEpisodeWrapper w = new NewEpisodeWrapper(rules, pieces, shapes, colors, boardName);
        String episodeId = w.getEpisodeId();
        String head = episodeId + " : newEpisode";
        body = (String)body + fm.h3("The server response") + fm.para("" + JsonReflect.reflectToJSONObject(w, true));
        body = (String)body + fm.hr();
        Episode epi = EpisodeInfo.locateEpisode(episodeId);
        body = w.getError() ? (String)body + fm.para("Error: " + w.getErrmsg()) : (String)body + GameServiceHtml.moveForm(w.getDisplay(), episodeId);
        return fm.html(head, (String)body);
    }

    @POST
    @Path(value="/moveHtml")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String moveHtml(@FormParam(value="episode") String episodeId, @FormParam(value="x") int x, @FormParam(value="y") int y, @FormParam(value="bx") int bx, @FormParam(value="by") int by, @FormParam(value="cnt") int cnt) {
        Episode.Display d = this.move(episodeId, x, y, bx, by, cnt);
        String head = episodeId + " : MOVE " + x + " " + y + " " + bx + " " + by;
        Object body = "";
        body = (String)body + fm.h3("Server esponse") + fm.para("" + JsonReflect.reflectToJSONObject(d, true));
        body = (String)body + fm.hr();
        body = (String)body + GameServiceHtml.moveForm(d, episodeId);
        return fm.html(head, (String)body);
    }

    private static String showHistoryAndPosition(Episode.Display d, Episode epi) {
        Object body = "";
        if (epi == null) {
            body = (String)body + fm.para("No episode in memory");
        } else {
            body = (String)body + fm.h3("The rule set");
            RuleSet.ReportedSrc rs = d.getRulesSrc();
            Vector<String> orders = rs.getOrders();
            Vector<String> rows = rs.getRows();
            body = (String)body + fm.h4(orders.size() + " orders");
            if (orders.size() > 0) {
                body = (String)body + fm.wrap("ol", "\n<li>" + String.join((CharSequence)"\n<li>", orders));
            }
            Vector<String> v = new Vector<String>();
            for (int j = 0; j < rows.size(); ++j) {
                Object s = rows.get(j);
                if (j == d.getRuleLineNo()) {
                    s = (String)s + fm.br() + fm.em("[Current counters: " + d.getExplainCounters() + "]");
                    s = fm.colored("red", (String)s);
                }
                v.add(fm.wrap("li", (String)s));
            }
            body = (String)body + fm.h4(rows.size() + " rule lines") + fm.wrap("ol", String.join((CharSequence)"\n", v));
            body = (String)body + fm.hr();
            body = (String)body + fm.h3("The current board position") + fm.pre(epi.graphicDisplay(true));
            body = (String)body + fm.para(fm.a("../../help-display.html", "[Help]"));
        }
        return (String)body + fm.hr();
    }

    private static String moveForm(Episode.Display d, String episodeId) {
        Object body = "";
        Episode epi = EpisodeInfo.locateEpisode(episodeId);
        body = (String)body + GameServiceHtml.showHistoryAndPosition(d, epi);
        Object form = "";
        if (d.getFinishCode() == 0) {
            form = (String)form + "episode = " + fm.input("episode", episodeId) + fm.br();
            form = (String)form + "x = " + fm.input("x", null, 2) + "; y = " + fm.input("y", null, 2) + fm.br();
            form = (String)form + "Bucket x = " + fm.input("bx", null, 2) + "; Bucket y = " + fm.input("by", null, 2) + fm.br();
            form = (String)form + "Don't modify this field: cnt = " + fm.input("cnt", "" + d.getNumMovesMade()) + fm.br();
            form = (String)form + "<input type='submit'>";
            form = fm.wrap("form", "method='post' action='moveHtml'", (String)form);
            form = fm.h3("Your next move") + fm.para((String)form);
        } else {
            form = fm.para("Game over - no move possible. The finish code is " + d.getFinishCode());
        }
        body = (String)body + (String)form + fm.hr();
        return body;
    }
}

