/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.Files;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetImageServlet
extends HttpServlet {
    private static String[] mimeExtAndType = new String[]{"svg", "image/svg+xml", "png", "image/png", "jpeg", "image/jpeg", "jpg", "image/jpeg", "gif", "image/gif", "bmp", "image/bmp", "ico", "image/vnd.microsoft.icon", "tiff", "image/tiff"};
    private static HashMap<String, String> mimeTypes = Util.array2map(mimeExtAndType);

    public void service(HttpServletRequest request, HttpServletResponse response) {
        try {
            int aByte;
            String shape = request.getParameter("image");
            if (shape == null) {
                throw new IllegalArgumentException("Must specify image=...");
            }
            File f = Files.getImageFile(shape);
            if (f == null) {
                throw new IOException("No matching file exists for image=" + shape);
            }
            if (!f.isFile() || !f.canRead()) {
                throw new IOException("Cannot read file " + f);
            }
            String s = f.getName().toLowerCase();
            String[] q = s.split("\\.");
            String mime = mimeTypes.get(q[q.length - 1]);
            if (mime == null) {
                mime = "application/octet-stream";
            }
            response.setContentType(mime);
            response.setContentLengthLong(f.length());
            FileInputStream fileInputStream = new FileInputStream(f);
            ServletOutputStream out = response.getOutputStream();
            while ((aByte = fileInputStream.read()) != -1) {
                out.write(aByte);
            }
            fileInputStream.close();
            out.close();
        }
        catch (Exception e) {
            try {
                e.printStackTrace(System.out);
                response.sendError(500, "Error in GetImageServlet: " + e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

