/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.Files;
import edu.wisc.game.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetSvgWrapper {
    public GetSvgWrapper(HttpServletRequest request, HttpServletResponse response, Writer outw) {
        try {
            int x;
            String shape = request.getParameter("shape");
            if (shape == null) {
                throw new IllegalArgumentException("Must specify shape=...");
            }
            File f = Files.getSvgFile(shape);
            if (!f.canRead()) {
                throw new IOException("Cannot read file: " + f);
            }
            response.setContentType("image/svg+xml");
            FileInputStream r = new FileInputStream(f);
            while ((x = r.read()) != -1) {
                outw.write(x);
            }
            r.close();
        }
        catch (Exception ex) {
            try {
                response.setContentType("text/html");
                response.sendError(404, "Error: " + ex.getMessage());
            }
            catch (Exception ex2) {
                Logging.error("GetSvgWrapper: Cannot send an error code to the client: " + ex2);
            }
        }
    }
}

