/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.PlayerResponse;
import edu.wisc.game.rest.ResponseBase;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.util.Logging;

public class GiveUpWrapper
extends ResponseBase {
    GiveUpWrapper(String pid) {
        this(pid, -1);
    }

    GiveUpWrapper(String pid, int seriesNo) {
        Logging.info("GiveUpWrapper(pid=" + pid + ", seriesNo=" + seriesNo + ")");
        try {
            PlayerInfo x = PlayerResponse.findPlayerInfo(null, pid);
            if (x == null) {
                this.setError(true);
                this.setErrmsg("Player not found: " + pid);
                return;
            }
            if (seriesNo < 0) {
                seriesNo = x.getCurrentSeriesNo();
            }
            x.giveUp(seriesNo);
            this.setError(false);
            this.setErrmsg("Gave up series " + seriesNo);
        }
        catch (Exception ex) {
            this.setError(true);
            this.setErrmsg(ex.getMessage());
            System.err.print(ex);
            ex.printStackTrace(System.err);
        }
    }
}

