/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.FileWriteReport;
import edu.wisc.game.rest.Files;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.PlayerInfo;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GuessWriteReport
extends FileWriteReport {
    PlayerInfo.TransitionMap transitionMap;

    public PlayerInfo.TransitionMap getTransitionMap() {
        return this.transitionMap;
    }

    GuessWriteReport(File f, long _byteCnt) {
        super(f, _byteCnt);
    }

    static FileWriteReport writeGuess(String episodeId, String text, int guessConfidence) {
        try {
            EpisodeInfo epi;
            Pattern p;
            Matcher m;
            if (text == null) {
                return new FileWriteReport(true, "No guess text supplied");
            }
            if (guessConfidence < 0 && (m = (p = Pattern.compile("^([0-9]+):\\s*")).matcher(text)).find()) {
                guessConfidence = Integer.parseInt(m.group(1));
                text = text.substring(m.end());
            }
            if ((epi = (EpisodeInfo)EpisodeInfo.locateEpisode(episodeId)) == null) {
                return new FileWriteReport(true, "No such episode: " + episodeId);
            }
            PlayerInfo x = epi.getPlayer();
            String pid = x.getPlayerId();
            File f = Files.guessesFile(pid);
            epi.saveGuessToFile(f, text, guessConfidence);
            epi.setGuessSaved(true);
            epi.setGuess(text);
            if (guessConfidence >= 0) {
                epi.setGuessConfidence(guessConfidence);
            }
            x.saveMe();
            GuessWriteReport g = new GuessWriteReport(f, f.length());
            g.transitionMap = new PlayerInfo.TransitionMap(x);
            return g;
        }
        catch (IOException ex) {
            return new FileWriteReport(true, ex.getMessage());
        }
    }
}

