/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.ResponseBase;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.RandomRG;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.annotation.XmlElement;

public class NewEpisodeWrapper
extends ResponseBase {
    String episodeId = null;
    Board board = null;
    Episode.Display display;
    private static RandomRG random = new RandomRG();

    public String getEpisodeId() {
        return this.episodeId;
    }

    @XmlElement
    public void setEpisodeId(String _episodeId) {
        this.episodeId = _episodeId;
    }

    public Board getBoard() {
        return this.board;
    }

    @XmlElement
    public void setBoard(Board _b) {
        this.board = _b;
    }

    public Episode.Display getDisplay() {
        return this.display;
    }

    private void setDisplay(Episode.Display _display) {
        this.display = _display;
    }

    NewEpisodeWrapper(String ruleSetName, int nPieces, int nShapes, int nColors, String boardName) {
        try {
            Game game;
            if (ruleSetName == null || ruleSetName.trim().equals("")) {
                throw new IOException("No rules set specified");
            }
            ruleSetName = ruleSetName.trim();
            RuleSet rules = AllRuleSets.obtain(ruleSetName);
            if (boardName != null && boardName.trim().length() > 0 && !boardName.equalsIgnoreCase("null")) {
                File bf = Files.initialBoardFile(boardName = boardName.trim());
                if (!bf.canRead()) {
                    throw new IOException("Cannot read board file: " + bf);
                }
                Board board = Board.readBoard(bf);
                game = new Game(rules, board);
            } else {
                if (nPieces <= 0 || nPieces > 36) {
                    throw new IOException("Invalid #pieces=" + nPieces);
                }
                game = new Game(random, rules, nPieces, nShapes, nColors, Piece.Shape.legacyShapes, Piece.Color.legacyColors);
            }
            Episode epi = new Episode(game, Episode.OutputMode.BRIEF, null, null);
            this.board = epi.getCurrentBoard();
            this.episodeId = epi.episodeId;
            EpisodeInfo.globalAllEpisodes.put(this.episodeId, epi);
            this.setDisplay(epi.mkDisplay());
            this.setError(false);
        }
        catch (Exception ex) {
            System.err.print("NewServiceWrapper: " + ex);
            ex.printStackTrace(System.err);
            this.setError(true);
            this.setErrmsg(ex.getMessage());
        }
    }
}

