/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.ActivateBonusWrapper;
import edu.wisc.game.rest.GiveUpWrapper;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.rest.PlayerResponse;
import edu.wisc.game.rest.ResponseBase;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.util.Logging;

public class NewEpisodeWrapper2
extends ResponseBase {
    String episodeId = null;
    ParaSet para;
    boolean alreadyFinished;
    private String completionCode;
    Episode.Display display;

    public String getEpisodeId() {
        return this.episodeId;
    }

    public ParaSet getPara() {
        return this.para;
    }

    public boolean getAlreadyFinished() {
        return this.alreadyFinished;
    }

    public String getCompletionCode() {
        return this.completionCode;
    }

    public Episode.Display getDisplay() {
        return this.display;
    }

    private void setDisplay(Episode.Display _display) {
        this.display = _display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NewEpisodeWrapper2(String pid, boolean existing, boolean activateBonus, boolean giveUp) {
        Logging.info("NewEpisodeWrapper2(pid=" + pid + ", existing=" + existing + ", activate=" + activateBonus + ", gu=" + giveUp + ")");
        ResponseBase r = null;
        if (activateBonus) {
            r = new ActivateBonusWrapper(pid);
        }
        if (giveUp && (r == null || !r.getError())) {
            r = new GiveUpWrapper(pid);
        }
        if (r != null && r.getError()) {
            this.setError(true);
            this.setErrmsg(r.getErrmsg());
            return;
        }
        try {
            PlayerInfo x = PlayerResponse.findPlayerInfo(null, pid);
            Logging.info("NewEpisodeWrapper2(pid=" + pid + "): player=" + (String)(x == null ? "null" : "\n" + x.report()));
            if (x == null) {
                this.setError(true);
                this.setErrmsg("Player not found: " + pid);
                return;
            }
            EpisodeInfo epi = existing ? x.mostRecentEpisode() : x.episodeToDo();
            this.alreadyFinished = x.alreadyFinished();
            this.completionCode = x.getCompletionCode();
            if (epi == null) {
                this.setError(true);
                String msg = this.alreadyFinished ? "This player has completed all his parameter sets already" : (existing ? "Failed to find any episode!" : "Failed to find or create episode!");
                this.setErrmsg(msg);
                return;
            }
            this.para = x.getPara(epi);
            this.episodeId = epi.episodeId;
            this.setDisplay(epi.mkDisplay());
            this.setError(false);
        }
        catch (Exception ex) {
            this.setError(true);
            Object msg = ex.getMessage();
            if (msg == null) {
                msg = "Unknown internal error (" + ex + "); see stack trace in the server logs";
            }
            this.setErrmsg((String)msg);
            System.err.print(ex);
            ex.printStackTrace(System.err);
        }
        finally {
            Logging.info("NewEpisodeWrapper2(pid=" + pid + "): returning:\n" + JsonReflect.reflectToJSONObject(this, true));
        }
    }
}

