/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.ColorMap;
import edu.wisc.game.rest.Files;
import edu.wisc.game.sql.ImageObject;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ParaSet")
public class ParaSet
extends HashMap<String, Object> {
    public Piece.Shape[] shapes = Piece.Shape.legacyShapes;
    public Piece.Color[] colors = Piece.Color.legacyColors;
    public String[] images = null;

    public String getColors() {
        return Util.joinNonBlank(";", this.colors);
    }

    public String getShapes() {
        return Util.joinNonBlank(";", this.shapes);
    }

    public String getImages() {
        return this.images == null ? null : Util.joinNonBlank(";", this.images);
    }

    public static Piece.Shape[] parseShapes(String val) throws IOException {
        if (val == null) {
            return null;
        }
        String[] ss = (val = val.trim()).split(";");
        if (ss.length > 0) {
            Vector<Piece.Shape> shapes = new Vector<Piece.Shape>();
            for (int j = 0; j < ss.length; ++j) {
                String s = ss[j].trim();
                if (s.endsWith("/*")) {
                    String base = s.substring(0, s.length() - 2);
                    if (!ParaSet.isGoodColorName(base)) {
                        throw new IOException("Invalid shape subdirectory name '" + base + "', in '" + s + "'");
                    }
                    File d = new File(Files.shapesDir(), base);
                    if (!(d.exists() && d.isDirectory() && d.canRead())) {
                        throw new IOException("Cannot look for shapes in " + d + ", because there is no such directory, or it is not readable");
                    }
                    for (String z : Files.listInputs(d, ".svg")) {
                        Piece.Shape c = Piece.Shape.findShape(base + "/" + z);
                        shapes.add(c);
                    }
                    continue;
                }
                if (!ParaSet.isGoodColorName(s)) {
                    throw new IOException("Invalid shape name '" + s + "'");
                }
                Piece.Shape c = Piece.Shape.findShape(s);
                shapes.add(c);
            }
            return shapes.toArray(new Piece.Shape[0]);
        }
        return null;
    }

    public static Piece.Color[] parseColors(String val) throws IOException {
        if (val == null) {
            return null;
        }
        String[] ss = (val = val.trim()).split(";");
        if (ss.length > 0) {
            Piece.Color[] colors = new Piece.Color[ss.length];
            for (int j = 0; j < ss.length; ++j) {
                Piece.Color c;
                String s = ss[j].trim();
                if (!ParaSet.isGoodColorName(s)) {
                    throw new IOException("Invalid color name '" + s + "'");
                }
                colors[j] = c = Piece.Color.findColor(s);
            }
            return colors;
        }
        return null;
    }

    public static String[] parseImages(String val) throws IOException {
        if (val == null) {
            return null;
        }
        val = val.trim();
        String[] ss = val.split(";");
        Vector<String> w = new Vector<String>();
        if (ss.length > 0) {
            HashSet<String> h = new HashSet<String>();
            for (String s : ss) {
                Vector<ImageObject> v = ImageObject.obtainImageObjects(s);
                for (ImageObject io : v) {
                    String z = io.key;
                    if (h.contains(z)) continue;
                    h.add(z);
                    w.add(z);
                }
            }
        }
        if (w.size() == 0) {
            return null;
        }
        Object[] q = w.toArray(new String[0]);
        Arrays.sort(q);
        return q;
    }

    ParaSet(CsvData.BasicLineEntry header, CsvData.BasicLineEntry line) throws IOException {
        int nCol = header.nCol();
        if (nCol != line.nCol()) {
            throw new IOException("Column count mismatch:\nHEADER=" + header + ";\nLINE=" + line);
        }
        for (int k = 0; k < nCol; ++k) {
            String key = header.getCol(k);
            String val = line.getCol(k);
            if (val == null || val.length() == 0) continue;
            if (key.equals("colors")) {
                Piece.Color[] _colors = ParaSet.parseColors(val);
                if (_colors == null) continue;
                this.colors = _colors;
                continue;
            }
            if (key.equals("shapes")) {
                Piece.Shape[] _shapes = ParaSet.parseShapes(val);
                if (_shapes == null) continue;
                this.shapes = _shapes;
                continue;
            }
            if (key.equals("images")) {
                String[] _images = ParaSet.parseImages(val);
                if (_images == null) continue;
                this.images = _images;
                continue;
            }
            this.typedPut(key, val);
        }
    }

    private ParaSet() {
    }

    static ParaSet ruleNameToParaSet(String ruleSetName) {
        ParaSet q = new ParaSet();
        q.put("rule_id", ruleSetName);
        return q;
    }

    private static boolean isRegular(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean isGoodColorName(String s) {
        if (s.length() == 0) {
            return false;
        }
        boolean wasRegular = false;
        for (int j = 0; j < s.length(); ++j) {
            boolean ok;
            char c = s.charAt(j);
            boolean isRegular = ParaSet.isRegular(c);
            boolean bl = ok = isRegular || (c == '-' || c == '/') && wasRegular && j + 1 < s.length();
            if (!ok) {
                return false;
            }
            wasRegular = isRegular;
        }
        return true;
    }

    private Object typedPut(String key, String val) {
        if (val == null) {
            return null;
        }
        String s = (val = val.trim()).toLowerCase();
        return s.equals("true") || s.equals("false") ? this.put(key, Boolean.valueOf(s)) : (s.matches("[0-9]+") ? this.put(key, Integer.valueOf(s)) : (s.matches("[0-9]*\\.[0-9]+") ? this.put(key, Double.valueOf(s)) : this.put(key, val)));
    }

    ParaSet(String name) {
        this.put("error", false);
        this.put("errmsg", "No error");
        this.put("name", name);
        try {
            File f;
            if (name == null) {
                throw new IOException("File name not specified");
            }
            File base = new File(Files.inputDir, "param");
            String ext = ".csv";
            if (!((String)name).endsWith(ext)) {
                name = (String)name + ext;
            }
            if (!(f = new File(base, (String)name)).exists()) {
                throw new IOException("File does not exist: " + f);
            }
            if (!f.canRead()) {
                throw new IOException("Cannot read file: " + f);
            }
            CsvData csv = new CsvData(f, true, false, null);
            for (CsvData.LineEntry e : csv.entries) {
                String key = e.getKey();
                String val = ((CsvData.BasicLineEntry)e).getCol(1);
                if (val == null || (val = val.trim()).length() == 0) continue;
                this.typedPut(key, val);
            }
        }
        catch (Exception ex) {
            this.put("error", true);
            this.put("errmsg", ex.getMessage());
        }
    }

    public int getInt(String key) {
        Integer o = (Integer)this.get(key);
        if (o == null) {
            throw new IllegalArgumentException("Parameter set has no variable named " + key);
        }
        return o;
    }

    public double getDouble(String key) {
        return this.getDouble(key, false, 0.0);
    }

    public double getDouble(String key, boolean optional, double defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            if (optional) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Parameter set has no variable named " + key);
        }
        if (o instanceof Integer) {
            Integer q = (Integer)this.get(key);
            return q.intValue();
        }
        Double q = (Double)this.get(key);
        return q;
    }

    public int getMaxBoards() {
        return this.getInt("max_boards");
    }

    public String getRuleSetName() {
        return (String)this.get("rule_id");
    }

    public double getClearingThreshold() {
        Double x = this.getDouble("clearing_threshold");
        return x;
    }

    public double getPickCost() {
        Double x = this.getDouble("free_wrong_cost", true, 1.0);
        return x;
    }

    public boolean pickCostIsInt() {
        double x = this.getPickCost();
        return x == (double)((int)x);
    }

    public void checkColors(ColorMap cm) throws IOException {
        if (this.colors == null) {
            return;
        }
        for (Piece.Color color : this.colors) {
            if (cm.hasColor(color)) continue;
            throw new IOException("Color " + color + " is not in the color map");
        }
    }

    public void checkShapes() throws IOException {
        if (this.colors == null) {
            return;
        }
        for (Piece.Shape shape : this.shapes) {
            File f = Files.getSvgFile(shape);
            if (f.canRead()) continue;
            throw new IOException("For shape " + shape + ",  Cannot read shape file: " + f);
        }
    }

    public void checkImages() throws IOException {
        if (this.images == null) {
            return;
        }
        for (String key : this.images) {
            ImageObject imageObject = ImageObject.obtainImageObjectPlain(null, key, false);
        }
    }

    public boolean isFeedbackSwitchesFree() {
        String s = this.get("feedback_switches").toString();
        return s != null && s.toLowerCase().startsWith("free");
    }

    @Override
    public String toString() {
        Vector<CallSite> v = new Vector<CallSite>();
        for (String key : this.keySet()) {
            v.add((CallSite)((Object)(key + ": " + this.get(key))));
        }
        return "ParaSet{\n" + String.join((CharSequence)"\n", v) + "\n}";
    }

    void modifyBy(ParaSet modifier) {
        for (String key : modifier.keySet()) {
            this.put(key, modifier.get(key));
        }
    }
}

