/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.ResponseBase;
import edu.wisc.game.rest.TrialList;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.sql.User;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.Logging;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.bind.annotation.XmlElement;

public class PlayerResponse
extends ResponseBase {
    boolean newlyRegistered;
    private String trialListId;
    private TrialList trialList = null;
    private String playerId;
    private PlayerInfo playerInfo = null;
    boolean alreadyFinished = false;
    private String completionCode = null;
    private String experimentPlan;
    private static final Pattern repeatUserPat = Pattern.compile("^RepeatUser-([0-9]+)-");
    private static HashMap<String, PlayerInfo> allPlayers = new HashMap();

    public boolean getNewlyRegistered() {
        return this.newlyRegistered;
    }

    @XmlElement
    void setNewlyRegistered(boolean _newlyRegistered) {
        this.newlyRegistered = _newlyRegistered;
    }

    public String getTrialListId() {
        return this.trialListId;
    }

    public TrialList getTrialList() {
        return this.trialList;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    @XmlElement
    public void setPlayerId(String _playerId) {
        this.playerId = _playerId;
    }

    public PlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    public boolean getAlreadyFinished() {
        return this.alreadyFinished;
    }

    public String getCompletionCode() {
        return this.completionCode;
    }

    public String getExperimentPlan() {
        return this.experimentPlan;
    }

    PlayerResponse(String pid, String exp, int uid) {
        this(pid, exp, uid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlayerResponse(String pid, String exp, int uid, boolean debug) {
        Matcher m;
        exp = PlayerResponse.regularize(exp);
        pid = PlayerResponse.regularize((String)pid);
        Date now = new Date();
        if (pid == null) {
            if (uid < 0) {
                this.hasError("Neither player Id nor user Id have been provided");
                return;
            }
            pid = "RepeatUser-" + uid + "-" + Episode.randomWord(6) + "-" + Episode.sdf.format(now);
        } else if (uid < 0 && (m = repeatUserPat.matcher((CharSequence)pid)).find()) {
            uid = Integer.parseInt(m.group(1));
        }
        EntityManager em = Main.getNewEM();
        try {
            Logging.info("PlayerResponse(pid=" + (String)pid + ", exp=" + exp + ")");
            if (pid == null || ((String)pid).trim().equals("") || ((String)pid).equals("null")) {
                throw new IOException("Missing or invalid playerId");
            }
            PlayerInfo x = PlayerResponse.findPlayerInfo(em, (String)pid);
            if (debug) {
                this.playerInfo = x;
            }
            this.setErrmsg("Debug: pid=" + (String)pid + "; Retrieved x=" + x);
            this.setNewlyRegistered(x == null);
            if (x != null) {
                Logging.info("Found existing player=" + x + ", with plan=" + x.getExperimentPlan());
                this.trialList = new TrialList(x.getExperimentPlan(), x.getTrialListId());
                this.alreadyFinished = x.alreadyFinished();
                this.completionCode = x.getCompletionCode();
                String msg = null;
                if (exp != null && !x.getExperimentPlan().equals(exp)) {
                    msg = "Cannot play experiment plan '" + exp + "' with playerId=" + (String)pid + ", because that playerId is already assigned to experiment plan '" + x.getExperimentPlan() + "'";
                } else if (uid >= 0 && x.getUser() == null) {
                    msg = "Cannot use playerId=" + (String)pid + " with a user ID=" + uid + ", because this playerId is  already created without a user ID";
                } else if (uid < 0 && x.getUser() != null) {
                    msg = "Cannot use playerId=" + (String)pid + " without a user ID, because this playerId is  already created with user ID=" + x.getUser().getId();
                } else if (uid >= 0 && x.getUser() != null && (long)uid != x.getUser().getId()) {
                    msg = "Cannot use playerId=" + (String)pid + " without user ID=" + uid + ", because this playerId is  already created with user ID=" + x.getUser().getId();
                }
                if (msg != null) {
                    this.hasError(msg);
                    return;
                }
            } else {
                x = new PlayerInfo();
                x.setDate(now);
                x.setPlayerId((String)pid);
                if (uid >= 0) {
                    User user = (User)em.find(User.class, (Object)uid);
                    if (user == null) {
                        String msg = "Invalid user id=" + uid + ". No user exists with that ID";
                        this.hasError(msg);
                        return;
                    }
                    x.setUser(user);
                }
                if (exp == null) {
                    exp = TrialList.extractExperimentPlanFromPlayerId((String)pid);
                }
                x.setExperimentPlan(exp);
                this.assignRandomTrialList(x);
                em.getTransaction().begin();
                em.persist((Object)x);
                em.flush();
                em.getTransaction().commit();
                Logging.info("Persisted new player=" + x);
                allPlayers.put((String)pid, x);
            }
            this.playerId = x.getPlayerId();
            this.experimentPlan = x.getExperimentPlan();
            this.trialListId = x.getTrialListId();
            this.setError(false);
            this.setErrmsg("Debug:\n" + x.report());
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace(System.err);
            this.setError(true);
            this.setErrmsg(e.toString());
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
            Logging.info("PlayerResponse(pid=" + (String)pid + ", exp=" + exp + "), returning:\n" + JsonReflect.reflectToJSONObject(this, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PlayerInfo findPlayerInfo(EntityManager em, String pid) throws IOException, IllegalInputException, ReflectiveOperationException, RuleParseException {
        boolean mustClose;
        PlayerInfo x = allPlayers.get(pid);
        if (x != null) {
            return x;
        }
        boolean bl = mustClose = em == null;
        if (mustClose) {
            em = Main.getNewEM();
        }
        try {
            EntityManager entityManager = em;
            synchronized (entityManager) {
                Query q = em.createQuery("select m from PlayerInfo m where m.playerId=:c");
                q.setParameter("c", (Object)pid);
                List res = q.getResultList();
                if (res.size() == 0) {
                    PlayerInfo playerInfo = null;
                    return playerInfo;
                }
                x = (PlayerInfo)res.iterator().next();
            }
        }
        finally {
            if (mustClose) {
                em.close();
                em = null;
            }
        }
        allPlayers.put(pid, x);
        x.restoreTransientFields();
        for (EpisodeInfo epi : x.getAllEpisodes()) {
            epi.cache();
        }
        return x;
    }

    private void assignRandomTrialList(PlayerInfo x) throws IOException, IllegalInputException, ReflectiveOperationException, RuleParseException {
        String exp = x.getExperimentPlan();
        String minName = PlayerResponse.chooseRandomTrialList(exp, 1.0, false);
        x.setTrialListId(minName);
        this.trialList = new TrialList(exp, minName);
        x.initSeries(this.trialList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String chooseRandomTrialList(String exp, double hrs, boolean debug) throws IOException, IllegalInputException, ReflectiveOperationException, RuleParseException {
        EntityManager em;
        Vector<String> lists = TrialList.listTrialLists(exp);
        if (lists.size() == 0) {
            throw new IOException("Found no CSV files in the trial list directory for experiment plan=" + exp);
        }
        if (lists.size() == 1) {
            return lists.get(0);
        }
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        for (String key : lists) {
            names.put(key, 0);
        }
        long msecAgo = (long)(hrs * 3600.0 * 1000.0);
        Date recent = new Date(new Date().getTime() - msecAgo);
        EntityManager entityManager = em = Main.getEM();
        synchronized (entityManager) {
            Query q = em.createQuery("select p.trialListId, count(p) from PlayerInfo p where p.experimentPlan=:e and (p.completionCode is not null or p.date > :recent) group by p.trialListId");
            q.setParameter("e", (Object)exp);
            q.setParameter("recent", (Object)recent);
            List list = q.getResultList();
            for (Object o : list) {
                Object[] z = (Object[])o;
                String name = (String)z[0];
                if (!names.containsKey(name)) continue;
                int cnt = (int)((Long)z[1]).longValue();
                names.put(name, cnt);
                if (!debug) continue;
                System.out.println("C+R for (" + name + ")=" + cnt);
            }
        }
        HashMap<String, Integer> defects = TrialList.readDefects(exp);
        if (debug) {
            System.out.println("Read " + defects.size() + " entries from the defect file");
        }
        for (String name : defects.keySet()) {
            int d = defects.get(name);
            if (names.containsKey(name)) {
                int cnt = (Integer)names.get(name) - d;
                names.put(name, cnt);
                if (!debug) continue;
                System.out.println("C+R-D for (" + name + ")=" + cnt);
                continue;
            }
            System.err.println("Ignoring defect(" + name + ")=" + d + "; non-existent trial list name!");
        }
        String minName = null;
        for (String name : lists) {
            if (minName != null && (Integer)names.get(name) >= (Integer)names.get(minName)) continue;
            minName = name;
        }
        return minName;
    }

    public static void main(String[] argv) throws Exception {
        double hrs = Double.parseDouble(argv[0]);
        System.out.println("Looking back at hrs=" + hrs);
        for (int j = 1; j < argv.length; ++j) {
            String exp = argv[j];
            System.out.println("Plan=" + exp);
            String minName = PlayerResponse.chooseRandomTrialList(exp, hrs, true);
            System.out.println("If a player were to register now, it would be assigned to trialList=" + minName);
        }
    }
}

