/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.bind.annotation.XmlElement;

public class TrialList
extends Vector<ParaSet> {
    boolean error;
    String errmsg;
    private String path;
    static final String defectFileName = "defect.csv";
    static final String suff = ".csv";

    public boolean getError() {
        return this.error;
    }

    @XmlElement
    public void setError(boolean _error) {
        this.error = _error;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    @XmlElement
    public void setErrmsg(String _errmsg) {
        this.errmsg = _errmsg;
    }

    public String getPath() {
        return this.path;
    }

    @XmlElement
    public void setPath(String _path) {
        this.path = _path;
    }

    public static String extractExperimentPlanFromPlayerId(String playerId) {
        if (playerId == null || playerId.equals("") || playerId.startsWith("-")) {
            throw new IllegalArgumentException("Illegal playerId: " + playerId);
        }
        String[] seg = playerId.split("-");
        return seg.length > 1 ? seg[0] : "default";
    }

    public static Vector<String> listTrialLists(String exp) throws IOException {
        ExperimentPlanHandle eph = new ExperimentPlanHandle(exp);
        if (eph.mainDir == null) {
            return Util.array2vector(eph.mainRuleSetName);
        }
        return TrialList.listTrialLists(eph.mainDir);
    }

    public static Vector<String> listTrialLists(File base) throws IOException {
        if (!base.isDirectory()) {
            throw new IOException("No experiment plan directory exists: " + base);
        }
        if (!base.canRead()) {
            throw new IOException("Cannot read experiment plan directory: " + base);
        }
        Vector<String> names = new Vector<String>();
        for (String s : base.list()) {
            File f = new File(base, s);
            if (!f.isFile() || !s.endsWith(suff) || s.equals(defectFileName)) continue;
            String key = s.substring(0, s.length() - suff.length());
            names.add(key);
        }
        return names;
    }

    public static HashMap<String, Integer> readDefects(String exp) {
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        try {
            ExperimentPlanHandle eph = new ExperimentPlanHandle(exp);
            if (eph.mainDir == null) {
                throw new IllegalArgumentException("Experiment plan " + exp + " is an 'R:' dynamic plan, and has no defect file!");
            }
            File f = new File(eph.mainDir, defectFileName);
            if (!f.exists()) {
                return h;
            }
            CsvData csv = new CsvData(f, true, false, null);
            for (CsvData.LineEntry _e : csv.entries) {
                CsvData.BasicLineEntry e = (CsvData.BasicLineEntry)_e;
                String key = e.getKey();
                Integer val = new Integer(e.getCol(1));
                if (val == null) continue;
                h.put(key, val);
            }
        }
        catch (Exception ex) {
            System.err.println("Failed to process defect file for plan '" + exp + "'. Exception: " + ex);
        }
        return h;
    }

    TrialList(boolean _error, String _errmsg) {
        this.setError(_error);
        this.setErrmsg(_errmsg);
    }

    private static Vector<ParaSet> readTrialListFile(Vector<ParaSet> v, File f) throws IOException, IllegalInputException {
        if (v == null) {
            v = new Vector();
        }
        if (!f.exists()) {
            throw new IOException("File does not exist: " + f);
        }
        if (!f.canRead()) {
            throw new IOException("Cannot read file: " + f);
        }
        CsvData csv = new CsvData(f, true, false, null);
        if (csv.entries.length < 2) {
            throw new IOException("No data found in file: " + f);
        }
        CsvData.BasicLineEntry header = (CsvData.BasicLineEntry)csv.entries[0];
        for (int j = 1; j < csv.entries.length; ++j) {
            CsvData.BasicLineEntry line = (CsvData.BasicLineEntry)csv.entries[j];
            v.add(new ParaSet(header, line));
        }
        return v;
    }

    public TrialList(String exp, String trialListId) throws IOException, IllegalInputException {
        this(false, "No error");
        try {
            ExperimentPlanHandle eph = new ExperimentPlanHandle(exp);
            if (eph.mainDir != null) {
                File mainFile = new File(eph.mainDir, trialListId + suff);
                this.setPath(mainFile.getPath());
                TrialList.readTrialListFile(this, mainFile);
            } else if (eph.mainRuleSetName != null) {
                this.setPath(null);
                this.add(ParaSet.ruleNameToParaSet(eph.mainRuleSetName));
            }
            if (eph.modifierFile != null) {
                Vector<ParaSet> mv = TrialList.readTrialListFile(null, eph.modifierFile);
                if (mv.size() != 1) {
                    throw new IllegalInputException("Invalid modifier file " + eph.modifierFile + ". Expected to find 1 para set in it, found " + mv.size());
                }
                ParaSet mf = mv.get(0);
                for (ParaSet para : this) {
                    para.modifyBy(mf);
                }
            }
        }
        catch (IOException ex) {
            this.setError(true);
            this.setErrmsg(ex.getMessage());
            throw ex;
        }
    }

    public TrialList(File mainFile) throws IOException {
        this(false, "No error");
        try {
            this.setPath(mainFile.getPath());
            TrialList.readTrialListFile(this, mainFile);
        }
        catch (Exception ex) {
            this.setError(true);
            this.setErrmsg(ex.getMessage());
        }
    }

    static class ExperimentPlanHandle {
        final File mainDir;
        final String mainRuleSetName;
        final File modifierFile;

        private static File findDir(String expMain) {
            if (expMain == null) {
                throw new IllegalArgumentException("Experiment plan not specified");
            }
            File base = Files.trialListMainDir();
            return new File(base, expMain);
        }

        ExperimentPlanHandle(String exp) throws IOException {
            String[] q = exp.split(":");
            if (q.length == 1) {
                this.mainDir = ExperimentPlanHandle.findDir(exp);
                this.mainRuleSetName = null;
                this.modifierFile = null;
            } else if (q.length == 3 && q[0].equals("P")) {
                this.mainDir = ExperimentPlanHandle.findDir(q[1]);
                this.mainRuleSetName = null;
                this.modifierFile = Files.modifierFile(q[2]);
            } else if (q.length == 3 && q[0].equals("R")) {
                this.mainDir = null;
                this.mainRuleSetName = q[1];
                this.modifierFile = Files.modifierFile(q[2]);
            } else {
                throw new IllegalArgumentException("Not a proper way to describe an experiment plan: " + exp);
            }
        }
    }
}

