/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.rest.ResponseBase;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.User;
import edu.wisc.game.util.Logging;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.bind.annotation.XmlElement;

public class UserResponse
extends ResponseBase {
    private User u = null;
    boolean newlyRegistered;
    static final DateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public User getUser() {
        return this.u;
    }

    public boolean getNewlyRegistered() {
        return this.newlyRegistered;
    }

    @XmlElement
    void setNewlyRegistered(boolean _newlyRegistered) {
        this.newlyRegistered = _newlyRegistered;
    }

    private static User findUser(EntityManager em, String queryText, String val) {
        Query q = em.createQuery(queryText);
        q.setParameter("c", (Object)val);
        List res = q.getResultList();
        if (res.size() == 0) {
            return null;
        }
        return (User)res.iterator().next();
    }

    private static String buildCodeId(String prefix, Date now) {
        return prefix + "-" + sdf.format(now) + "-" + Episode.randomWord(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserResponse(String email, String nickname, boolean anon) {
        email = UserResponse.regularize(email);
        nickname = UserResponse.regularize(nickname);
        EntityManager em = null;
        boolean isAnon = false;
        try {
            block39: {
                block41: {
                    boolean mustClose;
                    block40: {
                        if (nickname != null || email != null) break block40;
                        if (!anon) {
                            this.hasError("Please go back to the login page and provide either an email address or a nickname, or check the 'anonymous' box.");
                            return;
                        }
                        isAnon = true;
                        break block39;
                    }
                    if (email == null) break block41;
                    boolean bl = mustClose = em == null;
                    if (em == null) {
                        em = Main.getNewEM();
                    }
                    this.u = UserResponse.findUser(em, "select u from User u where u.email=:c", email);
                    if (this.u != null) {
                        if (nickname != null) {
                            if (this.u.getNickname() == null) {
                                this.u.setNickname(nickname);
                            }
                            if (!this.u.getNickname().equals(nickname)) {
                                this.hasError("Cannot use email '" + email + "' with nickname '" + nickname + "', because this email address has been previously used with a different nickname");
                                return;
                            }
                            break block39;
                        } else if (this.u.getNickname() != null) {
                            this.hasError("This email was originally registered with a nickname. Please go back to the login page and provide the same nickname along with the email address. Alternatively, you can choose to check the 'anonymous' box instead.");
                            return;
                        }
                        break block39;
                    } else {
                        this.u = null;
                    }
                    break block39;
                }
                if (em == null) {
                    em = Main.getNewEM();
                }
                this.u = UserResponse.findUser(em, "select u from User u where u.nickname=:c", nickname);
                if (this.u != null && this.u.getEmail() != null) {
                    this.hasError("This nickname ('" + nickname + "') cannot be used without an email address, because it has been previously used with an email address. To resume using it, go back and supply the email address as well.");
                    return;
                }
            }
            if (this.u == null) {
                this.u = new User();
                if (email != null) {
                    this.u.setEmail(email);
                }
                if (nickname != null) {
                    this.u.setNickname(nickname);
                }
                Date now = new Date();
                this.u.setIdCode(UserResponse.buildCodeId(isAnon ? "anon" : "user", now));
                this.u.setDate(now);
                Logging.info("Created new user: " + this.u);
                if (em == null) {
                    em = Main.getNewEM();
                }
                em.getTransaction().begin();
                em.persist((Object)this.u);
                em.flush();
                em.getTransaction().commit();
                this.setNewlyRegistered(true);
                return;
            }
            this.setNewlyRegistered(false);
            return;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace(System.err);
            String msg = "Error in LoginServlet: " + e;
            this.hasError(msg);
            return;
        }
        finally {
            if (em != null) {
                try {
                    em.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

