/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.saved;

import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.util.IllegalInputException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class BoardManager {
    private static final String file_writing_lock = "Board file writing lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(Board b, String pid, String eid, File f) {
        String string = file_writing_lock;
        synchronized (file_writing_lock) {
            try {
                PrintWriter w = new PrintWriter(new FileWriter(f, true));
                if (f.length() == 0L) {
                    w.println("#playerId,episodeId,y,x,shape,color,objectType");
                }
                Vector<Object> v = new Vector<Object>();
                for (Piece p : b.getValue()) {
                    v.clear();
                    v.add(pid);
                    v.add(eid);
                    v.add("" + p.getY());
                    v.add("" + p.getX());
                    v.add("" + p.xgetShape());
                    v.add("" + p.xgetColor());
                    v.add(p.objectType());
                    w.println(String.join((CharSequence)",", v));
                }
                w.close();
            }
            catch (IOException ex) {
                System.err.println("Error writing the board: " + ex);
                ex.printStackTrace(System.err);
            }
            return;
        }
    }

    public static HashMap<String, Board> readBoardFile(File f, HashMap<String, Boolean> useImagesTable) throws IOException, IllegalInputException {
        HashMap<String, Board> h = new HashMap<String, Board>();
        CsvData csv = new CsvData(f);
        Board b = null;
        String lastEid = null;
        for (CsvData.LineEntry _e : csv.entries) {
            Piece p;
            CsvData.BasicLineEntry e = (CsvData.BasicLineEntry)_e;
            String episodeId = e.getCol(1);
            boolean useImages = useImagesTable.get(episodeId);
            if (!episodeId.equals(lastEid)) {
                if (b != null) {
                    h.put(lastEid, b);
                }
                b = new Board();
                lastEid = episodeId;
            }
            int y = e.getColInt(2);
            int x = e.getColInt(3);
            if (useImages) {
                if (e.nCol() < 7) {
                    throw new IllegalArgumentException("The board file " + f + " seems to lack the ObjectType column");
                }
                String image = e.getCol(6);
                p = new Piece(image, x, y);
            } else {
                Piece.Shape shape = Piece.Shape.findShape(e.getCol(4));
                Piece.Color color = Piece.Color.findColor(e.getCol(5));
                p = new Piece(shape, color, x, y);
            }
            b.addPiece(p);
        }
        if (b != null) {
            h.put(lastEid, b);
            b = new Board();
        }
        return h;
    }
}

