/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.saved;

import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.util.IllegalInputException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class TranscriptManager {
    static final String file_writing_lock = "Transcript file writing lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTranscriptToFile(String pid, String eid, File f, Vector<Episode.Pick> transcript) {
        String string = file_writing_lock;
        synchronized (file_writing_lock) {
            try {
                PrintWriter w = new PrintWriter(new FileWriter(f, true));
                if (f.length() == 0L) {
                    w.println("#pid,episodeId,moveNo,timestamp,y,x,by,bx,code");
                }
                Vector<Object> v = new Vector<Object>();
                int k = 0;
                for (Episode.Pick move : transcript) {
                    v.clear();
                    v.add(pid);
                    v.add(eid);
                    v.add("" + k++);
                    v.add(Episode.sdf2.format(move.time));
                    Board.Pos q = new Board.Pos(move.pos);
                    v.add("" + q.y);
                    v.add("" + q.x);
                    if (move instanceof Episode.Move) {
                        Episode.Move m = (Episode.Move)move;
                        Board.Pos b = Board.buckets[m.bucketNo];
                        v.add("" + b.y);
                        v.add("" + b.x);
                    } else {
                        v.add("");
                        v.add("");
                    }
                    v.add("" + move.getCode());
                    w.println(String.join((CharSequence)",", v));
                }
                w.close();
            }
            catch (IOException ex) {
                System.err.println("Error writing the transcript: " + ex);
                ex.printStackTrace(System.err);
            }
            return;
        }
    }

    public static class ReadTranscriptData
    extends Vector<Entry> {
        public ReadTranscriptData(File csvFile) throws IOException, IllegalInputException {
            CsvData csv = new CsvData(csvFile);
            for (CsvData.LineEntry _e : csv.entries) {
                CsvData.BasicLineEntry e = (CsvData.BasicLineEntry)_e;
                Entry z = new Entry(e);
                if (z.code == 3) continue;
                this.add(z);
            }
        }

        public static int[] asVectorY(Vector<Entry> v) {
            int[] q = new int[v.size()];
            for (int j = 0; j < v.size(); ++j) {
                q[j] = v.get((int)j).code == 0 ? 1 : 0;
            }
            return q;
        }

        public static class Entry {
            public final CsvData.BasicLineEntry csv;
            public final String pid;
            public final String eid;
            public final int k;
            public final String timeString;
            public final Episode.Pick pick;
            public final int code;

            Entry(CsvData.BasicLineEntry e) {
                this.csv = e;
                int j = 0;
                this.pid = e.getCol(j++);
                this.eid = e.getCol(j++);
                this.k = e.getColInt(j++);
                this.timeString = e.getCol(j++);
                int qy = e.getColInt(j++);
                int qx = e.getColInt(j++);
                Integer by = e.getColInt(j++);
                Integer bx = e.getColInt(j++);
                boolean isMove = by != null;
                Board.Pos pos = new Board.Pos(qx, qy);
                this.pick = isMove ? new Episode.Move(pos, new Board.Pos(bx, by)) : new Episode.Pick(pos);
                this.code = e.getColInt(j++);
            }

            public boolean equals(Object o) {
                return o instanceof Entry && this.csv.equals(((Entry)o).csv);
            }
        }
    }
}

