/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.reflect.JsonToJava;
import edu.wisc.game.rest.ColorMap;
import edu.wisc.game.rest.Files;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.RandomRG;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="board")
@Entity
public class Board {
    public static final int N = 6;
    public static final Pos[] buckets = new Pos[]{new Pos(0, 7), new Pos(7, 7), new Pos(7, 0), new Pos(0, 0)};
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Basic
    private String name;
    @OneToMany(mappedBy="board", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Vector<Piece> value = new Vector();

    public static int xynum(int x, int y) {
        return new Pos(x, y).num();
    }

    public void addPiece(Piece c) {
        this.value.add(c);
        c.setBoard(this);
    }

    public void removePiece(Piece c) {
        this.value.remove(c);
        c.setBoard(null);
    }

    public long getId() {
        return this.id;
    }

    @XmlElement
    public void setId(long _id) {
        this.id = _id;
    }

    public String getName() {
        return this.name;
    }

    @XmlElement
    public void setName(String _name) {
        this.name = _name;
    }

    public Vector<Piece> getValue() {
        return this.value;
    }

    @XmlElement
    public void setValue(Vector<Piece> _value) {
        for (Piece p : this.value) {
            p.setBoard(null);
        }
        this.value.setSize(0);
        for (Piece p : _value) {
            this.addPiece(p);
        }
    }

    public Board() {
        this.setName("Sample board");
        this.setId(0L);
        this.value = new Vector();
    }

    public Board(RandomRG random, int randomCnt) {
        this.setName("Random board with " + randomCnt + " pieces");
        Piece.Shape[] shapes = Piece.Shape.legacyShapes;
        Piece.Color[] colors = Piece.Color.legacyColors;
        if (randomCnt > 36) {
            throw new IllegalArgumentException("Cannot fit " + randomCnt + " pieces on an 6 square board!");
        }
        Vector<Integer> w = random.randomSubsetOrdered(36, randomCnt);
        for (int i = 0; i < randomCnt; ++i) {
            Pos pos = new Pos(w.get(i) + 1);
            Piece p = new Piece(shapes[random.nextInt(shapes.length)], colors[random.nextInt(colors.length)], pos.x, pos.y);
            p.setId(i);
            this.value.add(p);
        }
    }

    private void designatedProps(RandomRG random, Object[] allProps, Object[] results, int nProp) {
        if (nProp < 0 || nProp > allProps.length) {
            throw new IllegalArgumentException("Illegal number of values (" + nProp + ") to pick out of " + allProps.length);
        }
        int m = results.length;
        if (nProp == 0) {
            for (int j = 0; j < m; ++j) {
                int k = random.nextInt(allProps.length);
                results[j] = allProps[k];
            }
        } else {
            int[] r = new int[m];
            for (int j = 0; j < m; ++j) {
                int k;
                r[j] = k = random.nextInt(nProp);
            }
            Vector<Integer> placesToChange = random.randomSubsetPermuted(m, nProp);
            for (int i = 0; i < nProp; ++i) {
                r[placesToChange.get((int)i).intValue()] = i;
            }
            Vector<Integer> shallUse = random.randomSubsetOrdered(allProps.length, nProp);
            for (int j = 0; j < m; ++j) {
                results[j] = allProps[shallUse.get(r[j])];
            }
        }
    }

    public Board(RandomRG random, int randomCnt, int nShapes, int nColors, Piece.Shape[] allShapes, Piece.Color[] allColors) {
        this.setName("Random board with " + randomCnt + " pieces, " + nShapes + " shapes, and " + nColors + " colors");
        if (randomCnt > 36) {
            throw new IllegalArgumentException("Cannot fit " + randomCnt + " pieces on an 6 square board!");
        }
        if (nShapes < 0 || nShapes > allShapes.length) {
            throw new IllegalArgumentException("Invalid number of shapes: " + nShapes);
        }
        if (nColors < 0 || nColors > allColors.length) {
            throw new IllegalArgumentException("Invalid number of colors: " + nColors);
        }
        Vector<Integer> w = random.randomSubsetOrdered(36, randomCnt);
        Object[] useShapes = new Piece.Shape[randomCnt];
        Object[] useColors = new Piece.Color[randomCnt];
        this.designatedProps(random, allShapes, useShapes, nShapes);
        this.designatedProps(random, allColors, useColors, nColors);
        for (int i = 0; i < randomCnt; ++i) {
            Pos pos = new Pos(w.get(i) + 1);
            Piece p = new Piece((Piece.Shape)useShapes[i], (Piece.Color)useColors[i], pos.x, pos.y);
            p.setId(i);
            this.value.add(p);
        }
    }

    public Board(RandomRG random, int randomCnt, String[] allImages) {
        this.setName("Random board with " + randomCnt + " pieces, drawn from a set of " + allImages.length + " images");
        if (randomCnt > 36) {
            throw new IllegalArgumentException("Cannot fit " + randomCnt + " pieces on an 6 square board!");
        }
        Vector<Integer> w = random.randomSubsetOrdered(36, randomCnt);
        for (int i = 0; i < randomCnt; ++i) {
            Pos pos = new Pos(w.get(i) + 1);
            String image = allImages[random.nextInt(allImages.length)];
            Piece p = new Piece(image, pos.x, pos.y);
            p.setId(i);
            this.value.add(p);
        }
    }

    public Board(Piece[] pieces, Piece[] removedPieces, BitSet[] moveableTo) {
        for (Piece p : pieces) {
            if (p == null) continue;
            BitSet bi = moveableTo[p.pos().num()];
            int[] z = new int[bi.cardinality()];
            int k = 0;
            for (int i = 0; i < bi.length(); ++i) {
                if (!bi.get(i)) continue;
                z[k++] = i;
            }
            p.setBuckets(z);
            this.value.add(p);
        }
        if (removedPieces == null) {
            return;
        }
        for (Piece p : removedPieces) {
            if (p == null) continue;
            this.value.add(p);
        }
    }

    public Piece[] asBoardPieces() {
        Piece[] pieces = new Piece[37];
        Iterator<Piece> iterator = this.value.iterator();
        while (iterator.hasNext()) {
            Piece p;
            pieces[p.pos().num()] = p = iterator.next();
        }
        return pieces;
    }

    public long persistNewBoard() {
        this.setId(0L);
        System.out.println("Creating board: " + this.name);
        Main.persistObjects(this);
        return this.getId();
    }

    public static Board readBoard(File f) throws IOException, ReflectiveOperationException {
        return Board.readBoard(new FileReader(f));
    }

    public static Board readBoardFromString(String jsonText) throws IOException, ReflectiveOperationException {
        return Board.readBoard(new StringReader(jsonText));
    }

    public static Board readBoard(Reader r) throws IOException, ReflectiveOperationException {
        JsonReader jsonReader = Json.createReader((Reader)r);
        JsonObject obj = jsonReader.readObject();
        jsonReader.close();
        Board board = new Board();
        JsonToJava.json2java(obj, board);
        return board;
    }

    public void checkShapesAndColors(ColorMap cm) throws IOException {
        for (Piece p : this.value) {
            Piece.Color color = p.xgetColor();
            if (!cm.hasColor(color)) {
                throw new IOException("Color " + color + " is not in the color map");
            }
            Piece.Shape shape = p.xgetShape();
            File f = Files.getSvgFile(shape);
            if (f.canRead()) continue;
            throw new IOException("For shape " + shape + ",  Cannot read shape file: " + f);
        }
    }

    public static class Pos {
        public final int x;
        public final int y;

        public int num() {
            if (this.x < 1 || this.x > 6) {
                throw new IllegalArgumentException("x out of range");
            }
            if (this.y < 1 || this.y > 6) {
                throw new IllegalArgumentException("y out of range");
            }
            return this.x + (this.y - 1) * 6;
        }

        public int bucketNo() {
            return this.y == 7 ? (this.x == 0 ? 0 : (this.x == 7 ? 1 : -1)) : (this.y == 0 ? (this.x == 0 ? 3 : (this.x == 7 ? 2 : -1)) : -1);
        }

        public Pos(int _x, int _y) {
            this.x = _x;
            this.y = _y;
        }

        public Pos(int num) {
            if (num < 1 || num > 36) {
                throw new IllegalArgumentException("num (=" + num + ") out of range");
            }
            this.y = (num - 1) / 6 + 1;
            this.x = (num - 1) % 6 + 1;
        }

        public int norm2sq(Pos q) {
            int dx = q.x - this.x;
            int dy = q.y - this.y;
            return dx * dx + dy * dy;
        }

        public int norm1(Pos q) {
            int dx = q.x - this.x;
            int dy = q.y - this.y;
            return Math.abs(dx) + Math.abs(dy);
        }

        public Pos flip2corner() {
            return new Pos(2 * this.x > 7 ? 7 - this.x : this.x, 2 * this.y > 7 ? 7 - this.y : this.y);
        }

        public HashSet<Integer> nearestBucket() {
            HashSet<Integer> h = new HashSet<Integer>();
            if (2 * this.x <= 7) {
                if (2 * this.y >= 7) {
                    h.add(0);
                }
                if (2 * this.y <= 7) {
                    h.add(3);
                }
            }
            if (2 * this.x >= 7) {
                if (2 * this.y >= 7) {
                    h.add(1);
                }
                if (2 * this.y <= 7) {
                    h.add(2);
                }
            }
            return h;
        }

        public HashSet<Integer> remotestBucket() {
            Pos q = new Pos(7 - this.x, 7 - this.y);
            return q.nearestBucket();
        }

        public String toString() {
            return "(x=" + this.x + ", y=" + this.y + ")";
        }
    }
}

