/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.engine.Order;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.formatter.HTMLFmter;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.parser.Token;
import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.ColorMap;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.ImageObject;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.RandomRG;
import edu.wisc.game.util.Util;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.json.JsonObject;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;

@Entity
public class Episode {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Basic
    public String episodeId;
    Date startTime;
    public static final int NBU = Board.buckets.length;
    @Transient
    RuleSet rules;
    @Transient
    private Piece[] pieces = new Piece[37];
    @Transient
    private Piece[] removedPieces = new Piece[37];
    int attemptCnt = 0;
    double attemptSpent = 0.0;
    int doneMoveCnt;
    @Transient
    Vector<Pick> transcript = new Vector();
    boolean stalemate = false;
    boolean cleared = false;
    boolean givenUp = false;
    boolean lost = false;
    @Transient
    private HashMap<Piece.Color, Integer> pcMap = new HashMap();
    @Transient
    private HashMap<Piece.Shape, Integer> psMap = new HashMap();
    @Transient
    private HashMap<String, HashMap<String, Integer>> propMap = new HashMap();
    @Transient
    private Integer pMap = null;
    @Transient
    protected int ruleLineNo = 0;
    @Transient
    protected RuleLine ruleLine = null;
    @Transient
    private OutputMode outputMode;
    @Transient
    private final PrintWriter out;
    @Transient
    private final Reader in;
    public static final DateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final DateFormat sdf2 = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
    public static final RandomRG random = new RandomRG();
    @Basic
    private int nPiecesStart;
    @Transient
    private boolean prepReady = false;
    @Transient
    private Pick lastMove = null;
    private static HTMLFmter fm = new HTMLFmter(null);
    private static final HashSet<String> excludableNames = Util.array2set("dropped");
    public static final String version = "4.002";
    static final String file_writing_lock = "Board file writing lock";

    public String getEpisodeId() {
        return this.episodeId;
    }

    public void setEpisodeId(String _episodeId) {
        this.episodeId = _episodeId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date _startTime) {
        this.startTime = _startTime;
    }

    void setRules(RuleSet _rules) {
        this.rules = _rules;
    }

    double xgetPickCost() {
        return 1.0;
    }

    private String showPropMap() {
        Vector<CallSite> v = new Vector<CallSite>();
        for (String p : this.propMap.keySet()) {
            HashMap<String, Integer> h = this.propMap.get(p);
            Vector<CallSite> w = new Vector<CallSite>();
            for (String key : h.keySet()) {
                w.add((CallSite)((Object)("(" + key + ":" + h.get(key) + ")")));
            }
            v.add((CallSite)((Object)(p + " -> " + String.join((CharSequence)" ", w))));
        }
        return String.join((CharSequence)"\n", v);
    }

    boolean isNotPlayable() {
        return this.ruleLine == null;
    }

    public static String randomWord(int len) {
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            int k = random.nextInt(36);
            char c = k < 10 ? (char)(48 + k) : (char)(65 + k - 10);
            b.append(c);
        }
        return b.toString();
    }

    private String buildId() {
        return sdf.format(this.startTime) + "-" + Episode.randomWord(6);
    }

    public Episode() {
        this.episodeId = null;
        this.rules = null;
        this.out = null;
        this.in = null;
        this.nPiecesStart = 0;
        this.startTime = new Date();
    }

    public int getNPiecesStart() {
        return this.nPiecesStart;
    }

    public void setNPiecesStart(int _nPiecesStart) {
        this.nPiecesStart = _nPiecesStart;
    }

    public Episode(Game game, OutputMode _outputMode, Reader _in, PrintWriter _out) {
        this(game, _outputMode, _in, _out, null);
    }

    protected Episode(Game game, OutputMode _outputMode, Reader _in, PrintWriter _out, String _episodeId) {
        this.startTime = new Date();
        this.in = _in;
        this.out = _out;
        this.outputMode = _outputMode;
        this.episodeId = _episodeId == null ? this.buildId() : _episodeId;
        this.rules = game.rules;
        Board b = game.initialBoard;
        if (b == null) {
            b = game.allImages != null ? new Board(game.random, game.randomObjCnt, game.allImages) : new Board(game.random, game.randomObjCnt, game.nShapes, game.nColors, game.allShapes, game.allColors);
        }
        this.nPiecesStart = b.getValue().size();
        for (Piece p : b.getValue()) {
            Board.Pos pos = p.pos();
            this.pieces[pos.num()] = p;
        }
        this.doPrep();
    }

    private BitSet onBoard() {
        BitSet onBoard = new BitSet(37);
        for (int i = 0; i < this.pieces.length; ++i) {
            if (this.pieces[i] == null) continue;
            onBoard.set(i);
        }
        return onBoard;
    }

    private boolean doPrep() {
        boolean mustUpdateRules;
        boolean bl = mustUpdateRules = this.ruleLine == null || this.ruleLine.doneWith;
        if (mustUpdateRules) {
            this.ruleLineNo = this.ruleLine == null ? 0 : (this.ruleLineNo + 1) % this.rules.rows.size();
            this.ruleLine = new RuleLine(this.rules, this.ruleLineNo);
            int no0 = this.ruleLineNo;
            while (this.ruleLine.doneWith) {
                this.ruleLineNo = (this.ruleLineNo + 1) % this.rules.rows.size();
                if (this.ruleLineNo == no0) {
                    this.stalemate = true;
                    return false;
                }
                this.ruleLine = new RuleLine(this.rules, this.ruleLineNo);
            }
        }
        this.prepReady = true;
        return true;
    }

    protected int accept(Pick move) {
        this.lastMove = move;
        if (this.stalemate) {
            return 2;
        }
        if (move.pos < 1 || move.pos >= this.pieces.length) {
            return -3;
        }
        int code = this.ruleLine.accept(move);
        if (move instanceof Move && code == 0 && !this.cleared && !this.stalemate && !this.givenUp) {
            this.doPrep();
        }
        return code;
    }

    boolean weShowAllMovables() {
        return true;
    }

    public String graphicDisplay() {
        return this.graphicDisplay(false);
    }

    public String graphicDisplay(boolean html) {
        if (this.isNotPlayable() || !html) {
            return this.graphicDisplayAscii(html);
        }
        int lastMovePos = this.lastMove == null ? -1 : this.lastMove.pos;
        boolean[] isMoveable = this.ruleLine.isMoveable;
        String s = fm.wrap("li", "(X) - a movable piece" + (!this.weShowAllMovables() ? " (only marked on the last touched piece)" : "")) + fm.wrap("li", "[X] - the position to which the last move or pick attempt (whether successful or not) was applied");
        Object result = fm.para("Notation: " + fm.wrap("ul", s));
        result = (String)result + Episode.doHtmlDisplay(this.pieces, lastMovePos, this.weShowAllMovables(), isMoveable, 80);
        return result;
    }

    public static String doHtmlDisplay(Piece[] pieces, int lastMovePos, boolean weShowAllMovables, boolean[] isMoveable, int cellWidth) {
        Object result = "";
        ColorMap cm = new ColorMap();
        Vector<String> rows = new Vector<String>();
        Vector<String> v = new Vector<String>();
        v.add(fm.td(""));
        for (int x = 1; x <= 6; ++x) {
            v.add(fm.td("align='center'", "" + x));
        }
        String topRow = fm.tr(String.join((CharSequence)"", v));
        rows.add(topRow);
        for (int y = 6; y > 0; --y) {
            v.clear();
            v.add(fm.td("" + y));
            boolean needBorder = false;
            for (Piece p : pieces) {
                if (p == null || p.xgetColor() == null) continue;
                needBorder = true;
            }
            for (int x = 1; x <= 6; ++x) {
                int pos = new Board.Pos(x, y).num();
                String sh = "BLANK";
                Object hexColor = "#FFFFFF";
                ImageObject io = null;
                if (pieces[pos] != null) {
                    Piece p = pieces[pos];
                    io = p.getImageObject();
                    sh = io != null ? io.key : p.xgetShape().toString();
                    hexColor = "#" + (io != null ? "FFFFFF" : cm.getHex(p.xgetColor(), true));
                }
                Object z = "<img ";
                if (needBorder) {
                    z = (String)z + "style='border: 5px solid " + (String)hexColor + "' ";
                }
                z = (String)z + "width='" + cellWidth + "' src=\"../../GetImageServlet?image=" + sh + "\">";
                boolean isLastMovePos = lastMovePos == pos;
                boolean padded = true;
                if (isMoveable[pos] && (weShowAllMovables || isLastMovePos)) {
                    z = "(" + (String)z + ")";
                    padded = true;
                }
                if (isLastMovePos) {
                    z = "[" + (String)z + "]";
                    padded = true;
                }
                if (!padded) {
                    z = "&nbsp;" + (String)z + "&nbsp;";
                }
                String td = io != null ? fm.td((String)z) : fm.td("bgcolor=\"" + (String)hexColor + "\"", (String)z);
                v.add(td);
            }
            rows.add(fm.tr(String.join((CharSequence)"", v)));
        }
        rows.add(topRow);
        result = (String)result + fm.table("border='1'", rows);
        return result;
    }

    public String graphicDisplayAscii(boolean html) {
        if (this.isNotPlayable()) {
            return "This episode must have been restored from SQL server, and does not have the details necessary to show the board";
        }
        Vector<Object> w = new Vector<Object>();
        Object div = "#---+";
        for (int x = 1; x <= 6; ++x) {
            div = (String)div + "-----";
        }
        w.add(div);
        for (int y = 6; y > 0; --y) {
            String s = "# " + y + " |";
            for (int x = 1; x <= 6; ++x) {
                Object z;
                int pos = new Board.Pos(x, y).num();
                Object object = z = html ? "." : " .";
                if (this.pieces[pos] != null) {
                    Object color;
                    Piece p = this.pieces[pos];
                    ImageObject io = p.getImageObject();
                    Object object2 = z = io != null ? io.symbol() : p.xgetShape().symbol();
                    if (html) {
                        color = p.getColor();
                        if (color != null) {
                            z = fm.colored(((String)color).toLowerCase(), (String)z);
                        }
                        z = fm.wrap("strong", (String)z);
                    } else {
                        color = p.xgetColor();
                        if (color != null) {
                            z = ((Piece.Color)color).symbol() + (String)z;
                        }
                    }
                }
                z = this.lastMove != null && this.lastMove.pos == pos ? "[" + (String)z + "]" : (this.ruleLine.isMoveable[pos] ? "(" + (String)z + ")" : " " + (String)z + " ");
                s = s + " " + (String)z;
            }
            w.add(s);
        }
        w.add(div);
        Object s = "#   |";
        for (int x = 1; x <= 6; ++x) {
            s = (String)s + "  " + (html ? "" : " ") + x + " ";
        }
        w.add(s);
        return String.join((CharSequence)"\n", w);
    }

    int getFinishCode() {
        return this.cleared ? 1 : (this.stalemate ? 2 : (this.givenUp ? 3 : (this.lost ? 4 : 0)));
    }

    private void respond(int code, String msg) {
        String s = code + " " + this.getFinishCode() + " " + this.attemptCnt;
        if (msg != null) {
            s = s + "\n" + msg;
        }
        this.out.println(s);
    }

    Board getCurrentBoard(boolean showRemoved) {
        if (this.isNotPlayable()) {
            return this.cleared ? new Board() : null;
        }
        return new Board(this.pieces, showRemoved ? this.removedPieces : null, this.ruleLine.moveableTo());
    }

    public Board getCurrentBoard() {
        return this.getCurrentBoard(false);
    }

    private String displayJson() {
        Board b = this.getCurrentBoard();
        JsonObject json = JsonReflect.reflectToJSONObject(b, true, excludableNames);
        return json.toString();
    }

    private String readLine(LineNumberReader r) throws IOException {
        this.out.flush();
        return r.readLine();
    }

    public Display mkDisplay() {
        return new Display(-8, "Display requested");
    }

    private Display inputErrorCheck1(int y, int x, int _attemptCnt) {
        if (this.isCompleted()) {
            return new Display(-4, "No game is on right now (cleared=" + this.cleared + ", stalemate=" + this.stalemate + "). Use NEW to start a new game");
        }
        if (_attemptCnt != this.attemptCnt) {
            return new Display(-7, "Given attemptCnt=" + _attemptCnt + ", expected " + this.attemptCnt);
        }
        if (x < 1 || x > 6) {
            return new Display(-2, "Invalid input: column=" + x + " out of range");
        }
        if (y < 1 || y > 6) {
            return new Display(-2, "Invalid input: row=" + y + " out of range");
        }
        return null;
    }

    public Display doPick(int y, int x, int _attemptCnt) throws IOException {
        Display errorDisplay = this.inputErrorCheck1(y, x, _attemptCnt);
        if (errorDisplay != null) {
            return errorDisplay;
        }
        Board.Pos pos = new Board.Pos(x, y);
        Pick move = new Pick(pos.num());
        int code = this.accept(move);
        return new Display(code, this.mkDisplayMsg());
    }

    public Display doMove(int y, int x, int by, int bx, int _attemptCnt) throws IOException {
        Display errorDisplay = this.inputErrorCheck1(y, x, _attemptCnt);
        if (errorDisplay != null) {
            return errorDisplay;
        }
        if (bx != 0 && bx != 7) {
            return new Display(-2, "Invalid input: bucket column=" + bx + " is not 0 or 7");
        }
        if (by != 0 && by != 7) {
            return new Display(-2, "Invalid input: bucket row=" + by + " is not 0 or 7");
        }
        Board.Pos pos = new Board.Pos(x, y);
        Board.Pos bu = new Board.Pos(bx, by);
        int buNo = bu.bucketNo();
        if (buNo < 0 || buNo >= Board.buckets.length) {
            return new Display(-2, "Invalid bucket coordinates");
        }
        Move move = new Move(pos.num(), buNo);
        int code = this.accept(move);
        return new Display(code, this.mkDisplayMsg());
    }

    private String mkDisplayMsg() {
        return this.outputMode == OutputMode.BRIEF ? null : (this.cleared ? "Game cleared - the board is clear" : (this.stalemate ? "Stalemate - no piece can be moved any more. Apology for these rules!" : (this.givenUp ? "You have given up this episode" : null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playGame(int gameCnt) throws IOException {
        try {
            String msg = "# Hello. This is Captive Game Server ver. 4.002. Starting a new game (no. " + gameCnt + ")";
            if (this.stalemate) {
                this.respond(2, msg + " -- immediate stalemate. Our apologies!");
            } else {
                this.respond(6, msg);
            }
            this.out.println(this.displayJson());
            if (this.outputMode == OutputMode.FULL) {
                this.out.println(this.graphicDisplay());
            }
            LineNumberReader r = new LineNumberReader(this.in);
            String line = null;
            while ((line = this.readLine(r)) != null) {
                Vector<Token> tokens;
                if ((line = line.trim()).equals("")) continue;
                try {
                    tokens = Token.tokenize(line);
                }
                catch (RuleParseException ex) {
                    this.respond(-1, "# Invalid input - cannot parse");
                    continue;
                }
                if (tokens.size() == 0 || tokens.get((int)0).type != Token.Type.ID) {
                    this.respond(-1, "# Invalid input");
                    continue;
                }
                String cmd = tokens.get((int)0).sVal.toUpperCase();
                if (cmd.equals("EXIT")) {
                    this.respond(5, "# Goodbye");
                    boolean bl = false;
                    return bl;
                }
                if (cmd.equals("VERSION")) {
                    this.out.println("# 4.002");
                    continue;
                }
                if (cmd.equals("NEW")) {
                    boolean bl = true;
                    return bl;
                }
                if (cmd.equals("HELP")) {
                    this.out.println("# Commands available:");
                    this.out.println("# MOVE row col bucket_row bucket_col");
                    this.out.println("# NEW");
                    this.out.println("# DISPLAY");
                    this.out.println("# DISPLAYFULL");
                    this.out.println("# MODE <BRIEF|STANDARD|FULL>");
                    this.out.println("# EXIT");
                    continue;
                }
                if (cmd.equals("DISPLAY")) {
                    this.out.println(this.displayJson());
                    if (this.outputMode != OutputMode.FULL) continue;
                    this.out.println(this.graphicDisplay());
                    continue;
                }
                if (cmd.equals("DISPLAYFULL")) {
                    this.out.println(this.displayJson());
                    this.out.println(this.graphicDisplay());
                    continue;
                }
                if (cmd.equals("MODE")) {
                    tokens.remove(0);
                    if (tokens.size() != 1 || tokens.get((int)0).type != Token.Type.ID) {
                        this.respond(-2, "# MODE command must be followed by the new mode value");
                        continue;
                    }
                    String s = tokens.get((int)0).sVal.toUpperCase();
                    try {
                        this.outputMode = Enum.valueOf(OutputMode.class, s);
                    }
                    catch (IllegalArgumentException ex) {
                        this.respond(-2, "# Not a known mode: " + s);
                        continue;
                    }
                    this.out.println("# OK, mode=" + this.outputMode);
                    continue;
                }
                if (cmd.equals("MOVE")) {
                    tokens.remove(0);
                    if (tokens.size() != 4) {
                        this.respond(-2, "# Invalid input");
                        continue;
                    }
                    int[] q = new int[4];
                    boolean invalid = false;
                    for (int j = 0; j < 4; ++j) {
                        if (tokens.get((int)j).type != Token.Type.NUMBER) {
                            this.respond(-2, "# Invalid input: " + tokens.get(j));
                            invalid = true;
                            break;
                        }
                        q[j] = tokens.get((int)j).nVal;
                    }
                    if (invalid) continue;
                    Display mr = this.doMove(q[0], q[1], q[2], q[3], this.attemptCnt);
                    this.respond(mr.code, "# " + mr.errmsg);
                    if (this.outputMode != OutputMode.BRIEF) {
                        this.out.println(this.displayJson());
                    }
                    if (this.outputMode != OutputMode.FULL) continue;
                    this.out.println(this.graphicDisplay());
                    continue;
                }
                this.respond(-1, "# Invalid command: " + cmd);
            }
        }
        finally {
            this.out.flush();
        }
        return false;
    }

    boolean isCompleted() {
        return this.cleared || this.stalemate || this.givenUp || this.lost;
    }

    void giveUp() {
        if (!this.isCompleted()) {
            this.givenUp = true;
        }
    }

    public String report() {
        return "[" + this.episodeId + "; FC=" + this.getFinishCode() + " " + this.attemptCnt + "/" + this.getNPiecesStart() + "]";
    }

    public static enum OutputMode {
        BRIEF,
        STANDARD,
        FULL;

    }

    public class Display {
        int finishCode;
        Board board;
        int code;
        String errmsg;
        boolean error;
        int numMovesMade;
        private Vector<Pick> transcript;
        RuleSet.ReportedSrc rulesSrc;
        String explainCounters;
        int ruleLineNo;

        public Board getBoard() {
            return this.board;
        }

        @XmlElement
        public void setBoard(Board _b) {
            this.board = _b;
        }

        public int getFinishCode() {
            return this.finishCode;
        }

        public boolean getError() {
            return this.error;
        }

        @XmlElement
        public void setError(boolean _error) {
            this.error = _error;
        }

        public int getCode() {
            return this.code;
        }

        @XmlElement
        public void setCode(int _code) {
            this.code = _code;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        @XmlElement
        public void setErrmsg(String _msg) {
            this.errmsg = _msg;
        }

        public int getNumMovesMade() {
            return this.numMovesMade;
        }

        @XmlElement
        public void setNumMovesMade(int _numMovesMade) {
            this.numMovesMade = _numMovesMade;
        }

        public Vector<Pick> getTranscript() {
            return this.transcript;
        }

        public RuleSet.ReportedSrc getRulesSrc() {
            return this.rulesSrc;
        }

        public String getExplainCounters() {
            return this.explainCounters;
        }

        public int getRuleLineNo() {
            return this.ruleLineNo;
        }

        public Display(int _code, String _errmsg) {
            this.finishCode = Episode.this.getFinishCode();
            this.board = Episode.this.getCurrentBoard(true);
            this.error = false;
            this.numMovesMade = Episode.this.attemptCnt;
            this.transcript = Episode.this.transcript;
            this.rulesSrc = Episode.this.rules == null ? null : Episode.this.rules.reportSrc();
            this.explainCounters = Episode.this.ruleLine == null ? null : Episode.this.ruleLine.explainCounters();
            this.ruleLineNo = Episode.this.ruleLineNo;
            this.code = _code;
            this.errmsg = _errmsg;
        }
    }

    private class EligibilityForOrders
    extends HashMap<String, BitSet> {
        void update() {
            this.clear();
            for (String name : Episode.this.rules.orders.keySet()) {
                Order order = Episode.this.rules.orders.get(name);
                BitSet eligible = order.findEligiblePieces(Episode.this.onBoard());
                this.put(name, eligible);
            }
        }

        EligibilityForOrders() {
            this.update();
        }

        @Override
        public String toString() {
            Vector<CallSite> v = new Vector<CallSite>();
            for (String key : this.keySet()) {
                v.add((CallSite)((Object)("Eli(" + key + ")=" + this.get(key))));
            }
            return "[Eligibility: " + String.join((CharSequence)"; ", v) + "]";
        }
    }

    public static class FINISH_CODE {
        public static final int NO = 0;
        public static final int FINISH = 1;
        public static final int STALEMATE = 2;
        public static final int GIVEN_UP = 3;
        public static final int LOST = 4;
    }

    public static class CODE {
        public static final int ACCEPT = 0;
        public static final int STALEMATE = 2;
        public static final int EMPTY_CELL = 3;
        public static final int DENY = 4;
        public static final int EXIT = 5;
        public static final int NEW_GAME = 6;
        public static final int INVALID_COMMAND = -1;
        public static final int INVALID_ARGUMENTS = -2;
        public static final int INVALID_POS = -3;
        public static final int NO_GAME = -4;
        public static final int INVALID_RULES = -5;
        public static final int NO_SUCH_EPISODE = -6;
        public static final int ATTEMPT_CNT_MISMATCH = -7;
        public static final int JUST_A_DISPLAY = -8;
    }

    class BucketVarMap
    extends HashMap<String, HashSet<Integer>> {
        private void pu(String key, int k) {
            HashSet<Integer> h = new HashSet<Integer>();
            h.add(k);
            this.put(key, h);
        }

        BucketVarMap(Piece p) {
            ImageObject io;
            Integer z;
            Integer n = z = p.xgetColor() == null ? null : (Integer)Episode.this.pcMap.get(p.xgetColor());
            if (z != null) {
                this.pu(RuleSet.BucketSelector.pc.toString(), z);
            }
            Integer n2 = z = p.xgetShape() == null ? null : (Integer)Episode.this.psMap.get(p.xgetShape());
            if (z != null) {
                this.pu(RuleSet.BucketSelector.ps.toString(), z);
            }
            if (Episode.this.pMap != null) {
                this.pu(RuleSet.BucketSelector.p.toString(), Episode.this.pMap);
            }
            if ((io = p.getImageObject()) != null) {
                for (String key : io.keySet()) {
                    String val = (String)io.get(key);
                    z = Episode.this.propMap.get(key) == null ? null : (Integer)((HashMap)Episode.this.propMap.get(key)).get(val);
                    if (z == null) continue;
                    this.pu("p." + key, z);
                }
            }
            Board.Pos pos = p.pos();
            this.put(RuleSet.BucketSelector.Nearby.toString(), pos.nearestBucket());
            this.put(RuleSet.BucketSelector.Remotest.toString(), pos.remotestBucket());
        }

        @Override
        public String toString() {
            Vector<CallSite> v = new Vector<CallSite>();
            for (String key : this.keySet()) {
                Vector<CallSite> w = new Vector<CallSite>();
                Iterator iterator = ((HashSet)this.get(key)).iterator();
                while (iterator.hasNext()) {
                    int z = (Integer)iterator.next();
                    w.add((CallSite)((Object)("" + z)));
                }
                v.add((CallSite)((Object)("[" + key + ":" + Util.join(",", w) + "]")));
            }
            return String.join((CharSequence)" ", v);
        }
    }

    class RuleLine {
        final RuleSet.Row row;
        private int ourGlobalCounter;
        private int[] ourCounter;
        boolean doneWith = false;
        private BitSet[][] acceptanceMap = new BitSet[37][];
        protected boolean[] isMoveable = new boolean[37];

        private String showCounter(int k) {
            return k < 0 ? "*" : "" + k;
        }

        public String explainCounters() {
            Vector<String> v = new Vector<String>();
            for (int k : this.ourCounter) {
                v.add(this.showCounter(k));
            }
            return this.showCounter(this.ourGlobalCounter) + " / " + String.join((CharSequence)",", v);
        }

        public String toString() {
            return "[RL: " + this.row.toSrc() + " / " + this.explainCounters() + "]";
        }

        RuleLine(RuleSet rules, int rowNo) {
            if (rowNo < 0 || rowNo >= rules.rows.size()) {
                throw new IllegalArgumentException("Invalid row number");
            }
            this.row = rules.rows.get(rowNo);
            this.ourGlobalCounter = this.row.globalCounter;
            this.ourCounter = new int[this.row.size()];
            for (int i = 0; i < this.ourCounter.length; ++i) {
                this.ourCounter[i] = ((RuleSet.Atom)this.row.get((int)i)).counter;
            }
            this.doneWith = this.exhausted() || !this.buildAcceptanceMap();
        }

        double computeP0ForPicks(int knownFailedPicks) {
            int countPieces = 0;
            int countMovablePieces = 0;
            for (int pos = 0; pos < Episode.this.pieces.length; ++pos) {
                if (Episode.this.pieces[pos] == null) continue;
                ++countPieces;
                if (!this.isMoveable[pos]) continue;
                ++countMovablePieces;
            }
            if (knownFailedPicks > countPieces) {
                throw new IllegalArgumentException("You could not have really tried to pick " + knownFailedPicks + " pieces, as the board only has " + countPieces);
            }
            if (countMovablePieces > (countPieces -= knownFailedPicks)) {
                throw new IllegalArgumentException("What, there are more moveable pieces (" + countMovablePieces + ") than not-tested-yet pieces (" + countPieces + ")?");
            }
            return countPieces == 0 ? 0.0 : (double)countMovablePieces / (double)countPieces;
        }

        double computeP0ForMoves(int knownFailedMoves) {
            int countMoves = 0;
            int countAllowedMoves = 0;
            for (int pos = 0; pos < Episode.this.pieces.length; ++pos) {
                if (Episode.this.pieces[pos] == null || Episode.this.weShowAllMovables() && !this.isMoveable[pos]) continue;
                countMoves += 4;
                BitSet a = new BitSet();
                for (BitSet z : this.acceptanceMap[pos]) {
                    a.or(z);
                }
                countAllowedMoves += a.cardinality();
            }
            if (knownFailedMoves > countMoves) {
                throw new IllegalArgumentException("You could not have really tried to make " + knownFailedMoves + " moves, as the board only has enough pieces for " + countMoves);
            }
            if (countAllowedMoves > (countMoves -= knownFailedMoves)) {
                throw new IllegalArgumentException("What, there are more allowed moves (" + countAllowedMoves + ") than not-tested-yet moves (" + countMoves + ")?");
            }
            return countMoves == 0 ? 0.0 : (double)countAllowedMoves / (double)countMoves;
        }

        BitSet[] moveableTo() {
            BitSet[] q = new BitSet[37];
            for (int pos = 0; pos < Episode.this.pieces.length; ++pos) {
                q[pos] = new BitSet();
                if (Episode.this.pieces[pos] == null) continue;
                BitSet r = new BitSet();
                for (BitSet b : this.acceptanceMap[pos]) {
                    q[pos].or(b);
                }
            }
            return q;
        }

        private boolean buildAcceptanceMap() {
            EligibilityForOrders eligibleForEachOrder = new EligibilityForOrders();
            for (int pos = 0; pos < Episode.this.pieces.length; ++pos) {
                if (Episode.this.pieces[pos] == null) {
                    this.acceptanceMap[pos] = null;
                    this.isMoveable[pos] = false;
                    continue;
                }
                this.acceptanceMap[pos] = this.pieceAcceptance(Episode.this.pieces[pos], eligibleForEachOrder);
                BitSet r = new BitSet();
                for (BitSet b : this.acceptanceMap[pos]) {
                    r.or(b);
                }
                this.isMoveable[pos] = !r.isEmpty();
            }
            return this.isAnythingMoveable();
        }

        private boolean isAnythingMoveable() {
            for (int pos = 0; pos < Episode.this.pieces.length; ++pos) {
                if (Episode.this.pieces[pos] == null || !this.isMoveable[pos]) continue;
                return true;
            }
            return false;
        }

        private BitSet[] pieceAcceptance(Piece p, EligibilityForOrders eligibleForEachOrder) {
            if (this.doneWith) {
                throw new IllegalArgumentException("Forgot to scroll?");
            }
            if (this.row.globalCounter >= 0 && this.ourGlobalCounter <= 0) {
                throw new IllegalArgumentException("Forgot to set the scroll flag on 0 counter!");
            }
            BitSet[] whoAccepts = new BitSet[this.row.size()];
            Board.Pos pos = p.pos();
            BucketVarMap varMap = new BucketVarMap(p);
            for (int j = 0; j < this.row.size(); ++j) {
                whoAccepts[j] = new BitSet(NBU);
                RuleSet.Atom atom = (RuleSet.Atom)this.row.get(j);
                if (atom.counter >= 0 && this.ourCounter[j] == 0 || !atom.acceptsColorShapeAndProperties(p) || !atom.plist.allowsPicking(pos.num(), eligibleForEachOrder)) continue;
                BitSet d = atom.bucketList.destinations(varMap);
                whoAccepts[j].or(d);
            }
            return whoAccepts;
        }

        int accept(Pick pick) {
            ImageObject io;
            if (this.doneWith) {
                throw new IllegalArgumentException("Forgot to scroll?");
            }
            Episode.this.transcript.add(pick);
            ++Episode.this.attemptCnt;
            Episode.this.attemptSpent = Episode.this.attemptSpent + (pick instanceof Move ? 1.0 : Episode.this.xgetPickCost());
            pick.piece = Episode.this.pieces[pick.pos];
            if (pick.piece == null) {
                pick.code = 3;
                return 3;
            }
            pick.pieceId = (int)pick.piece.getId();
            if (!(pick instanceof Move)) {
                pick.code = this.isMoveable[pick.pos] ? 0 : 4;
                return pick.code;
            }
            Move move = (Move)pick;
            BitSet[] r = this.acceptanceMap[pick.pos];
            Vector<Integer> acceptingAtoms = new Vector<Integer>();
            Vector<CallSite> v = new Vector<CallSite>();
            for (int j = 0; j < this.row.size(); ++j) {
                if (!r[j].get(move.bucketNo)) continue;
                v.add((CallSite)((Object)(j + "(c=" + this.ourCounter[j] + ")")));
                acceptingAtoms.add(j);
                if (this.ourCounter[j] <= 0) continue;
                int n = j;
                this.ourCounter[n] = this.ourCounter[n] - 1;
            }
            if (acceptingAtoms.isEmpty()) {
                move.code = 4;
                return 4;
            }
            if (this.ourGlobalCounter > 0) {
                --this.ourGlobalCounter;
            }
            ++Episode.this.doneMoveCnt;
            if (move.piece.xgetColor() != null) {
                Episode.this.pcMap.put(move.piece.xgetColor(), move.bucketNo);
            }
            if (move.piece.xgetShape() != null) {
                Episode.this.psMap.put(move.piece.xgetShape(), move.bucketNo);
            }
            if ((io = move.piece.getImageObject()) != null) {
                for (String key : io.keySet()) {
                    HashMap<String, Integer> h = (HashMap<String, Integer>)Episode.this.propMap.get(key);
                    if (h == null) {
                        h = new HashMap<String, Integer>();
                        Episode.this.propMap.put(key, h);
                    }
                    h.put((String)io.get(key), move.bucketNo);
                }
            }
            Episode.this.pMap = move.bucketNo;
            Episode.this.pieces[move.pos].setBuckets(new int[0]);
            ((Episode)Episode.this).removedPieces[move.pos] = Episode.this.pieces[move.pos];
            Episode.this.removedPieces[move.pos].setDropped(move.bucketNo);
            ((Episode)Episode.this).pieces[move.pos] = null;
            this.doneWith = this.exhausted() || !this.buildAcceptanceMap();
            Episode.this.cleared = Episode.this.onBoard().cardinality() == 0;
            move.code = 0;
            return 0;
        }

        boolean exhausted() {
            if (this.row.globalCounter >= 0 && this.ourGlobalCounter == 0) {
                return true;
            }
            for (int j = 0; j < this.row.size(); ++j) {
                if (((RuleSet.Atom)this.row.get((int)j)).counter < 0) {
                    return false;
                }
                if (this.ourCounter[j] <= 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Move
    extends Pick {
        public final int bucketNo;

        public int getBucketNo() {
            return this.bucketNo;
        }

        Move(int _pos, int b) {
            super(_pos);
            this.bucketNo = b;
        }

        public Move(Board.Pos pos, Board.Pos bu) {
            this(pos.num(), bu.bucketNo());
        }

        @Override
        public String toString() {
            return "MOVE " + this.pos + " " + new Board.Pos(this.pos) + " to B" + this.bucketNo + ", code=" + this.code;
        }
    }

    public static class Pick {
        public final int pos;
        int pieceId = -1;
        Piece piece = null;
        int code;
        public final Date time = new Date();

        Pick(int _pos) {
            this.pos = _pos;
        }

        public Pick(Board.Pos pos) {
            this(pos.num());
        }

        public int getPos() {
            return this.pos;
        }

        public int getPieceId() {
            return this.pieceId;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return "PICK " + this.pos + " " + new Board.Pos(this.pos) + ", code=" + this.code;
        }
    }
}

