/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.util.ImportCSV;
import edu.wisc.game.util.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
public class EpisodeInfo
extends Episode {
    @ManyToOne(fetch=FetchType.EAGER)
    private PlayerInfo player;
    public static HashMap<String, Episode> globalAllEpisodes = new HashMap();
    Date endTime;
    int finishCode;
    boolean bonus;
    boolean bonusSuccessful;
    boolean earnedBonus;
    int rewardMain;
    int rewardBonus;
    int seriesNo;
    @Basic
    boolean guessSaved;
    @Basic
    String guess = null;
    @Basic
    int guessConfidence;
    @Transient
    private final ParaSet para;
    @Transient
    private final double clearingThreshold;
    private static final double eps = 1.0E-6;

    public PlayerInfo getPlayer() {
        return this.player;
    }

    public void setPlayer(PlayerInfo _player) {
        this.player = _player;
    }

    public static Episode locateEpisode(String eid) {
        return globalAllEpisodes.get(eid);
    }

    public void cache() {
        globalAllEpisodes.put(this.episodeId, this);
    }

    void updateFinishCode() {
        this.finishCode = this.getFinishCode();
    }

    public boolean isBonus() {
        return this.bonus;
    }

    public void setBonus(boolean _bonus) {
        this.bonus = _bonus;
    }

    int getTotalRewardEarned() {
        return this.rewardMain + this.rewardBonus;
    }

    public int getSeriesNo() {
        return this.seriesNo;
    }

    public void setSeriesNo(int _seriesNo) {
        this.seriesNo = _seriesNo;
    }

    public boolean getGuessSaved() {
        return this.guessSaved;
    }

    public void setGuessSaved(boolean _guessSaved) {
        this.guessSaved = _guessSaved;
    }

    public String getGuess() {
        return this.guess;
    }

    public void setGuess(String _guess) {
        int L = 255;
        if (_guess.length() > 255) {
            _guess = _guess.substring(0, 255);
        }
        this.guess = _guess;
    }

    public int getGuessConfidence() {
        return this.guessConfidence;
    }

    public void setGuessConfidence(int _guessConfidence) {
        this.guessConfidence = _guessConfidence;
    }

    public ParaSet xgetPara() {
        return this.para;
    }

    @Override
    double xgetPickCost() {
        return this.para.getPickCost();
    }

    EpisodeInfo(Game game, ParaSet _para) {
        super(game, Episode.OutputMode.BRIEF, null, null);
        this.para = _para;
        this.clearingThreshold = this.para == null ? 1.0 : this.para.getClearingThreshold();
    }

    static EpisodeInfo mkEpisodeInfo(int seriesNo, GameGenerator gg, ParaSet para, boolean bonus) throws IOException, RuleParseException {
        Game game = gg.nextGame();
        EpisodeInfo epi = new EpisodeInfo(game, para);
        epi.bonus = bonus;
        epi.seriesNo = seriesNo;
        epi.cache();
        return epi;
    }

    @Override
    boolean weShowAllMovables() {
        return !this.para.isFeedbackSwitchesFree();
    }

    private Double movesLeftToStayInBonus() {
        if (!this.bonus) {
            return null;
        }
        double x = (double)this.getNPiecesStart() * this.clearingThreshold - this.attemptSpent;
        if (!this.para.isFeedbackSwitchesFree() || this.para.pickCostIsInt()) {
            x = (int)x;
        }
        return new Double(x);
    }

    @Override
    public Episode.Display doMove(int y, int x, int by, int bx, int _attemptCnt) throws IOException {
        Episode.Display _q = super.doMove(y, x, by, bx, _attemptCnt);
        return this.processMove(_q);
    }

    @Override
    public Episode.Display doPick(int y, int x, int _attemptCnt) throws IOException {
        Episode.Display _q = super.doPick(y, x, _attemptCnt);
        return this.processMove(_q);
    }

    private Episode.Display processMove(Episode.Display _q) throws IOException {
        if (this.bonus) {
            if (this.isCompleted()) {
                if (this.movesLeftToStayInBonus() < -1.0E-6) {
                    this.lost = true;
                    Logging.info("PM: Lost (cleared, but with negative balance), episodeId=" + this.episodeId);
                    this.bonusSuccessful = false;
                } else {
                    this.lost = false;
                    this.bonusSuccessful = this.cleared;
                    Logging.info("PM: Completed (bonusSuccesful=" + this.bonusSuccessful + "), episodeId=" + this.episodeId);
                }
            } else {
                this.lost = this.movesLeftToStayInBonus() < 0.999999;
                Logging.info("PM: not cleared yet, lost=" + this.lost + ", episodeId=" + this.episodeId);
            }
        }
        if (this.isCompleted() && this.getPlayer() != null) {
            this.getPlayer().ended(this);
        }
        this.updateFinishCode();
        ExtendedDisplay q = new ExtendedDisplay(_q);
        return q;
    }

    @Override
    public String report() {
        return "[" + this.episodeId + "; FC=" + this.getFinishCode() + (this.getGuessSaved() ? "g" : "") + "; " + (this.earnedBonus ? "BB" : (this.bonusSuccessful ? "B" : (this.bonus & this.lost ? "L" : (this.bonus ? "b" : "m")))) + " " + this.attemptCnt + "/" + this.getNPiecesStart() + " $" + this.getTotalRewardEarned() + "]";
    }

    @Override
    public Board getCurrentBoard() {
        return this.getCurrentBoard(true);
    }

    @Override
    public Episode.Display mkDisplay() {
        return new ExtendedDisplay(-8, "Display requested");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDetailedTranscriptToFile(File f) {
        CharSequence[] keys = new String[]{"playerId", "trialListId", "seriesNo", "ruleId", "episodeNo", "episodeId", "moveNo", "timestamp", "reactionTime", "objectType", "objectId", "y", "x", "bucketId", "by", "bx", "code", "objectCnt"};
        HashMap<String, Object> h = new HashMap<String, Object>();
        PlayerInfo x = this.getPlayer();
        int moveNo = 0;
        Date prevTime = this.getStartTime();
        int objectCnt = this.getNPiecesStart();
        Vector<String> lines = new Vector<String>();
        for (Episode.Pick move : this.transcript) {
            h.clear();
            h.put("playerId", x.getPlayerId());
            h.put("trialListId", x.getTrialListId());
            h.put("seriesNo", this.getSeriesNo());
            PlayerInfo.Series ser = x.getSeries(this.getSeriesNo());
            h.put("ruleId", ser.para.getRuleSetName());
            h.put("episodeNo", ser.episodes.indexOf(this));
            h.put("episodeId", this.getEpisodeId());
            h.put("moveNo", moveNo++);
            h.put("timestamp", sdf2.format(move.time));
            long msec = move.time.getTime() - prevTime.getTime();
            h.put("reactionTime", "" + (double)msec / 1000.0);
            prevTime = move.time;
            Piece piece = move.piece;
            h.put("objectType", piece == null ? "" : move.piece.objectType());
            h.put("objectId", piece == null ? "" : Long.valueOf(move.piece.getId()));
            Board.Pos q = new Board.Pos(move.pos);
            h.put("y", q.y);
            h.put("x", q.x);
            if (move instanceof Episode.Move) {
                Episode.Move m = (Episode.Move)move;
                h.put("bucketId", m.bucketNo);
                Board.Pos b = Board.buckets[m.bucketNo];
                h.put("by", b.y);
                h.put("bx", b.x);
            } else {
                h.put("bucketId", "");
                h.put("by", "");
                h.put("bx", "");
            }
            h.put("code", move.code);
            if (move.code == 0) {
                --objectCnt;
            }
            h.put("objectCnt", objectCnt);
            Vector<CallSite> v = new Vector<CallSite>();
            for (CharSequence key : keys) {
                v.add((CallSite)((Object)("" + h.get(key))));
            }
            lines.add(String.join((CharSequence)",", v));
        }
        String string = "Board file writing lock";
        synchronized ("Board file writing lock") {
            try {
                PrintWriter w = new PrintWriter(new FileWriter(f, true));
                if (f.length() == 0L) {
                    w.println("#" + String.join((CharSequence)",", keys));
                }
                for (String line : lines) {
                    w.println(line);
                }
                w.close();
            }
            catch (IOException ex) {
                System.err.println("Error writing the transcript: " + ex);
                ex.printStackTrace(System.err);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGuessToFile(File f, String guessText, int confidence) {
        CharSequence[] keys = new String[]{"playerId", "trialListId", "seriesNo", "ruleId", "episodeNo", "episodeId", "guess", "guessConfidence"};
        HashMap<String, Object> h = new HashMap<String, Object>();
        PlayerInfo x = this.getPlayer();
        boolean moveNo = false;
        Date prevTime = this.getStartTime();
        int objectCnt = this.getNPiecesStart();
        h.clear();
        h.put("playerId", x.getPlayerId());
        h.put("trialListId", x.getTrialListId());
        h.put("seriesNo", this.getSeriesNo());
        PlayerInfo.Series ser = x.getSeries(this.getSeriesNo());
        h.put("ruleId", ser.para.getRuleSetName());
        h.put("episodeNo", ser.episodes.indexOf(this));
        h.put("episodeId", this.getEpisodeId());
        h.put("guess", ImportCSV.escape(guessText));
        h.put("guessConfidence", confidence);
        Vector<CallSite> v = new Vector<CallSite>();
        for (String string : keys) {
            v.add((CallSite)((Object)("" + h.get(string))));
        }
        String line = String.join((CharSequence)",", v);
        String string = "Board file writing lock";
        synchronized ("Board file writing lock") {
            try {
                PrintWriter w = new PrintWriter(new FileWriter(f, true));
                if (f.length() == 0L) {
                    w.println("#" + String.join((CharSequence)",", keys));
                }
                w.println(line);
                w.close();
            }
            catch (IOException ex) {
                System.err.println("Error writing the guess: " + ex);
                ex.printStackTrace(System.err);
            }
            return;
        }
    }

    public class ExtendedDisplay
    extends Episode.Display {
        boolean bonus;
        int totalRewardEarned;
        int seriesNo;
        int episodeNo;
        int bonusEpisodeNo;
        boolean canActivateBonus;
        int totalBoardsPredicted;
        boolean guessSaved;
        Double movesLeftToStayInBonus;
        PlayerInfo.TransitionMap transitionMap;
        String trialListId;
        String ruleSetName;

        ExtendedDisplay(int _code, String _errmsg) {
            super(_code, _errmsg);
            this.totalRewardEarned = 0;
            this.guessSaved = EpisodeInfo.this.guessSaved;
            this.movesLeftToStayInBonus = null;
            this.transitionMap = null;
            this.bonus = EpisodeInfo.this.isBonus();
            this.seriesNo = EpisodeInfo.this.getSeriesNo();
            if (EpisodeInfo.this.getPlayer() != null) {
                PlayerInfo p = EpisodeInfo.this.getPlayer();
                this.trialListId = p.getTrialListId();
                this.episodeNo = p.seriesSize(this.seriesNo) - 1;
                this.bonusEpisodeNo = this.bonus ? p.countBonusEpisodes(this.seriesNo) - 1 : 0;
                this.canActivateBonus = p.canActivateBonus();
                this.totalRewardEarned = p.getTotalRewardEarned();
                this.totalBoardsPredicted = p.totalBoardsPredicted();
                ParaSet para = p.getPara(EpisodeInfo.this);
                this.ruleSetName = para.getRuleSetName();
                this.movesLeftToStayInBonus = EpisodeInfo.this.movesLeftToStayInBonus();
                if (this.getFinishCode() != 0) {
                    this.transitionMap = new PlayerInfo.TransitionMap(p);
                }
                this.errmsg = this.errmsg + "\nDEBUG\n" + EpisodeInfo.this.getPlayer().report();
                if (EpisodeInfo.this.isNotPlayable()) {
                    String msg = "Sadly, you cannot continue playing, because the server has been restarted since the last episode, and the board has been purged out of the server memory. This problem could perhaps have been prevented if the client had made a /newEpisode call, rather than /display, after the last /mostRecentEpisode.";
                    this.setErrmsg(msg);
                    this.setError(true);
                }
            }
        }

        ExtendedDisplay(Episode.Display d) {
            this(d.code, d.errmsg);
        }

        public boolean isBonus() {
            return this.bonus;
        }

        public int getTotalRewardEarned() {
            return this.totalRewardEarned;
        }

        public int getSeriesNo() {
            return this.seriesNo;
        }

        public int getEpisodeNo() {
            return this.episodeNo;
        }

        public int getBonusEpisodeNo() {
            return this.bonusEpisodeNo;
        }

        public boolean getCanActivateBonus() {
            return this.canActivateBonus;
        }

        public int getTotalBoardsPredicted() {
            return this.totalBoardsPredicted;
        }

        public boolean getGuessSaved() {
            return this.guessSaved;
        }

        public Double getMovesLeftToStayInBonus() {
            return this.movesLeftToStayInBonus;
        }

        public PlayerInfo.TransitionMap getTransitionMap() {
            return this.transitionMap;
        }

        public String getTrialListId() {
            return this.trialListId;
        }

        public String getRuleSetName() {
            return this.ruleSetName;
        }
    }
}

