/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.PredefinedBoardGameGenerator;
import edu.wisc.game.sql.RandomGameGenerator;
import edu.wisc.game.sql.RandomImageGameGenerator;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.RandomRG;
import java.io.File;
import java.io.IOException;

public abstract class GameGenerator {
    final RandomRG random;
    final RuleSet rules;
    int produceCnt = 0;

    public RuleSet getRules() {
        return this.rules;
    }

    GameGenerator(RandomRG _random, RuleSet _rules) {
        this.rules = _rules;
        this.random = _random;
    }

    public abstract Game nextGame();

    void next() {
        ++this.produceCnt;
    }

    public void advance(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative n");
        }
        for (int k = 0; k < n; ++k) {
            this.nextGame();
        }
    }

    public static GameGenerator mkGameGenerator(RandomRG _random, ParaSet para) throws IOException, RuleParseException, IllegalInputException, ReflectiveOperationException {
        GameGenerator gg;
        String ruleSetName = para.getRuleSetName();
        String initial_boards = (String)para.get("initial_boards");
        String initial_boards_order = (String)para.get("initial_boards_order");
        if (initial_boards != null && initial_boards.length() > 0) {
            if (initial_boards_order == null || initial_boards_order.length() == 0) {
                throw new IllegalInputException("Parameter sets specifies initial_boards, but not initial_boards_order");
            }
            File boardDir = Files.inputBoardSubdir(initial_boards);
            gg = new PredefinedBoardGameGenerator(_random, ruleSetName, boardDir, initial_boards_order);
        } else if (para.images != null) {
            int[] nPiecesRange = new int[]{para.getInt("min_objects"), para.getInt("max_objects")};
            gg = new RandomImageGameGenerator(_random, ruleSetName, nPiecesRange, para.images);
        } else {
            int[] nPiecesRange = new int[]{para.getInt("min_objects"), para.getInt("max_objects")};
            int[] nShapesRange = new int[]{para.getInt("min_shapes"), para.getInt("max_shapes")};
            int[] nColorsRange = new int[]{para.getInt("min_colors"), para.getInt("max_colors")};
            gg = new RandomGameGenerator(_random, ruleSetName, nPiecesRange, nShapesRange, nColorsRange, para.shapes, para.colors);
        }
        return gg;
    }
}

