/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.rest.Files;
import edu.wisc.game.sql.PropertiesTable;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageObject
extends HashMap<String, String> {
    public final String key;
    public final File file;
    private static HashMap<String, ImageObject> allImageObjects = new HashMap();
    static final int TOO_MANY = 1000;
    private static HashSet<String> nonImageExtensions = Util.array2set("csv", "sh", "bat");

    private ImageObject(File _file) {
        this.file = _file;
        this.key = ImageObject.fileToKey(this.file);
    }

    public static synchronized void clearTable() {
        allImageObjects.clear();
    }

    private void enlist() {
        allImageObjects.put(this.key, this);
    }

    private static String fileToKey(File f) {
        String prefix;
        String key = f.toString();
        return key.startsWith(prefix = Files.shapesDir() + "/") ? key.substring(prefix.length()) : key;
    }

    static synchronized ImageObject mkBlankImageObjectPlain(File dir, String plainName) throws IOException {
        File f;
        if (((String)plainName).indexOf("/") >= 0 || ((String)plainName).indexOf("\\") >= 0 || ((String)plainName).startsWith(".")) {
            throw new IllegalArgumentException("Invalid plain file name: '" + (String)plainName + "'");
        }
        if (!((String)plainName).matches(".*\\.[a-zA-Z0-9]+")) {
            plainName = (String)plainName + ".svg";
        }
        if (!(f = new File(dir, (String)plainName)).exists()) {
            throw new IOException("Image file '" + f + "' does not exist");
        }
        if (!f.isFile() || !f.canRead()) {
            throw new IOException("Image file '" + f + "' is not readable (or is not a regular file)");
        }
        return new ImageObject(f);
    }

    public static synchronized ImageObject obtainImageObjectPlain(File dir, String plainPath, boolean allowMissing) {
        if (!((String)plainPath).matches(".*\\.[a-zA-Z0-9]+")) {
            plainPath = (String)plainPath + ".svg";
        }
        File f = dir != null ? new File(dir, (String)plainPath) : (((String)plainPath).startsWith("/") ? new File((String)plainPath) : new File(Files.shapesDir(), (String)plainPath));
        return ImageObject.obtainImageObjectPlain(f, allowMissing);
    }

    public static synchronized ImageObject obtainImageObjectPlain(File f) {
        return ImageObject.obtainImageObjectPlain(f, false);
    }

    public static synchronized ImageObject obtainImageObjectPlain(File f, boolean allowMissing) {
        String key = ImageObject.fileToKey(f);
        ImageObject z = allImageObjects.get(key);
        if (z != null) {
            return z;
        }
        if (!f.canRead()) {
            throw new IllegalArgumentException("No image file exists: " + f);
        }
        File dir = f.getParentFile();
        PropertiesTable pt = new PropertiesTable(dir);
        if (pt.error) {
            throw new IllegalArgumentException("Error reading property table for dir=" + dir + ": " + pt.errmsg);
        }
        for (ImageObject x : pt.values()) {
            x.enlist();
        }
        z = allImageObjects.get(key);
        if (z == null && !allowMissing) {
            throw new IllegalArgumentException("No valid entry for file=" + f + " (key=" + key + ") found in the properties file in directory=" + dir);
        }
        return z;
    }

    public static Vector<ImageObject> obtainImageObjects(String wildCardPath) {
        File dir;
        if (wildCardPath == null || wildCardPath.length() == 0) {
            throw new IllegalArgumentException("Image path not specified or empty");
        }
        if (wildCardPath.startsWith("/")) {
            dir = new File("/");
            wildCardPath = wildCardPath.substring(1);
        } else {
            dir = Files.shapesDir();
        }
        return ImageObject.obtainImageObjects3(dir, Util.array2vector(wildCardPath.split("/")));
    }

    private static Vector<ImageObject> obtainImageObjects3(File dir, Vector<String> relativeWildCardPath) {
        String[] children;
        String q;
        Vector<ImageObject> v = new Vector<ImageObject>();
        while (relativeWildCardPath.size() > 0 && !ImageObject.mayBeWild(relativeWildCardPath.get(0))) {
            q = relativeWildCardPath.get(0);
            if (relativeWildCardPath.size() == 1) {
                v.add(ImageObject.obtainImageObjectPlain(dir, q, true));
                return v;
            }
            if (!(dir = new File(dir, q)).isDirectory()) {
                throw new IllegalArgumentException("No such directory: " + dir);
            }
            relativeWildCardPath.remove(0);
        }
        if (relativeWildCardPath.size() == 0) {
            return v;
        }
        q = relativeWildCardPath.get(0);
        relativeWildCardPath.remove(0);
        if (q.equals("**")) {
            if (relativeWildCardPath.size() > 0) {
                throw new IllegalArgumentException("The element '**' can only be used as the last element of the path");
            }
            return ImageObject.getAllFilesFromTree(dir);
        }
        Pattern pat = ImageObject.wildCardToRegex(q);
        for (String x : children = dir.list()) {
            Matcher m;
            if (ImageObject.isIgnorableFile(x)) continue;
            File f = new File(dir, x);
            if (f.isFile() && relativeWildCardPath.size() == 0) {
                m = pat.matcher(x);
                if (m.matches() || x.endsWith(".svg") && pat.matcher(x.replaceAll("\\.svg$", "")).matches()) {
                    ImageObject io = ImageObject.obtainImageObjectPlain(f, false);
                    v.add(io);
                }
            } else if (f.isDirectory() && relativeWildCardPath.size() > 0 && (m = pat.matcher(x)).matches()) {
                v.addAll(ImageObject.obtainImageObjects3(f, relativeWildCardPath));
            }
            if (v.size() <= 1000) continue;
            throw new IllegalArgumentException("The wildcard expression requires too many files (more than 1000)");
        }
        return v;
    }

    private static Vector<ImageObject> getAllFilesFromTree(File dir) {
        String[] children;
        Vector<ImageObject> v = new Vector<ImageObject>();
        for (String x : children = dir.list()) {
            if (ImageObject.isIgnorableFile(x)) continue;
            File f = new File(dir, x);
            if (f.isFile()) {
                ImageObject io = ImageObject.obtainImageObjectPlain(f, true);
                if (io != null) {
                    v.add(io);
                }
            } else if (f.isDirectory()) {
                v.addAll(ImageObject.getAllFilesFromTree(f));
            }
            if (v.size() <= 1000) continue;
            throw new IllegalArgumentException("The wildcard expression requires too many files (more than 1000)");
        }
        return v;
    }

    private static boolean isIgnorableFile(String x) {
        String[] v = x.split("\\.");
        String q = v[v.length - 1].toLowerCase();
        return x.endsWith("~") || nonImageExtensions.contains(q);
    }

    private static boolean mayBeWild(String x) {
        for (char c : x.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue;
            return true;
        }
        return false;
    }

    private static Pattern wildCardToRegex(String wild) throws IllegalArgumentException {
        StringBuffer b = new StringBuffer();
        for (char c : wild.toCharArray()) {
            if (c == '\\') {
                throw new IllegalArgumentException("Backslash (\\) is not allowed in path names");
            }
            if (c == '?') {
                b.append(".");
                continue;
            }
            if (c == '*') {
                b.append(".*");
                continue;
            }
            if (c == '.') {
                b.append("\\.");
                continue;
            }
            b.append(c);
        }
        return Pattern.compile(b.toString());
    }

    public String listProperties() {
        Object[] keys = this.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        Vector<CallSite> v = new Vector<CallSite>();
        for (Object key : keys) {
            v.add((CallSite)((Object)((String)key + ":" + (String)this.get(key))));
        }
        return String.join((CharSequence)", ", v);
    }

    public String symbol() {
        String[] w = this.key.split("/");
        return w[w.length - 1].substring(0, 1);
    }
}

