/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.util.Logging;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

public class Main {
    public static final String persistenceUnitName = "w2020";
    private static EntityManagerFactory factory = null;
    private static EntityManager oneEm = null;
    static DecimalFormat memFmt = new DecimalFormat("#,###");

    public static int getMyPid() {
        try {
            FileReader fr = new FileReader("/proc/self/stat");
            LineNumberReader r = new LineNumberReader(fr);
            String s = r.readLine();
            if (s == null) {
                return -1;
            }
            String[] q = s.split("\\s+");
            return Integer.parseInt(q[0]);
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public static synchronized EntityManagerFactory getFactory() {
        if (factory == null) {
            factory = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)System.getProperties());
        }
        return factory;
    }

    public static synchronized EntityManager getEM() {
        if (oneEm != null) {
            return oneEm;
        }
        Main.getFactory();
        EntityManager em = factory.createEntityManager();
        Logging.info("EM created, flushMode=" + em.getFlushMode());
        oneEm = em;
        return oneEm;
    }

    public static synchronized EntityManager getNewEM() {
        Main.getFactory();
        EntityManager em = factory.createEntityManager();
        return em;
    }

    public static void memory() {
        Main.memory("");
    }

    public static void memory(String title) {
        System.out.println(Main.memoryInfo(title, true));
    }

    public static String memoryInfo(String title, boolean doGc) {
        Runtime run = Runtime.getRuntime();
        if (doGc) {
            run.gc();
        }
        String s = title != null && title.length() > 0 ? " (" + title + ")" : "";
        long mmem = run.maxMemory();
        long tmem = run.totalMemory();
        long fmem = run.freeMemory();
        long used = tmem - fmem;
        return "[MEMORY]" + s + " max=" + memFmt.format(mmem) + ", total=" + memFmt.format(tmem) + ", free=" + memFmt.format(fmem) + ", used=" + memFmt.format(used);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistObjects(Object ... v) {
        EntityManager em;
        EntityManager entityManager = em = Main.getEM();
        synchronized (entityManager) {
            try {
                em.getTransaction().begin();
                for (Object o : v) {
                    if (em.contains(o)) continue;
                    em.persist(o);
                    String s = o instanceof Episode ? ((Episode)o).report() : (o instanceof PlayerInfo ? ((PlayerInfo)o).report() : o.toString());
                    Logging.info("Persisting " + o.getClass() + ": " + s);
                }
                em.getTransaction().commit();
            }
            finally {
                try {
                    EntityTransaction tran = em.getTransaction();
                    if (tran.isActive()) {
                        tran.commit();
                    }
                }
                catch (Exception ex) {
                    Logging.error("Main.persistObjects(): exception in commit: " + ex);
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    public static <T> void saveObject(T o) {
        EntityManager em = Main.getNewEM();
        try {
            Logging.info("Merging object " + o);
            em.getTransaction().begin();
            Object om = em.merge(o);
            Logging.info("Now, o=" + o + ", om=" + om);
            em.getTransaction().commit();
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
    }
}

