/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.ImageObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
public class Piece
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    @ManyToOne(fetch=FetchType.EAGER)
    private Board board;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @XmlTransient
    private Color color;
    private Shape shape;
    private int x;
    private int y;
    Integer dropped = null;
    private String image;
    @Transient
    private int[] buckets = new int[0];

    public void setBoard(Board _board) {
        this.board = _board;
    }

    public long getId() {
        return this.id;
    }

    @XmlElement
    public void setId(long _id) {
        this.id = _id;
    }

    public String getImage() {
        return this.image;
    }

    @XmlElement
    public void setImage(String _image) {
        this.image = _image;
    }

    public String getProperty(String name) {
        ImageObject io = this.getImageObject();
        return io == null ? null : (String)io.get(name);
    }

    public ImageObject getImageObject() {
        ImageObject x = this.image == null ? null : ImageObject.obtainImageObjectPlain(null, this.image, false);
        return x;
    }

    @XmlTransient
    public Color xgetColor() {
        return this.color;
    }

    public String getColor() {
        return this.color == null ? this.getProperty("color") : this.color.toString();
    }

    public void setColor(Color x) {
        this.color = x;
    }

    public String getShape() {
        return this.shape == null ? this.getProperty("shape") : this.shape.toString();
    }

    public void setShape(Shape x) {
        this.shape = x;
    }

    public Shape xgetShape() {
        return this.shape;
    }

    public String objectType() {
        return this.image != null ? this.image : this.color + "_" + this.shape;
    }

    public int getX() {
        return this.x;
    }

    @XmlElement
    public void setX(int _x) {
        this.x = _x;
    }

    public int getY() {
        return this.y;
    }

    @XmlElement
    public void setY(int _y) {
        this.y = _y;
    }

    public Integer getDropped() {
        return this.dropped;
    }

    @XmlElement
    public void setDropped(Integer _dropped) {
        this.dropped = _dropped;
    }

    public Piece() {
    }

    public Piece(Shape _shape, Color _color, int _x, int _y) {
        this.shape = _shape;
        this.color = _color;
        this.image = null;
        this.x = _x;
        this.y = _y;
    }

    public Piece(String _image, int _x, int _y) {
        this.image = _image;
        this.shape = null;
        this.color = null;
        this.x = _x;
        this.y = _y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Piece)) {
            return false;
        }
        return this.id == ((Piece)o).getId();
    }

    public int hashCode() {
        return 31;
    }

    public Board.Pos pos() {
        return new Board.Pos(this.x, this.y);
    }

    public int[] getBuckets() {
        return this.buckets;
    }

    @XmlElement
    public void setBuckets(int[] _buckets) {
        this.buckets = _buckets;
    }

    public String toString() {
        return "[" + this.objectType() + ", x=" + this.x + ", y=" + this.y + "]";
    }

    public static class Shape
    extends PseudoEnum {
        private static HashMap<String, Shape> allShapes = new HashMap();
        public static final Shape SQUARE = Shape.findShape("SQUARE");
        public static final Shape STAR = Shape.findShape("STAR");
        public static final Shape CIRCLE = Shape.findShape("CIRCLE");
        public static final Shape TRIANGLE = Shape.findShape("TRIANGLE");
        public static final Shape[] legacyShapes = new Shape[]{SQUARE, STAR, CIRCLE, TRIANGLE};

        private Shape(String _name) {
            super(_name);
        }

        public boolean equals(Object o) {
            return o instanceof Shape && ((Shape)o).name.equals(this.name);
        }

        public Collection<Shape> listAllShapes() {
            return allShapes.values();
        }

        public static synchronized Shape findShape(String s) {
            Shape c = allShapes.get(s = s.toUpperCase());
            if (c == null) {
                c = new Shape(s);
                allShapes.put(s, c);
            }
            return c;
        }

        public String symbol() {
            return this == SQUARE ? "#" : (this == STAR ? "*" : (this == CIRCLE ? "O" : (this == TRIANGLE ? "T" : this.name)));
        }
    }

    public static class Color
    extends PseudoEnum {
        private static HashMap<String, Color> allColors = new HashMap();
        public static final Color RED = Color.findColor("RED");
        public static final Color BLACK = Color.findColor("BLACK");
        public static final Color BLUE = Color.findColor("BLUE");
        public static final Color YELLOW = Color.findColor("YELLOW");
        public static final Color[] legacyColors = new Color[]{RED, BLACK, BLUE, YELLOW};

        private Color(String _name) {
            super(_name);
        }

        public boolean equals(Object o) {
            return o instanceof Color && ((Color)o).name.equals(this.name);
        }

        public static synchronized Color findColor(String s) {
            Color c = allColors.get(s = s.toUpperCase());
            if (c == null) {
                c = new Color(s);
                allColors.put(s, c);
            }
            return c;
        }

        public String symbol() {
            String s = this.toString().toLowerCase().substring(0, 1);
            if (this == BLUE) {
                s = "g";
            }
            return s;
        }
    }

    public static class PseudoEnum {
        final String name;

        PseudoEnum(String _name) {
            this.name = _name.toUpperCase();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

