/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.rest.TrialList;
import edu.wisc.game.saved.BoardManager;
import edu.wisc.game.saved.TranscriptManager;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.User;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.Logging;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;

@Entity
public class PlayerInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Basic
    private Date date;
    @ManyToOne(fetch=FetchType.EAGER)
    private User user;
    @Basic
    private String playerId;
    @Basic
    private String experimentPlan;
    @Basic
    private String trialListId;
    @OneToMany(mappedBy="player", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Vector<EpisodeInfo> allEpisodes = new Vector();
    @Transient
    private Vector<Series> allSeries = new Vector();
    private int currentSeriesNo = 0;
    private boolean inBonus;
    private String completionCode;
    private int totalRewardEarned;

    public long getId() {
        return this.id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User _user) {
        this.user = _user;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String _playerId) {
        this.playerId = _playerId;
    }

    public String getExperimentPlan() {
        return this.experimentPlan;
    }

    public void setExperimentPlan(String _experimentPlan) {
        this.experimentPlan = _experimentPlan;
    }

    public String getTrialListId() {
        return this.trialListId;
    }

    public void setTrialListId(String _trialListId) {
        this.trialListId = _trialListId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date _date) {
        this.date = _date;
    }

    public void addEpisode(EpisodeInfo c) {
        this.allEpisodes.add(c);
        c.setPlayer(this);
    }

    public void removeEpisode(EpisodeInfo c) {
        this.allEpisodes.remove(c);
        c.setPlayer(null);
    }

    public Vector<EpisodeInfo> getAllEpisodes() {
        return this.allEpisodes;
    }

    public void setAllEpisodes(Vector<EpisodeInfo> _allEpisodes) {
        for (EpisodeInfo p : this.allEpisodes) {
            p.setPlayer(null);
        }
        this.allEpisodes.setSize(0);
        for (EpisodeInfo p : _allEpisodes) {
            this.addEpisode(p);
        }
    }

    public String toString() {
        return "(PlayerInfo: id=" + this.id + ",  playerId=" + this.playerId + ", trialListId=" + this.trialListId + ", date=" + this.date + ")";
    }

    Series getSeries(int k) {
        return this.allSeries.get(k);
    }

    Series getCurrentSeries() {
        return this.alreadyFinished() ? null : this.allSeries.get(this.currentSeriesNo);
    }

    public boolean alreadyFinished() {
        return this.currentSeriesNo >= this.allSeries.size();
    }

    int totalBoardsPredicted() {
        Series ser = this.getCurrentSeries();
        return ser == null ? 0 : (this.inBonus ? ser.episodes.size() + ser.para.getInt("clear_how_many") - this.countBonusEpisodes(this.currentSeriesNo) : this.getCurrentSeries().para.getMaxBoards());
    }

    public boolean canActivateBonus() {
        if (this.inBonus) {
            return false;
        }
        Series ser = this.getCurrentSeries();
        if (ser == null) {
            return false;
        }
        int at = ser.para.getInt("activate_bonus_at");
        int nowAt = ser.episodes.size();
        if (ser.episodes.size() > 0 && !ser.episodes.lastElement().isCompleted()) {
            --nowAt;
        }
        boolean answer = ++nowAt >= at;
        return answer;
    }

    public void activateBonus(EntityManager em) {
        EpisodeInfo epi;
        if (this.inBonus) {
            throw new IllegalArgumentException("Bonus already activated in the current series");
        }
        if (!this.canActivateBonus()) {
            throw new IllegalArgumentException("Cannot activate bonus in the current series");
        }
        this.inBonus = true;
        Series ser = this.getCurrentSeries();
        if (ser != null && ser.episodes.size() > 0 && !(epi = ser.episodes.lastElement()).isCompleted()) {
            epi.bonus = true;
            System.err.println("Bonus activated for current episode " + epi.episodeId);
        }
        System.err.println("Bonus activated: player=" + this.playerId + ", series No. " + this.currentSeriesNo + ", size=" + ser.episodes.size());
        em.getTransaction().begin();
        em.getTransaction().commit();
    }

    public void giveUp(int seriesNo) throws IOException {
        EpisodeInfo epi;
        Logging.info("giveUp(pid=" + this.playerId + ", seriesNo=" + seriesNo + "), currentSeriesNo=" + this.currentSeriesNo);
        if (seriesNo + 1 == this.currentSeriesNo) {
            Logging.info("giveUp: ignorable call on the previous series");
            return;
        }
        if (seriesNo != this.currentSeriesNo) {
            throw new IllegalArgumentException("Cannot give up on series " + seriesNo + ", because we presently are on series " + this.currentSeriesNo);
        }
        if (seriesNo >= this.allSeries.size()) {
            throw new IllegalArgumentException("Already finished all " + this.allSeries.size() + " series");
        }
        Series ser = this.getCurrentSeries();
        if (!(ser == null && ser.episodes.size() <= 0 || (epi = ser.episodes.lastElement()).isCompleted())) {
            epi.giveUp();
            Logging.info("giveUp: episodeId=" + epi.getEpisodeId() + ", set givenUp=" + epi.givenUp);
            this.ended(epi);
        }
        this.goToNextSeries();
        Logging.info("giveUp completed, now currentSeriesNo=" + this.currentSeriesNo);
    }

    private boolean canHaveAnotherRegularEpisode() {
        Series ser = this.getCurrentSeries();
        return ser != null && !this.inBonus && ser.episodes.size() < ser.para.getMaxBoards();
    }

    private boolean canHaveAnotherBonusEpisode() {
        System.err.println("canHaveAnotherBonusEpisode(" + this.playerId + ",ser=" + this.currentSeriesNo + ")? inBonus=" + this.inBonus);
        Series ser = this.getCurrentSeries();
        if (ser == null) {
            return false;
        }
        System.err.println("ser=" + ser + ", earned=" + ser.bonusHasBeenEarned());
        if (!this.inBonus || ser.bonusHasBeenEarned()) {
            return false;
        }
        int cnt = 0;
        System.err.println("Have " + ser.episodes.size() + " episodes to look at");
        for (EpisodeInfo x : ser.episodes) {
            System.err.println("looking at " + (x.isBonus() ? "bonus" : "main") + " episode " + x.episodeId + ", completed=" + x.isCompleted());
            if (!x.isBonus()) continue;
            ++cnt;
            if (!x.isCompleted()) {
                return false;
            }
            if (!x.bonusSuccessful) {
                return false;
            }
            System.err.println("ok bonus episode " + x.episodeId);
        }
        boolean result = cnt < ser.para.getInt("clear_how_many");
        System.err.println("cnt=" + cnt + ", allowed up to " + ser.para.getInt("clear_how_many") + ", result=" + result);
        return result;
    }

    public int seriesSize(int k) {
        return this.allSeries.get((int)k).episodes.size();
    }

    public int countBonusEpisodes(int k) {
        Series ser = this.allSeries.get(k);
        int cnt = 0;
        for (EpisodeInfo x : ser.episodes) {
            if (!x.isBonus()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getCurrentSeriesNo() {
        return this.currentSeriesNo;
    }

    public void initSeries(TrialList trialList) throws IOException, IllegalInputException, ReflectiveOperationException, RuleParseException {
        if (this.allSeries.size() > 0) {
            throw new IllegalArgumentException("Attempt to initialize PlayerInfor.allSeries again");
        }
        this.allSeries.clear();
        for (ParaSet para : trialList) {
            this.allSeries.add(new Series(para));
        }
    }

    public void restoreTransientFields() throws IOException, IllegalInputException, ReflectiveOperationException, RuleParseException {
        String exp = this.experimentPlan;
        if (exp == null || exp.equals("")) {
            exp = TrialList.extractExperimentPlanFromPlayerId(this.playerId);
        }
        TrialList trialList = new TrialList(exp, this.trialListId);
        this.allSeries.clear();
        int k = 0;
        System.err.println("Restore: will check " + this.allEpisodes.size() + " episodes");
        for (int j = 0; j < trialList.size(); ++j) {
            ParaSet para = (ParaSet)trialList.get(j);
            String ruleSetName = para.getRuleSetName();
            RuleSet rules = AllRuleSets.obtain(ruleSetName);
            Series ser = new Series(para);
            this.allSeries.add(ser);
            boolean needSave = false;
            while (k < this.allEpisodes.size() && this.allEpisodes.get((int)k).seriesNo == j) {
                System.err.print("Restore: check series=" + j + ", ae[" + k + "]=");
                EpisodeInfo epi = this.allEpisodes.get(k++);
                System.err.println(epi.report() + ", completed=" + epi.isCompleted());
                epi.setRules(rules);
                if (!epi.isCompleted()) {
                    epi.giveUp();
                    needSave = true;
                }
                ser.episodes.add(epi);
            }
            ser.gg.advance(ser.episodes.size());
            if (!needSave) continue;
            this.saveMe();
        }
    }

    public EpisodeInfo mostRecentEpisode() {
        for (int k = Math.min(this.currentSeriesNo, this.allSeries.size() - 1); k >= 0; --k) {
            Series ser = this.allSeries.get(k);
            if (ser.episodes.size() <= 0) continue;
            return ser.episodes.lastElement();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EpisodeInfo episodeToDo() throws IOException, RuleParseException {
        Logging.info("episodeToDo(pid=" + this.playerId + "); cs=" + this.currentSeriesNo + ", finished=" + this.alreadyFinished());
        boolean needSave = false;
        try {
            while (this.currentSeriesNo < this.allSeries.size()) {
                EpisodeInfo epi;
                Series ser = this.getCurrentSeries();
                if (ser != null && ser.episodes.size() > 0) {
                    if (this.inBonus && ser.bonusHasBeenEarned()) {
                        this.goToNextSeries();
                        continue;
                    }
                    epi = ser.episodes.lastElement();
                    if (!epi.isCompleted()) {
                        if (epi.isNotPlayable()) {
                            epi.giveUp();
                            needSave = true;
                        } else {
                            Logging.info("episodeToDo(pid=" + this.playerId + "): returning existing episode " + epi.episodeId);
                            EpisodeInfo episodeInfo = epi;
                            return episodeInfo;
                        }
                    }
                }
                epi = null;
                if (this.canHaveAnotherRegularEpisode()) {
                    epi = EpisodeInfo.mkEpisodeInfo(this.currentSeriesNo, ser.gg, ser.para, false);
                } else if (this.canHaveAnotherBonusEpisode()) {
                    epi = EpisodeInfo.mkEpisodeInfo(this.currentSeriesNo, ser.gg, ser.para, true);
                }
                if (epi != null) {
                    ser.episodes.add(epi);
                    this.addEpisode(epi);
                    Logging.info("episodeToDo(pid=" + this.playerId + "): returning new episode " + epi.episodeId);
                    EpisodeInfo episodeInfo = epi;
                    return episodeInfo;
                }
                Logging.info("episodeToDo(pid=" + this.playerId + "): nextSeries");
                this.goToNextSeries();
            }
        }
        finally {
            if (needSave) {
                this.saveMe();
            }
        }
        Logging.info("episodeToDo(pid=" + this.playerId + "): cannot return anything");
        return null;
    }

    private Series whoseEpisode(EpisodeInfo epi) {
        Series s = this.allSeries.get(epi.seriesNo);
        for (EpisodeInfo e : s.episodes) {
            if (e != epi) continue;
            return s;
        }
        System.err.println("whoseEpisode: detected an episod not stored in the current series structure : " + epi);
        return null;
    }

    public ParaSet getPara(EpisodeInfo epi) {
        return this.whoseEpisode((EpisodeInfo)epi).para;
    }

    public String getCompletionCode() {
        return this.completionCode;
    }

    public void setCompletionCode(String _completionCode) {
        this.completionCode = _completionCode;
    }

    private String buildCompletionCode() {
        String s = this.playerId + "-" + Episode.sdf.format(new Date()) + "-";
        for (int i = 0; i < 4; ++i) {
            int k = Episode.random.nextInt(16);
            char c = k < 10 ? (char)(48 + k) : (char)(65 + k - 10);
            s = s + c;
        }
        return s;
    }

    private synchronized void goToNextSeries() {
        if (this.alreadyFinished()) {
            return;
        }
        ++this.currentSeriesNo;
        this.inBonus = false;
        if (this.alreadyFinished() && this.completionCode == null) {
            this.completionCode = this.buildCompletionCode();
        }
        this.saveMe();
    }

    public int getTotalRewardEarned() {
        return this.totalRewardEarned;
    }

    public void setTotalRewardEarned(int _totalRewardEarned) {
        this.totalRewardEarned = _totalRewardEarned;
    }

    private void updateTotalReward() {
        int sum = 0;
        int cnt = 0;
        for (Series ser : this.allSeries) {
            for (EpisodeInfo epi : ser.episodes) {
                ++cnt;
                sum += epi.getTotalRewardEarned();
            }
        }
        this.totalRewardEarned = sum;
        System.err.println("Total reward(" + this.playerId + "):=" + this.totalRewardEarned + ", based on " + cnt + " episodes");
    }

    void ended(EpisodeInfo epi) throws IOException {
        Series ser = this.whoseEpisode(epi);
        if (ser == null) {
            throw new IllegalArgumentException("Could not figure to which series this episode belongs");
        }
        epi.endTime = new Date();
        if (epi.stalemate) {
            this.goToNextSeries();
        } else if (epi.cleared) {
            double smax = ser.para.getDouble("max_points");
            double smin = ser.para.getDouble("min_points");
            double b = ser.para.getDouble("b");
            double d = epi.attemptSpent - (double)epi.getNPiecesStart();
            epi.rewardMain = (int)Math.round(smin + (smax - smin) / (1.0 + Math.exp(b * (d - 2.0))));
            if (epi.bonus) {
                ser.assignBonus();
            }
            this.updateTotalReward();
        }
        epi.updateFinishCode();
        Logging.info("PlayerInfo.ended(epi=" + epi.getEpisodeId() + "); finishCode =" + epi.finishCode);
        this.saveMe();
        File f = Files.boardsFile(this.playerId);
        Board b = epi.getCurrentBoard(true);
        BoardManager.saveToFile(b, this.playerId, epi.episodeId, f);
        f = Files.transcriptsFile(this.playerId);
        TranscriptManager.saveTranscriptToFile(this.playerId, epi.episodeId, f, epi.transcript);
        f = Files.detailedTranscriptsFile(this.playerId);
        epi.saveDetailedTranscriptToFile(f);
    }

    public String report() {
        Vector<Object> v = new Vector<Object>();
        int j = 0;
        for (Series ser : this.allSeries) {
            Object s = "";
            if (j == this.currentSeriesNo) {
                s = (String)s + (this.inBonus ? "*B*" : "*M*");
            }
            s = (String)s + "[" + j + "]";
            for (EpisodeInfo epi : ser.episodes) {
                s = (String)s + epi.report();
            }
            v.add(s);
            ++j;
        }
        v.add("id=" + this.id + ", curSer=" + this.currentSeriesNo + " b=" + this.inBonus + ", R=$" + this.getTotalRewardEarned());
        return String.join((CharSequence)"\n", v);
    }

    public void saveMe() {
        Main.saveObject(this);
    }

    public class TransitionMap
    extends HashMap<Transition, Action> {
        public TransitionMap() {
            Transition whitherNext;
            Series ser = PlayerInfo.this.getCurrentSeries();
            if (ser == null) {
                return;
            }
            boolean isLastSeries = PlayerInfo.this.currentSeriesNo + 1 == PlayerInfo.this.allSeries.size();
            Transition transition = whitherNext = isLastSeries ? Transition.END : Transition.NEXT;
            if (PlayerInfo.this.inBonus) {
                if (PlayerInfo.this.canHaveAnotherBonusEpisode()) {
                    this.put(Transition.BONUS, Action.DEFAULT);
                    this.put(whitherNext, Action.GIVE_UP);
                } else {
                    this.put(whitherNext, Action.DEFAULT);
                }
            } else {
                if (ser.episodes.size() < ser.para.getMaxBoards()) {
                    this.put(Transition.MAIN, Action.DEFAULT);
                    this.put(whitherNext, Action.GIVE_UP);
                } else {
                    this.put(whitherNext, Action.DEFAULT);
                }
                if (PlayerInfo.this.canActivateBonus()) {
                    this.put(Transition.BONUS, Action.ACTIVATE);
                }
            }
        }
    }

    public static enum Action {
        DEFAULT,
        ACTIVATE,
        GIVE_UP;

    }

    public static enum Transition {
        MAIN,
        BONUS,
        NEXT,
        END;

    }

    class Series {
        final ParaSet para;
        final GameGenerator gg;
        Vector<EpisodeInfo> episodes = new Vector();

        Series(ParaSet _para) throws IOException, IllegalInputException, ReflectiveOperationException, RuleParseException {
            this.para = _para;
            this.gg = GameGenerator.mkGameGenerator(Episode.random, this.para);
        }

        public String toString() {
            return "(Series: para.rules=" + this.para.getRuleSetName() + ", episode cnt= " + this.episodes.size() + ")";
        }

        int countBonusEpisodes() {
            int cnt = 0;
            for (EpisodeInfo x : this.episodes) {
                if (!x.bonus) continue;
                ++cnt;
            }
            return cnt;
        }

        private void assignBonus() {
            int cnt = 0;
            int deserveCnt = 0;
            for (EpisodeInfo x : this.episodes) {
                if (!x.bonus) continue;
                ++cnt;
                if (!x.bonusSuccessful) continue;
                ++deserveCnt;
            }
            if (cnt == deserveCnt && deserveCnt >= this.para.getInt("clear_how_many")) {
                int r = 0;
                for (EpisodeInfo x : this.episodes) {
                    if (!x.bonusSuccessful) continue;
                    x.earnedBonus = ++r == cnt;
                    x.rewardBonus = x.earnedBonus ? this.para.getInt("bonus_extra_pts") : 0;
                }
            }
        }

        boolean bonusHasBeenEarned() {
            for (EpisodeInfo x : this.episodes) {
                if (!x.earnedBonus) continue;
                return true;
            }
            return false;
        }
    }
}

