/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.rest.ColorMap;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.RandomRG;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;

public class PredefinedBoardGameGenerator
extends GameGenerator {
    final Board[] boards;
    private Vector<Integer> remainingRandom = new Vector();
    final Mode mode;
    private static final String ext = ".json";

    @Override
    public Game nextGame() {
        int pos = 0;
        if (this.mode == Mode.ALPHA || this.mode == Mode.LIST) {
            pos = this.produceCnt % this.boards.length;
        } else if (this.mode == Mode.RANDOM) {
            if (this.remainingRandom.size() == 0) {
                int n = this.boards.length;
                this.remainingRandom = this.random.randomSubsetPermuted(n, n);
            }
            pos = this.remainingRandom.remove(0);
        }
        Board b = this.boards[pos];
        this.next();
        return new Game(this.rules, b);
    }

    PredefinedBoardGameGenerator(RandomRG _random, String ruleSetName, File boardDir, String modeString) throws IOException, IllegalInputException, RuleParseException, ReflectiveOperationException {
        super(_random, AllRuleSets.obtain(ruleSetName));
        Mode _mode;
        File orderFile = null;
        try {
            _mode = Enum.valueOf(Mode.class, modeString.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            _mode = Mode.LIST;
            if (!modeString.toLowerCase().endsWith(".csv")) {
                throw new IllegalArgumentException("The initial_boards_order='" + modeString + "', which is neither RANDOM nor ALPHA nor a CSV file name");
            }
            orderFile = modeString.startsWith("/") ? new File(modeString) : new File(boardDir, modeString);
        }
        this.mode = _mode;
        Vector vb = new Vector();
        Vector<Object> fv = new Vector<Object>();
        System.out.println("PredefinedBoardGameGenerator, dir=" + boardDir + ", mode=" + this.mode);
        if (this.mode == Mode.RANDOM || this.mode == Mode.ALPHA) {
            Object[] ff = boardDir.listFiles();
            if (this.mode == Mode.ALPHA) {
                Arrays.sort(ff);
            }
            System.out.println("ff=" + Util.joinNonBlank(", ", ff));
            for (Object cf : ff) {
                String fname;
                if (!((File)cf).isFile() || !(fname = ((File)cf).getName()).endsWith(ext)) continue;
                fv.add(cf);
            }
        } else if (this.mode == Mode.LIST) {
            if (orderFile == null) {
                throw new IllegalArgumentException("Board order file nor specified");
            }
            if (!orderFile.canRead()) {
                throw new IllegalArgumentException("Cannor read board order file: " + orderFile);
            }
            CsvData csv = new CsvData(orderFile);
            for (CsvData.LineEntry e : csv.entries) {
                File f;
                Object s = e.getKey();
                if (!((String)s).endsWith(ext)) {
                    s = (String)s + ext;
                }
                if (!(f = new File(boardDir, (String)s)).canRead()) {
                    throw new IllegalArgumentException("The order file mentions board file that cannot be found or read: " + f);
                }
                fv.add(f);
            }
        }
        this.boards = new Board[fv.size()];
        int j = 0;
        for (File file : fv) {
            this.boards[j++] = Board.readBoard(file);
        }
    }

    public void checkShapesAndColors(ColorMap cm) throws IOException {
        for (Board b : this.boards) {
            b.checkShapesAndColors(cm);
        }
    }

    static enum Mode {
        RANDOM,
        ALPHA,
        LIST;

    }
}

