/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.sql.ImageObject;
import edu.wisc.game.util.CsvData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class PropertiesTable
extends HashMap<String, ImageObject> {
    boolean error;
    String errmsg;
    String path;

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean _error) {
        this.error = _error;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setErrmsg(String _errmsg) {
        this.errmsg = _errmsg;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String _path) {
        this.path = _path;
    }

    private PropertiesTable(boolean _error, String _errmsg) {
        this.setError(_error);
        this.setErrmsg(_errmsg);
    }

    public PropertiesTable(File dir) {
        this(false, "No error");
        File f = new File(dir, "properties.csv");
        this.setPath(f.getPath());
        try {
            if (!f.exists()) {
                throw new IOException("File does not exist: " + f);
            }
            if (!f.canRead()) {
                throw new IOException("Cannot read file: " + f);
            }
            CsvData csv = new CsvData(f, true, false, null);
            if (csv.entries.length < 2) {
                throw new IOException("No data found in file: " + f);
            }
            CsvData.BasicLineEntry header = (CsvData.BasicLineEntry)csv.entries[0];
            int nCol = header.nCol();
            if (nCol < 1) {
                throw new IOException("Empty header in a property file");
            }
            if (!header.getCol(0).replaceAll("^#", "").equals("image")) {
                throw new IOException("The name of the first column in a property file must be 'image'");
            }
            for (int j = 1; j < csv.entries.length; ++j) {
                CsvData.BasicLineEntry line = (CsvData.BasicLineEntry)csv.entries[j];
                ImageObject z = this.mkImageObject(dir, header, line);
                this.put(z.key, this.mkImageObject(dir, header, line));
            }
        }
        catch (Exception ex) {
            this.setError(true);
            this.setErrmsg(ex.getMessage());
        }
    }

    private ImageObject mkImageObject(File dir, CsvData.BasicLineEntry header, CsvData.BasicLineEntry line) throws IOException {
        int nCol = header.nCol();
        if (nCol != line.nCol()) {
            throw new IOException("Column count mismatch:\nHEADER=" + header + ";\nLINE=" + line);
        }
        HashMap io = null;
        for (int k = 0; k < nCol; ++k) {
            String key = header.getCol(k);
            key = key.replaceAll("^#", "");
            String val = line.getCol(k);
            if (k == 0) {
                if (!key.equals("image")) {
                    throw new IOException("First column must be named 'image'");
                }
                if (val == null || val.equals("")) {
                    throw new IOException("First column may not be empty: file name must be specified");
                }
                io = ImageObject.mkBlankImageObjectPlain(dir, val);
                continue;
            }
            io.put(key, val);
        }
        return io;
    }
}

