/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.reflect.JsonReflect;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.ParseConfig;
import edu.wisc.game.util.RandomRG;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public class RandomGameGenerator
extends GameGenerator {
    final int[] nPiecesRange;
    final int[] nShapesRange;
    final int[] nColorsRange;
    final Piece.Shape[] allShapes;
    final Piece.Color[] allColors;

    RandomGameGenerator(RandomRG _random, String ruleSetName, int[] _nPiecesRange, int[] _nShapesRange, int[] _nColorsRange, Piece.Shape[] _allShapes, Piece.Color[] _allColors) throws IOException, RuleParseException {
        this(_random, AllRuleSets.obtain(ruleSetName), _nPiecesRange, _nShapesRange, _nColorsRange, _allShapes, _allColors);
    }

    public RandomGameGenerator(RandomRG _random, File ruleSetFile, int[] _nPiecesRange, int[] _nShapesRange, int[] _nColorsRange, Piece.Shape[] _allShapes, Piece.Color[] _allColors) throws IOException, RuleParseException {
        this(_random, AllRuleSets.read(ruleSetFile), _nPiecesRange, _nShapesRange, _nColorsRange, _allShapes, _allColors);
    }

    RandomGameGenerator(RandomRG _random, RuleSet _rules, int[] _nPiecesRange, int[] _nShapesRange, int[] _nColorsRange, Piece.Shape[] _allShapes, Piece.Color[] _allColors) throws IOException, RuleParseException {
        super(_random, _rules);
        this.nPiecesRange = _nPiecesRange;
        this.nShapesRange = _nShapesRange;
        this.nColorsRange = _nColorsRange;
        this.allShapes = _allShapes;
        this.allColors = _allColors;
        if (this.nPiecesRange[0] > this.nPiecesRange[1] || this.nShapesRange[0] > this.nShapesRange[1] || this.nColorsRange[0] > this.nColorsRange[1]) {
            throw new IOException("GameGenerator: Invalid param range");
        }
        if (this.nPiecesRange[0] <= 0) {
            throw new IOException("GameGenerator: Number of pieces must be positive");
        }
        if (this.nPiecesRange[1] > 36) {
            throw new IOException("GameGenerator: more pieces than cells: #pieces=" + this.nPiecesRange[1]);
        }
    }

    @Override
    public Game nextGame() {
        int nPieces = this.random.getInRange(this.nPiecesRange);
        int nShapes = this.random.getInRange(this.nShapesRange);
        int nColors = this.random.getInRange(this.nColorsRange);
        Game game = new Game(this.random, this.rules, nPieces, nShapes, nColors, this.allShapes, this.allColors);
        this.next();
        return game;
    }

    private static int[] range(String x) {
        String[] v = x.split(":");
        if (v.length == 1) {
            int n = Integer.parseInt(v[0]);
            if (n < 0) {
                throw new IllegalArgumentException("Illegal value (" + x + ") for the number of properties");
            }
            return new int[]{n, n};
        }
        if (v.length == 2) {
            int[] z = new int[]{Integer.parseInt(v[0]), Integer.parseInt(v[1])};
            if (z[0] > z[1] || z[0] < 0 || z[0] == 0 && z[1] > 0) {
                throw new IllegalArgumentException("Illegal range: x");
            }
            return z;
        }
        throw new IllegalArgumentException("Cannot parse range spec: " + x);
    }

    private static int[] range(String x, Class<? extends Enum> p) {
        int nProp;
        int[] z = RandomGameGenerator.range(x);
        if (z[1] > (nProp = p.getEnumConstants().length)) {
            throw new IllegalArgumentException("Illegal value (" + z[1] + ") for the number of " + p + " properties");
        }
        return z;
    }

    public static RandomGameGenerator buildFromArgv(RandomRG _random, File f, ParseConfig ht, String[] argv, int ja) throws IOException, RuleParseException {
        String colorsString;
        Piece.Color[] colors;
        String b;
        int[] nPiecesRange;
        if ((nPiecesRange = RandomGameGenerator.range(b = argv[ja++]))[0] <= 0) {
            throw new IllegalArgumentException("Invalid number of pieces (" + b + "); The number of pieces must be positive");
        }
        int[] zeros = new int[]{0, 0};
        int[] nShapesRange = ja < argv.length ? RandomGameGenerator.range(argv[ja++]) : zeros;
        int[] nColorsRange = ja < argv.length ? RandomGameGenerator.range(argv[ja++]) : zeros;
        String shapesString = ja < argv.length ? argv[ja++] : ht.getOption("shapes", null);
        Piece.Shape[] shapes = ParaSet.parseShapes(shapesString);
        if (shapes == null) {
            shapes = Piece.Shape.legacyShapes;
        }
        if ((colors = ParaSet.parseColors(colorsString = ja < argv.length ? argv[ja++] : ht.getOption("colors", null))) == null) {
            colors = Piece.Color.legacyColors;
        }
        return new RandomGameGenerator(_random, f, nPiecesRange, nShapesRange, nColorsRange, shapes, colors);
    }

    private static void usage(String msg) {
        System.err.println("Usage:\n");
        System.err.println("  java [options]  edu.wisc.game.engine.RandomGameGenerator out-dir number-of-boards npieces [nshapes ncolors [shapes-list color-list]");
        System.err.println("Each of 'npieces', 'nshapes', and 'ncolors' is either 'n' (for a single value) or 'n1:n2' (for a range). '0' means 'any'");
        if (msg != null) {
            System.err.println(msg + "\n");
        }
        System.exit(1);
    }

    public static void main(String[] argv) throws IOException, RuleParseException, ReflectiveOperationException, IllegalInputException {
        String dirName;
        File dir;
        ParseConfig ht = new ParseConfig();
        int ja = 0;
        if (argv.length < 3) {
            RandomGameGenerator.usage(null);
        }
        if (!(dir = new File(dirName = argv[ja++])).isDirectory()) {
            RandomGameGenerator.usage("Not a directory: " + dir);
        }
        int nb = Integer.parseInt(argv[ja++]);
        System.out.println("Will generate " + nb + " boards in directory " + dir);
        RandomGameGenerator gg = RandomGameGenerator.buildFromArgv(new RandomRG(), null, ht, argv, ja);
        Object fs = "000";
        for (int m = nb / 1000; m > 0; m /= 10) {
            fs = (String)fs + "0";
        }
        DecimalFormat fmt = new DecimalFormat((String)fs);
        RandomRG random = new RandomRG();
        for (int j = 0; j < nb; ++j) {
            File f = new File(dir, fmt.format(j) + ".json");
            Game g = gg.nextGame();
            Board b = new Board(random, g.randomObjCnt, g.nShapes, g.nColors, g.allShapes, g.allColors);
            PrintWriter w = new PrintWriter(new FileWriter(f));
            w.println(JsonReflect.reflectToJSONObject(b, true));
            w.close();
        }
    }
}

