/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.util.RandomRG;
import java.io.File;
import java.io.IOException;

public class RandomImageGameGenerator
extends GameGenerator {
    final int[] nPiecesRange;
    final String[] allImages;

    RandomImageGameGenerator(RandomRG _random, String ruleSetName, int[] _nPiecesRange, String[] _allImages) throws IOException, RuleParseException {
        this(_random, AllRuleSets.obtain(ruleSetName), _nPiecesRange, _allImages);
    }

    public RandomImageGameGenerator(RandomRG _random, File ruleSetFile, int[] _nPiecesRange, String[] _allImages) throws IOException, RuleParseException {
        this(_random, AllRuleSets.read(ruleSetFile), _nPiecesRange, _allImages);
    }

    RandomImageGameGenerator(RandomRG _random, RuleSet _rules, int[] _nPiecesRange, String[] _allImages) throws IOException, RuleParseException {
        super(_random, _rules);
        this.nPiecesRange = _nPiecesRange;
        this.allImages = _allImages;
        if (this.nPiecesRange[0] > this.nPiecesRange[1]) {
            throw new IOException("GameGenerator: Invalid param range");
        }
        if (this.nPiecesRange[0] <= 0) {
            throw new IOException("GameGenerator: Number of pieces must be positive");
        }
        if (this.nPiecesRange[1] > 36) {
            throw new IOException("GameGenerator: more pieces than cells: #pieces=" + this.nPiecesRange[1]);
        }
    }

    @Override
    public Game nextGame() {
        int nPieces = this.random.getInRange(this.nPiecesRange);
        Game game = new Game(this.random, this.rules, nPieces, this.allImages);
        this.next();
        return game;
    }
}

