/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.Game;
import java.util.BitSet;
import java.util.Vector;

public class ReplayedEpisode
extends Episode {
    final ParaSet para;
    final RandomPlayer randomPlayerModel;
    private BitSet failedPicks = new BitSet();
    private Vector<BitSet> failedMoves = new Vector();

    @Override
    boolean weShowAllMovables() {
        return !this.para.isFeedbackSwitchesFree();
    }

    public ReplayedEpisode(String _episodeId, ParaSet _para, Game game, RandomPlayer _randomPlayerModel) {
        super(game, Episode.OutputMode.BRIEF, null, null, _episodeId);
        this.randomPlayerModel = _randomPlayerModel;
        this.para = _para;
        if (game.initialBoard == null) {
            throw new IllegalArgumentException("Cannot replay a game without knowing the initial board!");
        }
    }

    private BitSet movesFor(int pos) {
        BitSet b;
        if (this.failedMoves.size() <= pos) {
            this.failedMoves.setSize(pos + 1);
        }
        if ((b = this.failedMoves.get(pos)) == null) {
            b = new BitSet(NBU);
            this.failedMoves.set(pos, b);
        }
        return b;
    }

    public double computeP0(Episode.Pick nextMove, int code) {
        int knownFailedPicks = this.failedPicks.cardinality();
        int knownFailedMoves = 0;
        for (BitSet b : this.failedMoves) {
            if (b == null) continue;
            knownFailedMoves += b.cardinality();
        }
        boolean successfulPick = !(nextMove instanceof Episode.Move) && code == 0;
        System.out.println("RE.computeP0(" + nextMove + "); code=" + code + ", successfulPick=" + successfulPick);
        return successfulPick ? this.ruleLine.computeP0ForPicks(knownFailedPicks) : this.ruleLine.computeP0ForMoves(knownFailedMoves);
    }

    @Override
    public int accept(Episode.Pick pick) {
        int code = super.accept(pick);
        if (this.randomPlayerModel != RandomPlayer.COMPLETELY_RANDOM) {
            if (this.randomPlayerModel == RandomPlayer.MCP1) {
                if (code == 0) {
                    if (pick instanceof Episode.Move) {
                        this.failedPicks.clear();
                        this.failedMoves.clear();
                    }
                } else {
                    int pos = pick.getPos();
                    if (pick instanceof Episode.Move) {
                        if (!this.weShowAllMovables() || this.ruleLine.isMoveable[pos]) {
                            BitSet b = this.movesFor(pos);
                            Episode.Move move = (Episode.Move)pick;
                            b.set(move.getBucketNo());
                            if (b.cardinality() == NBU) {
                                this.failedPicks.set(pos);
                            }
                        }
                    } else {
                        this.failedPicks.set(pos);
                        BitSet b = this.movesFor(pos);
                        for (int j = 0; j < NBU; ++j) {
                            b.set(j);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Model not supported: " + this.randomPlayerModel);
            }
        }
        return code;
    }

    public static enum RandomPlayer {
        COMPLETELY_RANDOM,
        MCP1;

    }
}

