/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.sql;

import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.TestChild;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Query;

@Entity
public class Test {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    String name;
    int a;
    int b;
    @OneToMany(mappedBy="player", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Vector<TestChild> allEpisodes = new Vector();

    Test() {
    }

    Test(String _name) {
        this.name = _name;
    }

    public void addEpisode(TestChild c) {
        this.allEpisodes.add(c);
        c.setPlayer(this);
    }

    public static void main(String[] argv) {
        TestChild x;
        int j;
        int N = 10;
        Test[] q = new Test[N];
        for (j = 0; j < N; ++j) {
            String name = "user_" + j;
            q[j] = Test.findTest(name);
            if (q[j] == null) {
                q[j] = new Test(name);
                x = new TestChild("child_" + j, j, 0);
                q[j].addEpisode(x);
                Main.persistObjects(q[j], x);
            }
            q[j].a = j;
        }
        for (j = 0; j < N; ++j) {
            q[j].a += 100;
            q[j].b = 1;
            for (int k = 0; k <= j; ++k) {
                x = q[k].allEpisodes.firstElement();
                ++x.a;
                ++x.b;
            }
            if ((j - 2) % 5 != 0) continue;
            EntityManager em = Main.getEM();
            em.getTransaction().begin();
            em.getTransaction().commit();
            System.out.println("Done begin/commit, for " + q[j]);
        }
    }

    public String toString() {
        return "[" + this.name + "; a=" + this.a + "; b=" + this.b + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Test findTest(String pid) {
        Test x;
        EntityManager em;
        EntityManager entityManager = em = Main.getEM();
        synchronized (entityManager) {
            Query q = em.createQuery("select m from Test m where m.name=:c");
            q.setParameter("c", (Object)pid);
            List res = q.getResultList();
            if (res.size() == 0) {
                return null;
            }
            x = (Test)res.iterator().next();
        }
        return x;
    }
}

