/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.svg;

import edu.wisc.game.formatter.HTMLFmter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;

public class Arrows {
    static final int R = 20;
    static final int margin = 4;
    static final int H = 48;
    static final HTMLFmter fm = HTMLFmter.htmlFmter;
    static NumberFormat fmt3d = new DecimalFormat("000");

    static String mkSvgParams(String ... nameVal) {
        String s = "";
        if (nameVal.length % 2 != 0) {
            throw new IllegalArgumentException("odd number of params");
        }
        Vector<CallSite> v = new Vector<CallSite>();
        for (int j = 0; j < nameVal.length; j += 2) {
            v.add((CallSite)((Object)(nameVal[j] + "=\"" + nameVal[j + 1] + "\"")));
        }
        return String.join((CharSequence)" ", v);
    }

    static String line(Point _a, Point _b) {
        String[] a = _a.svgCoordString();
        String[] b = _b.svgCoordString();
        String para = Arrows.mkSvgParams("x1", a[0], "y1", a[1], "x2", b[0], "y2", b[1]);
        return fm.wrap("line", para, "");
    }

    private static String makeSvg(String color, double alpha) {
        String svgExtra = Arrows.mkSvgParams("xmlns", "http://www.w3.org/2000/svg", "width", "48", "height", "48", "viewBox", "48 48", "fill", "none", "stroke", "currentColor", "stroke-width", "2", "stroke-linecap", "round", "stroke-linejoin", "round", "class", "feather feather-arrow");
        Point[] a0 = new Point[]{new Point(-20.0, 0.0), new Point(20.0, 0.0), new Point(12.0, 4.0), new Point(12.0, -4.0)};
        Point[] a = Point.rotate(a0, alpha);
        Object z = Arrows.line(a[0], a[1]) + Arrows.line(a[2], a[1]) + Arrows.line(a[3], a[1]);
        z = fm.wrap("g", "color=\"" + color + "\"", (String)z);
        z = fm.wrap("svg", svgExtra, (String)z);
        return z;
    }

    public static void main(String[] argv) throws IOException {
        String color = argv[0];
        for (int deg = 0; deg < 360; deg += 15) {
            String s = Arrows.makeSvg(color, Math.PI * (double)deg / 180.0);
            String fname = "arrow-" + color + "-" + fmt3d.format(deg);
            File f = new File(fname + ".svg");
            PrintWriter w = new PrintWriter(new FileWriter(f));
            w.println(s);
            w.close();
            System.out.println(fname + "," + color + "," + deg);
        }
    }

    private static class Point {
        double x;
        double y;

        Point(double _x, double _y) {
            this.x = _x;
            this.y = _y;
        }

        Point rotate(double alpha) {
            double qx = this.x * Math.cos(alpha) - this.y * Math.sin(alpha);
            double qy = this.y * Math.cos(alpha) + this.x * Math.sin(alpha);
            return new Point(qx, qy);
        }

        int[] svgCoord() {
            int[] xy = new int[]{(int)Math.round(24.0 + this.x), (int)Math.round(24.0 - this.y)};
            return xy;
        }

        String[] svgCoordString() {
            int[] q = this.svgCoord();
            String[] xy = new String[]{"" + q[0], "" + q[1]};
            return xy;
        }

        String svgString() {
            return String.join((CharSequence)" ", this.svgCoordString());
        }

        static Point[] rotate(Point[] a, double alpha) {
            Point[] b = new Point[a.length];
            for (int j = 0; j < a.length; ++j) {
                b[j] = a[j].rotate(alpha);
            }
            return b;
        }
    }
}

