/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.tools;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.rest.TrialList;
import edu.wisc.game.saved.BoardManager;
import edu.wisc.game.saved.TranscriptManager;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.EpisodeInfo;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.sql.ReplayedEpisode;
import edu.wisc.game.tools.EpisodeHandle;
import edu.wisc.game.tools.LoglikP0Problem;
import edu.wisc.game.tools.LoglikProblem;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.ImportCSV;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleValueChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;
import org.apache.commons.math3.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer;

public class AnalyzeTranscripts {
    private static boolean needP0 = false;
    private static ReplayedEpisode.RandomPlayer randomPlayerModel = ReplayedEpisode.RandomPlayer.COMPLETELY_RANDOM;
    private static boolean weWantFitting = true;
    static TreeMap<String, Vector<EpisodeHandle>> allHandles = new TreeMap();
    private final File base;
    private final PrintWriter wsum;
    final String playerId;
    HashMap<String, Board> boards;
    static final DecimalFormat df = new DecimalFormat("0.000");

    private static void usage() {
        AnalyzeTranscripts.usage(null);
    }

    private static void usage(String msg) {
        System.err.println("For usage info, please see:\n");
        System.err.println("http://sapir.psych.wisc.edu:7150/w2020/analyze-transcripts.html");
        if (msg != null) {
            System.err.println(msg + "\n");
        }
        System.exit(1);
    }

    private static EpisodeHandle findEpisodeHandle(Vector<EpisodeHandle> v, String eid) {
        for (EpisodeHandle eh : v) {
            if (!eh.episodeId.equals(eid)) continue;
            return eh;
        }
        return null;
    }

    public static void main(String[] argv) throws Exception {
        String outDir = "tmp";
        if (argv.length == 0) {
            int[] y = new int[]{1, 1, 0, 0, 0, 0, 1, 1};
            AnalyzeTranscripts.test(y);
            return;
        }
        if (argv.length == 2 && argv[0].equals("-y")) {
            String[] ys = argv[1].split("\\s+");
            int[] y = new int[ys.length];
            for (int j = 0; j < y.length; ++j) {
                y[j] = Integer.parseInt(ys[j]);
            }
            AnalyzeTranscripts.test(y);
            return;
        }
        EntityManager em = Main.getNewEM();
        ArgType argType = ArgType.PLAN;
        boolean fromFile = false;
        Vector<String> plans = new Vector<String>();
        Vector<String> pids = new Vector<String>();
        Vector<String> nicknames = new Vector<String>();
        Vector<Long> uids = new Vector<Long>();
        for (int j = 0; j < argv.length; ++j) {
            String[] v;
            String[] stringArray;
            String a = argv[j];
            if (a.startsWith("-p0")) {
                String mode = a.substring(3);
                if (mode.equals("")) {
                    if (++j >= argv.length) {
                        AnalyzeTranscripts.usage("The -p0 option must be followed by a model name");
                    }
                    mode = argv[j];
                }
                needP0 = true;
                if (mode.equals("random")) {
                    randomPlayerModel = ReplayedEpisode.RandomPlayer.COMPLETELY_RANDOM;
                    continue;
                }
                if (mode.equals("mcp1")) {
                    randomPlayerModel = ReplayedEpisode.RandomPlayer.MCP1;
                    continue;
                }
                AnalyzeTranscripts.usage("Invalid model name: " + mode);
                continue;
            }
            if (a.equals("-nofit")) {
                weWantFitting = false;
                continue;
            }
            if (j + 1 < argv.length && a.equals("-out")) {
                outDir = argv[++j];
                continue;
            }
            if (j + 1 < argv.length && a.equals("-in")) {
                String inputDir;
                if (!new File(inputDir = argv[++j]).isDirectory()) {
                    AnalyzeTranscripts.usage("Not a directory: " + inputDir);
                }
                Files.setSavedDir(inputDir);
                continue;
            }
            if (a.equals("-nickname")) {
                argType = ArgType.UNICK;
                continue;
            }
            if (a.equals("-plan")) {
                argType = ArgType.PLAN;
                continue;
            }
            if (a.equals("-uid")) {
                argType = ArgType.UID;
                continue;
            }
            if (a.equals("-pid")) {
                argType = ArgType.PID;
                continue;
            }
            if (a.equals("-file")) {
                fromFile = true;
                continue;
            }
            if (fromFile) {
                stringArray = AnalyzeTranscripts.readList(new File(a));
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = a;
            }
            for (String b : v = stringArray) {
                if (argType == ArgType.PLAN) {
                    plans.add(b);
                    continue;
                }
                if (argType == ArgType.UNICK) {
                    nicknames.add(b);
                    continue;
                }
                if (argType == ArgType.UID) {
                    uids.add(new Long(b));
                    continue;
                }
                if (argType != ArgType.PID) continue;
                pids.add(b);
            }
        }
        plans = AnalyzeTranscripts.expandPlans(em, plans);
        PlayerList plist = new PlayerList(em, pids, nicknames, uids);
        EpisodesByPlayer ph = new EpisodesByPlayer();
        for (String string : plans) {
            System.out.println("Experiment plan=" + string);
            TrialListMap trialListMap = new TrialListMap(string);
            System.out.println("Experiment plan=" + string + " has " + trialListMap.size() + " trial lists: " + Util.joinNonBlank(", ", trialListMap.keySet()));
            Vector<EpisodeHandle> handles = new Vector<EpisodeHandle>();
            Query q = em.createQuery("select m from PlayerInfo m where m.experimentPlan=:e");
            q.setParameter("e", (Object)string);
            List res = q.getResultList();
            for (PlayerInfo p : res) {
                ph.doOnePlayer(p, trialListMap, handles);
            }
            System.out.println("For experiment plan=" + string + ", found " + handles.size() + " good episodes");
        }
        HashMap<String, TrialListMap> trialListMaps = new HashMap<String, TrialListMap>();
        for (PlayerInfo p : plist) {
            try {
                String exp = p.getExperimentPlan();
                TrialListMap trialListMap = (TrialListMap)trialListMaps.get(exp);
                if (trialListMap == null) {
                    trialListMap = new TrialListMap(p.getExperimentPlan());
                    trialListMaps.put(exp, trialListMap);
                }
                Vector<EpisodeHandle> handles = new Vector<EpisodeHandle>();
                ph.doOnePlayer(p, trialListMap, handles);
                System.out.println("For player=" + p.getPlayerId() + ", found " + handles.size() + " good episodes");
            }
            catch (Exception ex) {
                System.err.println("ERROR: Skipping player=" + p.getPlayerId() + " due to missing data. The problem is as follows:");
                System.err.println(ex);
                ex.printStackTrace(System.err);
            }
        }
        File file = new File(outDir);
        if (!file.exists() && !file.mkdirs()) {
            AnalyzeTranscripts.usage("Cannot create output directory: " + file);
        }
        if (!file.isDirectory() || !file.canWrite()) {
            AnalyzeTranscripts.usage("Not a writeable directory: " + file);
        }
        PrintWriter wsum = null;
        if (weWantFitting) {
            File gsum = new File(file, (String)(needP0 ? "summary-p0-" + randomPlayerModel + ".csv" : "summary-flat.csv"));
            wsum = new PrintWriter(new FileWriter(gsum, false));
            String sumHeader = "#ruleSetName,playerId,experimentPlan,trialListId,seriesNo,yy,B,C,t_I,k,Z,n,L/n,AIC/n";
            wsum.println(sumHeader);
        }
        for (String ruleSetName : allHandles.keySet()) {
            System.out.println("For rule set=" + ruleSetName + ", found " + allHandles.get(ruleSetName).size() + " good episodes");
            File d = new File(file, ruleSetName);
            if (d.exists()) {
                if (d.isDirectory() && file.canWrite()) continue;
                throw new IOException("Not a writeable directory: " + d);
            }
            if (d.mkdirs()) continue;
            throw new IOException("Cannot create directory: " + d);
        }
        for (String playerId : ph.keySet()) {
            Vector v = (Vector)ph.get(playerId);
            try {
                AnalyzeTranscripts atr = new AnalyzeTranscripts(playerId, file, wsum);
                atr.analyzePlayerRecord(v);
            }
            catch (Exception ex) {
                System.err.println("ERROR: Cannot process data for player=" + playerId + " due to missing data. The problem is as follows:");
                System.err.println(ex);
                ex.printStackTrace(System.err);
            }
        }
        if (wsum != null) {
            wsum.close();
        }
    }

    private static String[] readList(File f) throws IOException, IllegalInputException {
        Vector<String> v = new Vector<String>();
        CsvData csv = new CsvData(f, true, false, null);
        for (CsvData.LineEntry _e : csv.entries) {
            CsvData.BasicLineEntry e = (CsvData.BasicLineEntry)_e;
            v.add(e.getKey());
        }
        return v.toArray(new String[0]);
    }

    private static Vector<String> expandPlans(EntityManager em, Vector<String> v0) throws Exception {
        Vector<String> v = new Vector<String>();
        Query q = em.createQuery("select distinct e.player.experimentPlan from  EpisodeInfo e where e.player.experimentPlan like :p and e.attemptCnt>0");
        for (String p : v0) {
            if (p.indexOf(37) >= 0) {
                q.setParameter("p", (Object)p);
                v.addAll(q.getResultList());
                continue;
            }
            v.add(p);
        }
        return v;
    }

    private AnalyzeTranscripts(String _playerId, File _base, PrintWriter _wsum) {
        this.base = _base;
        this.wsum = _wsum;
        this.playerId = _playerId;
    }

    private void saveAnyData(Vector<TranscriptManager.ReadTranscriptData.Entry[]> section, Vector<EpisodeHandle> includedEpisodes) throws IOException, IllegalInputException, RuleParseException {
        if (includedEpisodes.size() == 0) {
            return;
        }
        EpisodeHandle eh0 = includedEpisodes.firstElement();
        double[] p0 = null;
        Object outHeader = "#ruleSetName,playerId,experimentPlan,trialListId,seriesNo,orderInSeries,episodeId,moveNo,timestamp,y,x,by,bx,code";
        if (needP0) {
            outHeader = (String)outHeader + ",p0";
            p0 = this.computeP0(section, eh0.para, eh0.ruleSetName);
        }
        String rid = eh0.ruleSetName;
        File d = new File(this.base, rid);
        File g = new File(d, includedEpisodes.firstElement().playerId + ".split-transcripts.csv");
        PrintWriter w = new PrintWriter(new FileWriter(g, false));
        w.println((String)outHeader);
        int je = 0;
        int jp = 0;
        for (TranscriptManager.ReadTranscriptData.Entry[] subsection : section) {
            EpisodeHandle eh = includedEpisodes.get(je++);
            for (TranscriptManager.ReadTranscriptData.Entry e : subsection) {
                if (!eh.episodeId.equals(e.eid)) {
                    throw new IllegalArgumentException("Array mismatch");
                }
                w.print(rid + "," + e.pid + "," + eh.exp + "," + eh.trialListId + "," + eh.seriesNo + "," + eh.orderInSeries + "," + e.eid);
                for (int j = 2; j < e.csv.nCol(); ++j) {
                    w.print("," + ImportCSV.escape(e.csv.getCol(j)));
                }
                if (needP0) {
                    w.print("," + p0[jp++]);
                }
                w.println();
            }
        }
        w.close();
        w = null;
        if (weWantFitting) {
            OptimumExplained optimumExplained = AnalyzeTranscripts.analyzeSection(AnalyzeTranscripts.joinSubsections(section), eh0, this.wsum, (double[])(needP0 ? p0 : null));
        }
        section.clear();
        includedEpisodes.clear();
    }

    private static Vector<TranscriptManager.ReadTranscriptData.Entry[]> splitTranscriptIntoEpisodes(Vector<TranscriptManager.ReadTranscriptData.Entry> section) {
        Vector<TranscriptManager.ReadTranscriptData.Entry[]> result = new Vector<TranscriptManager.ReadTranscriptData.Entry[]>();
        Vector<TranscriptManager.ReadTranscriptData.Entry> q = new Vector<TranscriptManager.ReadTranscriptData.Entry>();
        String lastEid = "";
        for (TranscriptManager.ReadTranscriptData.Entry e : section) {
            String eid = e.eid;
            if (!eid.equals(lastEid)) {
                if (q.size() > 0) {
                    result.add(q.toArray(new TranscriptManager.ReadTranscriptData.Entry[0]));
                }
                q.clear();
                lastEid = eid;
            }
            q.add(e);
        }
        if (q.size() > 0) {
            result.add(q.toArray(new TranscriptManager.ReadTranscriptData.Entry[0]));
        }
        return result;
    }

    private static <T> Vector<T> joinSubsections(Vector<T[]> w) {
        Vector<T> v = new Vector<T>();
        for (T[] a : w) {
            for (T t : a) {
                v.add(t);
            }
        }
        return v;
    }

    private static <T> int sumLen(Vector<T[]> w) {
        int len = 0;
        for (T[] a : w) {
            len += a.length;
        }
        return len;
    }

    void removeDuplicates(Vector<TranscriptManager.ReadTranscriptData.Entry[]> subsections) {
        for (int j = 0; j < subsections.size(); ++j) {
            TranscriptManager.ReadTranscriptData.Entry[] in = subsections.get(j);
            Vector<TranscriptManager.ReadTranscriptData.Entry> out = new Vector<TranscriptManager.ReadTranscriptData.Entry>();
            for (int k = 0; k < in.length; ++k) {
                boolean isDup = false;
                for (TranscriptManager.ReadTranscriptData.Entry q : out) {
                    if (!q.equals(in[k])) continue;
                    isDup = true;
                    break;
                }
                if (isDup) continue;
                out.add(in[k]);
            }
            if (out.size() >= in.length) continue;
            subsections.set(j, out.toArray(new TranscriptManager.ReadTranscriptData.Entry[0]));
        }
    }

    private double[] computeP0(Vector<TranscriptManager.ReadTranscriptData.Entry[]> subsections, ParaSet para, String ruleSetName) throws IOException, IllegalInputException, RuleParseException {
        RuleSet rules = AllRuleSets.obtain(ruleSetName);
        double[] p0 = new double[AnalyzeTranscripts.sumLen(subsections)];
        int k = 0;
        for (TranscriptManager.ReadTranscriptData.Entry[] subsection : subsections) {
            TranscriptManager.ReadTranscriptData.Entry e;
            int j;
            String episodeId = subsection[0].eid;
            Board board = this.boards.get(episodeId);
            Game game = new Game(rules, board);
            ReplayedEpisode rep = new ReplayedEpisode(episodeId, para, game, randomPlayerModel);
            System.out.println("------------- eid=" + episodeId);
            System.out.println("All moves:");
            for (j = 0; j < subsection.length; ++j) {
                e = subsection[j];
                System.out.println(e.pick.toString());
            }
            for (j = 0; j < subsection.length; ++j) {
                e = subsection[j];
                System.out.println("j=" + j);
                System.out.println(rep.graphicDisplay());
                double p = rep.computeP0(e.pick, e.code);
                p0[k++] = p;
                int code = rep.accept(e.pick);
                System.out.println(e.pick.toString() + ", p0=" + p + ", code=" + code);
                if (code == e.code) continue;
                throw new IllegalArgumentException("Unexpected code in replay: " + code + ", vs. the recorded code=" + e.code);
            }
        }
        return p0;
    }

    private void analyzePlayerRecord(Vector<EpisodeHandle> v) throws IOException, IllegalInputException, RuleParseException {
        HashMap<String, Boolean> useImages = new HashMap<String, Boolean>();
        for (EpisodeHandle eh : v) {
            useImages.put(eh.episodeId, eh.useImages);
        }
        File boardsFile = Files.boardsFile(this.playerId, true);
        this.boards = BoardManager.readBoardFile(boardsFile, useImages);
        File inFile = Files.transcriptsFile(this.playerId, true);
        TranscriptManager.ReadTranscriptData transcript = new TranscriptManager.ReadTranscriptData(inFile);
        Vector<TranscriptManager.ReadTranscriptData.Entry[]> subsections = AnalyzeTranscripts.splitTranscriptIntoEpisodes(transcript);
        this.removeDuplicates(subsections);
        System.out.println("Player " + this.playerId + ": split the transcript (" + transcript.size() + " moves) into " + subsections.size() + " episode sections");
        String lastRid = "";
        Vector<TranscriptManager.ReadTranscriptData.Entry[]> section = new Vector<TranscriptManager.ReadTranscriptData.Entry[]>();
        Vector<EpisodeHandle> includedEpisodes = new Vector<EpisodeHandle>();
        for (TranscriptManager.ReadTranscriptData.Entry[] subsection : subsections) {
            String eid = subsection[0].eid;
            EpisodeHandle eh = AnalyzeTranscripts.findEpisodeHandle(v, eid);
            if (eh == null) {
                String msg = "In file " + inFile + ", found unexpected experimentId=" + eid;
                System.err.println(msg);
                continue;
            }
            String rid = eh.ruleSetName;
            if (!lastRid.equals(rid)) {
                this.saveAnyData(section, includedEpisodes);
                lastRid = rid;
            }
            includedEpisodes.add(eh);
            section.add(subsection);
        }
        this.saveAnyData(section, includedEpisodes);
    }

    static void test(int[] y) {
        double[] tt = new double[y.length * 2];
        for (int k = 0; k < tt.length; ++k) {
            tt[k] = (double)k * 0.5;
        }
        AnalyzeTranscripts.analyzeSection("test", y, null, tt);
    }

    private static OptimumExplained analyzeSection(Vector<TranscriptManager.ReadTranscriptData.Entry> section, EpisodeHandle eh, PrintWriter wsum, double[] p0) {
        int[] y = TranscriptManager.ReadTranscriptData.asVectorY(section);
        if (y.length < 2) {
            return null;
        }
        OptimumExplained oe = AnalyzeTranscripts.analyzeSection(eh.playerId, y, p0, null);
        if (oe != null) {
            String rid = eh.ruleSetName;
            wsum.print(rid + "," + eh.playerId + "," + eh.exp + "," + eh.trialListId + "," + eh.seriesNo + ",");
            wsum.println(AnalyzeTranscripts.mkYString(y) + "," + oe.toCsvString());
        }
        return oe;
    }

    private static String mkYString(int[] y) {
        Vector<CallSite> v = new Vector<CallSite>();
        for (int q : y) {
            v.add((CallSite)((Object)("" + q)));
        }
        return Util.joinNonBlank(" ", v);
    }

    private static double mkAvg(int[] y) {
        int sum = 0;
        for (int q : y) {
            sum += q;
        }
        return (double)sum / (double)y.length;
    }

    private static OptimumExplained analyzeSection(String playerId, int[] y, double[] p0, double[] tt) {
        LoglikProblem.verbose = false;
        System.out.println("Player=" + playerId + ", optimizing for y=[" + AnalyzeTranscripts.mkYString(y) + "]");
        int n = y.length;
        if (p0 != null) {
            if (y.length != p0.length) {
                throw new IllegalArgumentException("y, p0 length mismatch");
            }
            Vector<Integer> yz = new Vector<Integer>();
            Vector<Double> p0z = new Vector<Double>();
            for (int j = 0; j < y.length; ++j) {
                if (p0[j] < 0.0 || p0[j] > 1.0) {
                    throw new IllegalArgumentException("Invalid p0");
                }
                if (p0[j] == 1.0 && y[j] == 0) continue;
                yz.add(y[j]);
                p0z.add(p0[j]);
            }
            int n0 = n;
            n = yz.size();
            if (n < n0) {
                y = new int[n];
                p0 = new double[n];
                for (int j = 0; j < n; ++j) {
                    y[j] = (Integer)yz.get(j);
                    p0[j] = (Double)p0z.get(j);
                }
                System.out.println("Reduced n from " + n0 + " to " + n + ", due to the removal of 'impossible' points with p0==1");
            }
        }
        if (n == 0) {
            return null;
        }
        if (tt == null) {
            tt = new double[n * 2 - 1];
            for (int k = 0; k < tt.length; ++k) {
                tt[k] = (double)k * 0.5;
            }
        }
        double avgY = AnalyzeTranscripts.mkAvg(y);
        LoglikProblem problem = p0 == null ? new LoglikProblem(y) : new LoglikP0Problem(y, p0);
        ObjectiveFunctionGradient ofg = problem.getObjectiveFunctionGradient();
        int maxEval = 10000;
        PointValuePair bestOptimum = null;
        for (int mode = 0; mode < tt.length; ++mode) {
            double t0 = tt[mode];
            Divider d = Divider.goodDivider(y, t0);
            if (d != null) {
                System.out.println("***L(" + df.format(d.avg0) + "," + df.format(d.avg1) + ")/n=" + df.format(d.L / (double)n) + "*** ");
            }
            int nAttempts = d == null ? 2 : 3;
            for (int jAttempt = 0; jAttempt < nAttempts; ++jAttempt) {
                PointValuePair optimum;
                double[] dArray;
                if (jAttempt == 0) {
                    double[] dArray2 = new double[4];
                    dArray2[0] = avgY;
                    dArray2[1] = avgY;
                    dArray2[2] = t0;
                    dArray = dArray2;
                    dArray2[3] = 0.0;
                } else if (jAttempt == 1) {
                    double[] dArray3 = new double[4];
                    dArray3[0] = 0.0;
                    dArray3[1] = 1.0;
                    dArray3[2] = t0;
                    dArray = dArray3;
                    dArray3[3] = 0.0;
                } else {
                    double[] dArray4 = new double[4];
                    dArray4[0] = d.avg0;
                    dArray4[1] = d.avg1;
                    dArray4[2] = t0;
                    dArray = dArray4;
                    dArray4[3] = 1.0;
                }
                double[] startPoint = dArray;
                NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-7, 1.0E-7), 1.0E-5, 1.0E-5, 1.0);
                try {
                    optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(10000), problem.getObjectiveFunction(), ofg, GoalType.MAXIMIZE, new InitialGuess(startPoint)});
                }
                catch (TooManyEvaluationsException ex) {
                    System.out.println((Object)ex);
                    continue;
                }
                OptimumExplained oe = new OptimumExplained(ofg, optimum, n);
                oe.report("[t0=" + t0 + ", iter=" + optimizer.getIterations() + "] ");
                if (bestOptimum != null && !((Double)optimum.getValue() > (Double)bestOptimum.getValue())) continue;
                bestOptimum = optimum;
            }
        }
        if (bestOptimum != null) {
            OptimumExplained oe = new OptimumExplained(ofg, bestOptimum, n);
            oe.report("[GLOBAL?] ");
            return oe;
        }
        return null;
    }

    static class OptimumExplained {
        final PointValuePair optimum;
        final double[] p;
        final double[] grad;
        final double B;
        final double C;
        final double t_I;
        final double k;
        final double e0;
        final double re0;
        final double Z;
        final double Ln;
        final double AICn;
        final int n;

        OptimumExplained(ObjectiveFunctionGradient ofg, PointValuePair _optimum, int _n) {
            this.n = _n;
            this.optimum = _optimum;
            this.p = this.optimum.getPoint();
            this.grad = ofg.getObjectiveFunctionGradient().value(this.p);
            this.t_I = this.p[2];
            double k0 = this.p[3];
            if (k0 < 0.0) {
                this.k = -k0;
                this.B = this.p[1];
                this.C = this.p[0];
            } else {
                this.k = k0;
                this.B = this.p[0];
                this.C = this.p[1];
            }
            this.e0 = Math.exp(this.k * this.t_I);
            this.re0 = Math.exp(-this.k * this.t_I);
            this.Z = this.B / (1.0 + this.re0) + this.C / (1.0 + this.e0);
            this.Ln = (Double)this.optimum.getValue() / (double)this.n;
            int K = 4;
            this.AICn = this.n <= 5 ? 0.0 : -2.0 * this.Ln + 8.0 / (double)(this.n - 4 - 1);
        }

        String toReadableString() {
            return "B=" + df.format(this.B) + ", C=" + df.format(this.C) + ", t_I=" + df.format(this.t_I) + ", k=" + df.format(this.k) + ". Z=" + df.format(this.Z) + ". n=" + df.format(this.n) + ". L/n=" + df.format(this.Ln) + ". AIC/n=" + df.format(this.AICn);
        }

        String toCsvString() {
            Vector<Number> v = new Vector<Number>();
            v.add(this.B);
            v.add(this.C);
            v.add(this.t_I);
            v.add(this.k);
            v.add(this.Z);
            v.add(this.n);
            v.add(this.Ln);
            v.add(this.AICn);
            return Util.joinNonBlank(",", v);
        }

        void report(String prefix) {
            if (prefix != null) {
                System.out.print(prefix);
            }
            System.out.println(this.toReadableString());
            System.out.println("grad L=[" + Util.joinNonBlank(", ", df, this.grad) + "]");
        }
    }

    static class Divider {
        final double avg0;
        final double avg1;
        final double L;

        private static double partL(int n, int sum) {
            double avg = (double)sum / (double)n;
            return (sum > 0 ? (double)sum * Math.log(avg) : 0.0) + (n - sum > 0 ? (double)(n - sum) * Math.log(1.0 - avg) : 0.0);
        }

        Divider(int n0, int n1, int sum0, int sum1) {
            this.avg0 = (double)sum0 / (double)n0;
            this.avg1 = (double)sum1 / (double)n1;
            this.L = Divider.partL(n0, sum0) + Divider.partL(n1, sum1);
        }

        static Divider goodDivider(int[] y, double t0) {
            if ((double)((int)t0) == t0) {
                return null;
            }
            if (t0 <= 0.0 || t0 >= (double)(y.length - 1)) {
                return null;
            }
            int n0 = (int)t0 + 1;
            int n1 = y.length - n0;
            int sum0 = 0;
            int sum1 = 0;
            for (int t = 0; t < y.length; ++t) {
                if (y[t] <= 0) continue;
                if ((double)t < t0) {
                    ++sum0;
                    continue;
                }
                ++sum1;
            }
            Divider d = new Divider(n0, n1, sum0, sum1);
            if (d.avg0 < d.avg1 && y[n0 - 1] < y[n0] || d.avg0 > d.avg1 && y[n0 - 1] > y[n0]) {
                return d;
            }
            return null;
        }
    }

    private static class PlayerList
    extends Vector<PlayerInfo> {
        private HashSet<Long> h = new HashSet();

        @Override
        public boolean addAll(Collection<? extends PlayerInfo> c) {
            int cnt = 0;
            for (PlayerInfo playerInfo : c) {
                if (this.h.contains(playerInfo.getId())) continue;
                this.h.add(playerInfo.getId());
                this.add(playerInfo);
                ++cnt;
            }
            return cnt > 0;
        }

        PlayerList(EntityManager em, Vector<String> pids, Vector<String> nicknames, Vector<Long> uids) {
            Query q;
            for (String pid : pids) {
                q = pid.indexOf(37) >= 0 ? em.createQuery("select p from PlayerInfo p where p.playerId like :p") : em.createQuery("select p from PlayerInfo p where p.playerId=:p");
                q.setParameter("p", (Object)pid);
                this.addAll(q.getResultList());
            }
            for (Long uid : uids) {
                q = em.createQuery("select p from PlayerInfo p where p.user.id=:u");
                q.setParameter("p", (Object)uid);
                this.addAll(q.getResultList());
            }
            for (String nickname : nicknames) {
                q = nickname.indexOf(37) >= 0 ? em.createQuery("select p from PlayerInfo p where p.user.nickname like :n") : em.createQuery("select p from PlayerInfo p where p.user.nickname=:n");
                q.setParameter("n", (Object)nickname);
                this.addAll(q.getResultList());
            }
        }
    }

    static class TrialListMap
    extends HashMap<String, TrialList> {
        TrialListMap(String exp) throws IOException, IllegalInputException {
            Vector<String> trialListNames = TrialList.listTrialLists(exp);
            for (String trialListId : trialListNames) {
                TrialList t = new TrialList(exp, trialListId);
                this.put(trialListId, t);
            }
        }
    }

    private static class EpisodesByPlayer
    extends TreeMap<String, Vector<EpisodeHandle>> {
        private EpisodesByPlayer() {
        }

        void doOnePlayer(PlayerInfo p, TrialListMap trialListMap, Vector<EpisodeHandle> handles) {
            String trialListId = p.getTrialListId();
            TrialList t = (TrialList)trialListMap.get(trialListId);
            if (t == null) {
                System.out.println("ERROR: for player " + p.getPlayerId() + ", no trial list is available for id=" + trialListId + " any more");
                return;
            }
            int orderInSeries = 0;
            int lastSeriesNo = 0;
            for (EpisodeInfo e : p.getAllEpisodes()) {
                int seriesNo = e.getSeriesNo();
                if (seriesNo != lastSeriesNo) {
                    orderInSeries = 0;
                }
                EpisodeHandle eh = new EpisodeHandle(p.getExperimentPlan(), trialListId, t, p.getPlayerId(), e, orderInSeries);
                handles.add(eh);
                Vector<EpisodeHandle> v = allHandles.get(eh.ruleSetName);
                if (v == null) {
                    v = new Vector();
                    allHandles.put(eh.ruleSetName, v);
                }
                v.add(eh);
                Vector<EpisodeHandle> w = (Vector<EpisodeHandle>)this.get(eh.playerId);
                if (w == null) {
                    w = new Vector<EpisodeHandle>();
                    this.put(eh.playerId, w);
                }
                w.add(eh);
                ++orderInSeries;
                lastSeriesNo = seriesNo;
            }
        }
    }

    static enum ArgType {
        PLAN,
        PID,
        UID,
        UNICK;

    }
}

