/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.tools;

import edu.wisc.game.util.Util;
import java.text.DecimalFormat;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;

class LoglikProblem {
    static boolean verbose = false;
    final int[] y;
    static final double eps = 1.0E-6;
    static final double M = 1000.0;
    static final DecimalFormat df = new DecimalFormat("0.000");

    LoglikProblem(int[] _y) {
        this.y = _y;
    }

    int size() {
        return this.y.length;
    }

    static double regLog(double x) {
        double s;
        double d = s = x > 1.0E-6 ? Math.log(x) : Math.log(1.0E-6) + (x - 1.0E-6) / 1.0E-6;
        if (x > 1.0) {
            s += -1000.0 * (1.0 - x) * (1.0 - x);
        }
        return s;
    }

    static double regLogDerivative(double x) {
        double s;
        double d = s = x > 1.0E-6 ? 1.0 / x : 1000000.0;
        if (x > 1.0) {
            s += 2000.0 * (1.0 - x);
        }
        return s;
    }

    public ObjectiveFunction getObjectiveFunction() {
        return new ObjectiveFunction(new MultivariateFunction(){

            public double value(double[] point) {
                double B = point[0];
                double C = point[1];
                double tI = point[2];
                double k = point[3];
                double sum = 0.0;
                for (int t = 0; t < LoglikProblem.this.y.length; ++t) {
                    double u = ((double)t - tI) * k;
                    double ex = Math.exp(-u);
                    double rex = Math.exp(u);
                    double p = B / (1.0 + rex) + C / (1.0 + ex);
                    sum += LoglikProblem.regLog(LoglikProblem.this.y[t] == 1 ? p : 1.0 - p);
                }
                if (verbose) {
                    System.out.println("f(" + Util.joinNonBlank(",", df, point) + ") = " + df.format(sum));
                }
                return sum;
            }
        });
    }

    public ObjectiveFunctionGradient getObjectiveFunctionGradient() {
        return new ObjectiveFunctionGradient(new MultivariateVectorFunction(){

            public double[] value(double[] point) {
                double B = point[0];
                double C = point[1];
                double tI = point[2];
                double k = point[3];
                double[] sum = new double[point.length];
                for (int t = 0; t < LoglikProblem.this.y.length; ++t) {
                    double u = ((double)t - tI) * k;
                    double ex = Math.exp(-u);
                    double rex = Math.exp(u);
                    double p = B / (1.0 + rex) + C / (1.0 + ex);
                    double r = LoglikProblem.this.y[t] == 1 ? LoglikProblem.regLogDerivative(p) : -LoglikProblem.regLogDerivative(1.0 - p);
                    sum[0] = sum[0] + r / (1.0 + rex);
                    sum[1] = sum[1] + r / (1.0 + ex);
                    double z = r * (C - B) / (2.0 + ex + rex);
                    sum[2] = sum[2] + -k * z;
                    sum[3] = sum[3] + ((double)t - tI) * z;
                }
                if (verbose) {
                    System.out.println("gradF(" + Util.joinNonBlank(",", df, point) + ") = " + Util.joinNonBlank(",", df, sum));
                }
                return sum;
            }
        });
    }
}

