/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.tools;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;

class SimpleProblem {
    final int[] y;
    static final double eps = 1.0E-6;

    SimpleProblem(int[] _y) {
        this.y = _y;
    }

    static double regLog(double x) {
        double s;
        double d = s = x > 1.0E-6 ? Math.log(x) : Math.log(1.0E-6) + (x - 1.0E-6) / 1.0E-6;
        if (x > 1.0) {
            s += x * (1.0 - x);
        }
        return s;
    }

    static double regLogDerivative(double x) {
        double s;
        double d = s = x > 1.0E-6 ? 1.0 / x : 1000000.0;
        if (x > 1.0) {
            s += 1.0 - 2.0 * x;
        }
        return s;
    }

    public ObjectiveFunction getObjectiveFunction() {
        return new ObjectiveFunction(new MultivariateFunction(){

            public double value(double[] point) {
                double B = point[0];
                double sum = 0.0;
                for (int t = 0; t < SimpleProblem.this.y.length; ++t) {
                    double p = B;
                    double w = SimpleProblem.this.y[t] == 1 ? SimpleProblem.regLog(p) : SimpleProblem.regLog(1.0 - p);
                    sum += w;
                }
                return sum;
            }
        });
    }

    public ObjectiveFunctionGradient getObjectiveFunctionGradient() {
        return new ObjectiveFunctionGradient(new MultivariateVectorFunction(){

            public double[] value(double[] point) {
                double B = point[0];
                double[] sum = new double[point.length];
                for (int t = 0; t < SimpleProblem.this.y.length; ++t) {
                    double p = B;
                    double r = SimpleProblem.this.y[t] == 1 ? SimpleProblem.regLogDerivative(p) : -SimpleProblem.regLogDerivative(1.0 - p);
                    sum[0] = sum[0] + r;
                }
                return sum;
            }
        });
    }
}

