/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.util;

import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.ImportCSV;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Vector;

public class CsvData {
    public String header = null;
    private int colCnt = 0;
    public LineEntry[] entries;

    public String mkNewHeader(String extras) throws IllegalInputException {
        if (this.header == null) {
            throw new IllegalInputException("No header found in CSV file");
        }
        return this.header + extras;
    }

    protected LineEntry mkEntry(String[] csv, int colCnt) throws IllegalInputException {
        return new BasicLineEntry(csv);
    }

    public CsvData(File csvFile) throws IOException, IllegalInputException {
        this(csvFile, true, false, null);
    }

    private static boolean lengthMatch(int colCnt, int[] legalLengths) {
        if (legalLengths == null) {
            return true;
        }
        for (int le : legalLengths) {
            if (colCnt != le) continue;
            return true;
        }
        return false;
    }

    public HashMap<String, LineEntry> toMap() {
        HashMap<String, LineEntry> h = new HashMap<String, LineEntry>();
        for (LineEntry e : this.entries) {
            String key = e.getKey();
            if (key == null) continue;
            h.put(key, e);
        }
        return h;
    }

    public CsvData(File csvFile, boolean neverHeader, boolean keepComments, int[] legalLengths) throws IOException, IllegalInputException {
        if (!csvFile.canRead()) {
            throw new IllegalInputException("File '" + csvFile + "' does not exist or is not readable");
        }
        LineNumberReader reader = new LineNumberReader(new FileReader(csvFile));
        boolean n = false;
        int errorCnt = 0;
        int warnCnt = 0;
        Vector<LineEntry> v = new Vector<LineEntry>();
        String s = null;
        boolean isFirst = true;
        while ((s = reader.readLine()) != null) {
            String[] csv;
            if ((s = s.trim()).equals("")) continue;
            if (s.startsWith("#")) {
                if (!keepComments) continue;
                v.add(new CommentEntry(s.substring(1)));
                continue;
            }
            if (isFirst) {
                if (s.length() == 0) {
                    throw new IllegalInputException("Empty first line in " + csvFile);
                }
                isFirst = false;
                csv = ImportCSV.splitCSV(s);
                this.colCnt = csv.length;
                if (!CsvData.lengthMatch(this.colCnt, legalLengths)) {
                    throw new IllegalInputException("Unexpected header line or first line in " + csvFile + ". Found " + this.colCnt);
                }
            }
            try {
                csv = ImportCSV.splitCSV(s);
                int nc = legalLengths == null ? -1 : this.colCnt;
                v.add(this.mkEntry(csv, nc));
            }
            catch (IllegalInputException ex) {
                ++errorCnt;
                System.err.println("File '" + csvFile + "', line " + reader.getLineNumber() + ": " + ex.getMessage());
            }
        }
        if (warnCnt > 0 || errorCnt > 0) {
            System.err.println(errorCnt + " errors, " + warnCnt + " warnings reported for input file " + csvFile);
        }
        if (errorCnt > 0) {
            throw new IllegalInputException(errorCnt + " errors found in input file " + csvFile);
        }
        this.entries = v.toArray(new LineEntry[0]);
    }

    public static class CommentEntry
    implements LineEntry {
        public final String text;

        CommentEntry(String _text) {
            this.text = _text;
        }

        @Override
        public String getKey() {
            return null;
        }
    }

    public static class BasicLineEntry
    implements LineEntry {
        String[] csv;

        BasicLineEntry(String[] _csv) {
            this.csv = _csv;
        }

        public int nCol() {
            return this.csv.length;
        }

        @Override
        public String getKey() {
            return this.csv[0];
        }

        public String getCol(int j) {
            return j < this.csv.length ? this.csv[j] : null;
        }

        public Integer getColInt(int j) {
            return j < this.csv.length && this.csv[j] != null && this.csv[j].length() > 0 ? new Integer(this.csv[j]) : null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BasicLineEntry)) {
                return false;
            }
            BasicLineEntry e = (BasicLineEntry)o;
            if (e.csv.length != this.csv.length) {
                return false;
            }
            for (int j = 0; j < this.csv.length; ++j) {
                if (e.csv[j].equals(this.csv[j])) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            Object s = "";
            for (String string : this.csv) {
                void var5_5;
                String string2;
                if (((String)s).length() > 0) {
                    s = (String)s + ",";
                }
                if ((string2 = string.replaceAll("\"", "'")).indexOf(",") >= 0) {
                    String string3 = "\"" + string2 + "\"";
                }
                s = (String)s + (String)var5_5;
            }
            return s;
        }
    }

    public static interface LineEntry {
        public String getKey();
    }
}

