/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.util;

import edu.wisc.game.util.Logging;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParseConfig
extends Hashtable<String, Object> {
    static final String prefix = "";

    public ParseConfig() {
    }

    public ParseConfig(String aFname) throws FileNotFoundException, IOException {
        this(new FileReader(aFname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseConfig(Reader in) throws IOException {
        super(20);
        String param = prefix;
        String lastName = "N/A";
        try {
            StreamTokenizer token = new StreamTokenizer(in);
            token.whitespaceChars(59, 59);
            token.wordChars(47, 47);
            token.wordChars(58, 58);
            token.wordChars(46, 46);
            token.wordChars(95, 95);
            token.slashSlashComments(false);
            token.commentChar(35);
            token.eolIsSignificant(false);
            while (token.nextToken() != -1) {
                String name = prefix;
                if (token.ttype != -3) {
                    throw new IOException("Syntax error in config file: A WORD token expected for a parameter name. The last parmeter read was `" + lastName + "'");
                }
                lastName = name = token.sval;
                if (token.nextToken() == -1) {
                    throw new IOException("Syntax error in config file: No value for" + name);
                }
                if (token.ttype == 61 && token.nextToken() == -1) {
                    throw new IOException("Syntax error in config file: No value found for" + name);
                }
                Object value = null;
                if (token.ttype == -3 || token.ttype == 34) {
                    value = token.sval;
                } else if (token.ttype == -2) {
                    value = new Double(token.nval);
                } else {
                    System.err.println("Syntax error in config file: unexpected value token type " + token.ttype);
                    continue;
                }
                this.put(name, value);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getPropertySafe(String name) {
        String property = null;
        try {
            property = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return property;
    }

    public String getOption(String aName, String aDefault) {
        String property;
        String value = aDefault;
        Object obj = this.get(aName);
        if (obj != null) {
            String msg;
            if (obj instanceof String) {
                value = (String)obj;
            } else if (obj instanceof Number) {
                msg = "Property `" + aName + "' read from the config file should be a string, not a number! Ignoring.";
                System.err.println(msg);
            } else {
                msg = "Property `" + aName + "' read from the config file is not a String";
                System.err.println(msg);
            }
        }
        if ((property = this.getPropertySafe(aName)) != null) {
            value = property;
        }
        return value;
    }

    public double getOptionDouble(String aName, double aDefault) {
        String property;
        double value = aDefault;
        Object obj = this.get(aName);
        if (obj != null) {
            if (obj instanceof Number) {
                value = ((Number)obj).doubleValue();
            } else {
                String msg = "Property `" + aName + "', value='" + obj + "', read from the config file is not a number! Ignored.";
                System.err.println(msg);
            }
        }
        if ((property = this.getPropertySafe(aName)) != null) {
            value = Double.parseDouble(property);
        }
        return value;
    }

    public int getOption(String aName, int aDefault) {
        String property;
        int value = aDefault;
        Object obj = this.get(aName);
        if (obj != null) {
            if (obj instanceof Number) {
                value = ((Number)obj).intValue();
            } else {
                String msg = "Property `" + aName + "', value='" + obj + "', read from the config file is not a number! Ignored.";
                System.err.println(msg);
            }
        }
        if ((property = this.getPropertySafe(aName)) != null) {
            value = Integer.parseInt(property);
        }
        return value;
    }

    public long getOptionLong(String aName, long aDefault) {
        String property;
        long value = aDefault;
        Object obj = this.get(aName);
        if (obj != null) {
            if (obj instanceof Number) {
                value = ((Number)obj).longValue();
            } else {
                String msg = "Property `" + aName + "', value='" + obj + "', read from the config file is not a number! Ignored.";
                System.err.println(msg);
            }
        }
        if ((property = this.getPropertySafe(aName)) != null) {
            value = Long.parseLong(property);
        }
        return value;
    }

    public boolean getOption(String aName, boolean aDefault) {
        String property;
        boolean value = aDefault;
        Object obj = this.get(aName);
        if (obj != null) {
            if (obj instanceof String) {
                String v = (String)obj;
                value = new Boolean(v);
            } else {
                String msg = "Property `" + aName + "' read from the config file is not a boolean! Ignored.";
                System.err.println(msg);
            }
        }
        if ((property = this.getPropertySafe(aName)) != null) {
            value = new Boolean(property);
        }
        return value;
    }

    public Date getOptionDate(String aName, String aDefault) throws ParseException {
        String x = this.getOption(aName, aDefault);
        if (x == null) {
            return null;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        return fmt.parse(x);
    }

    public <T extends Enum<T>> T getOptionEnum(Class<T> retType, String aName, T defVal) {
        String x;
        Object obj = this.get(aName);
        if (obj != null && obj.getClass() == retType) {
            return (T)((Enum)obj);
        }
        String string = x = obj instanceof String ? (String)obj : this.getOption(aName, null);
        if (x == null) {
            return defVal;
        }
        try {
            return Enum.valueOf(retType, x);
        }
        catch (Exception ex) {
            return defVal;
        }
    }

    public <T extends Enum<T>> T[] getOptionEnumArray(Class<T> retType, String aName, T[] defVal) {
        String x = this.getOption(aName, null);
        if (x == null) {
            return defVal;
        }
        try {
            String[] q = x.split(",");
            Enum[] z = (Enum[])Array.newInstance(retType, q.length);
            for (int i = 0; i < q.length; ++i) {
                z[i] = Enum.valueOf(retType, q[i]);
            }
            return z;
        }
        catch (Exception ex) {
            Logging.error("getOptionEnumArray(" + aName + ") error on x=" + x + "\n" + ex.getMessage());
            return defVal;
        }
    }

    public boolean containsKey(String aName) {
        return super.containsKey(aName) || this.getPropertySafe(aName) != null;
    }

    public String getParameter(String aName) throws IOException {
        Object value = null;
        Object obj = this.get(aName);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Number) {
                return prefix + ((Number)obj).intValue();
            }
            throw new IOException("Invalid type for parameter " + aName);
        }
        throw new IOException("Missing parameter " + aName);
    }

    public long getLong(String name, long defVal) {
        return this.getOptionLong(name, defVal);
    }

    public int getInt(String name, int defVal) {
        return this.getOption(name, defVal);
    }

    public double getDouble(String name, double defVal) {
        return this.getOptionDouble(name, defVal);
    }

    public String getString(String name, String defVal) {
        return this.getOption(name, defVal);
    }

    public boolean getBoolean(String name, boolean defVal) {
        return this.getOption(name, defVal);
    }

    public <T extends Enum<T>> T getEnum(Class<T> retType, String name, T defVal) {
        return this.getOptionEnum(retType, name, defVal);
    }

    public String[] enrichFromArgv(String[] argv) {
        Vector<String> v = new Vector<String>();
        Pattern p = Pattern.compile("([a-zA-Z_][a-zA_Z_\\.]*)=(.*)");
        for (String s : argv) {
            Matcher m = p.matcher(s.trim());
            if (m.matches()) {
                String key = m.group(1);
                String text = m.group(2);
                Object obj = text;
                try {
                    Pattern p1 = Pattern.compile("([0-9]+)");
                    Pattern p2 = Pattern.compile("([0-9]*)\\.([0-9]+)");
                    if (p1.matcher(text).matches()) {
                        obj = new Long(text);
                    } else if (p2.matcher(text).matches()) {
                        obj = new Double(text);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.put(key, obj);
                continue;
            }
            v.add(s);
        }
        return v.toArray(new String[0]);
    }

    public static void main(String[] argv) throws FileNotFoundException, IOException {
        for (int i = 0; i < argv.length; ++i) {
            System.out.print("Reading " + argv[i]);
            ParseConfig ht = new ParseConfig(argv[i]);
            for (String name : ht.keySet()) {
                Object value = ht.get(name);
                System.out.print("h[" + name + "] = ");
                if (value instanceof Number) {
                    System.out.println(" number(" + ((Number)value).doubleValue() + ")");
                    continue;
                }
                if (!(value instanceof String)) continue;
                System.out.println(" string(" + (String)value + ")");
            }
        }
    }
}

