/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.util;

import java.util.Comparator;
import java.util.Random;
import java.util.Vector;

public class RandomRG
extends Random {
    public RandomRG() {
    }

    public RandomRG(long seed) {
        super(seed);
    }

    public boolean getBoolean(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        return this.nextDouble() < p;
    }

    public int getInRange(int min, int max) {
        return max <= min ? min : min + this.nextInt(max - min + 1);
    }

    public int getInRange(int[] z) {
        return this.getInRange(z[0], z[1]);
    }

    public Vector<Integer> randomSubsetPermuted(int n, int m) {
        int j;
        if (m > n) {
            throw new IllegalArgumentException("Cannot select " + m + " values out of " + n + "!");
        }
        Vector<Integer> v = new Vector<Integer>(n);
        Vector<Integer> result = new Vector<Integer>(m);
        for (j = 0; j < n; ++j) {
            v.add(j);
        }
        for (j = 0; j < m; ++j) {
            int pos = this.nextInt(v.size());
            result.add((Integer)v.get(pos));
            v.removeElementAt(pos);
        }
        return result;
    }

    public Vector<Integer> randomSubsetOrdered(int n, int m) {
        Vector<Integer> q = this.randomSubsetPermuted(n, m);
        q.sort(new IntCmp());
        return q;
    }

    public double getExpDouble(double M, double L) {
        if (M < 0.0 || L < 0.0) {
            throw new IllegalArgumentException();
        }
        if (M == 0.0 || L == 0.0) {
            return 0.0;
        }
        double x = this.nextDouble();
        double z = -L * Math.log(1.0 - x * (1.0 - Math.exp(-M / L)));
        if (z > M) {
            z = M;
        }
        return z;
    }

    public int getExp(int M, double L) {
        if (M < 0 || L < 0.0) {
            throw new IllegalArgumentException();
        }
        if (M == 0 || L == 0.0) {
            return 0;
        }
        double q = L / (L + 1.0);
        double x = this.nextDouble();
        int z = (int)(Math.log(1.0 - (x /= 1.0 + Math.pow(q, M + 1))) / Math.log(q));
        if (z > M) {
            z = M;
        }
        return z;
    }

    public <T extends Enum<T>> T getEnum(Class<T> retType) {
        Enum[] w = (Enum[])retType.getEnumConstants();
        return (T)w[this.nextInt(w.length)];
    }

    class IntCmp
    implements Comparator<Integer> {
        IntCmp() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    }
}

