/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.util;

import edu.wisc.game.util.Logging;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class Tools {
    static final String NONE = "none";

    static String makeHmName(String name) {
        return name + "_hm";
    }

    public static String inputHidden(String name, boolean val) {
        return "<input type=\"hidden\" name=\"" + name + "\" value=\"" + val + "\">\n";
    }

    public static String inputHidden(String name, long val) {
        return "<input type=\"hidden\" name=\"" + name + "\" value=\"" + val + "\">\n";
    }

    public static String inputHidden(String name, String val) {
        return "<input type=\"hidden\" name=\"" + name + "\" value=\"" + val + "\">\n";
    }

    public static String inputText(String name) {
        return Tools.inputText(name, null, 0);
    }

    static String inputText(String name, long val) {
        return Tools.inputText(name, "" + val, 0);
    }

    public static String inputText(String name, Object val, int size) {
        String s = "<input type=\"text\" name=\"" + name + "\"";
        if (val != null) {
            s = s + " value=\"" + val + "\"";
        }
        if (size > 0) {
            s = s + " size=" + size;
        }
        s = s + ">\n";
        return s;
    }

    public static String inputTextArea(String name, Object val, int rows, int cols) {
        String s = "<textarea name=\"" + name + "\"";
        s = s + " rows=" + rows;
        s = s + " cols=" + cols;
        s = s + ">";
        if (val != null) {
            s = s + val;
        }
        s = s + "</textarea>\n";
        return s;
    }

    public static String radio(String name, Object value, Object text, boolean selected) {
        return Tools.radioOrBox(name, "radio", value, text, selected);
    }

    public static String checkbox(String name, Object value, Object text, boolean selected) {
        return Tools.radioOrBox(name, "checkbox", value, text, selected);
    }

    public static String radioOrBox(String name, String type, Object value, Object text, boolean selected) {
        return Tools.radioOrBox(name, type, value, text, selected, null);
    }

    public static String radioOrBox(String name, String type, Object value, Object text, boolean selected, String style) {
        String s = "<input type=\"" + type + "\" name=\"" + name + "\" value=\"" + value + "\"" + (selected ? "  checked=\"checked\"/>" : "/>");
        if (text != null) {
            s = s + text;
        }
        s = s + "\n";
        return s;
    }

    public static long getLong(HttpServletRequest request, String name, long defVal) {
        String s = request.getParameter(name);
        if (s == null) {
            Long a = (Long)request.getAttribute(name);
            return a != null ? a : defVal;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            return defVal;
        }
    }

    public static double getDouble(HttpServletRequest request, String name, double defVal) {
        String s = request.getParameter(name);
        if (s == null) {
            Double a = (Double)request.getAttribute(name);
            return a != null ? a : defVal;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            return defVal;
        }
    }

    public static boolean getBoolean(HttpServletRequest request, String name, boolean defVal) {
        String s = request.getParameter(name);
        if (s == null) {
            Boolean a = (Boolean)request.getAttribute(name);
            return a != null ? a : defVal;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception ex) {
            return defVal;
        }
    }

    public static <T extends Enum<T>> T getEnum(HttpServletRequest request, Class<T> retType, String name, T defVal) {
        String s = request.getParameter(name);
        if (s == null) {
            return defVal;
        }
        try {
            return Enum.valueOf(retType, s);
        }
        catch (Exception ex) {
            return defVal;
        }
    }

    public static <T extends Enum<T>> Vector<T> getEnums(HttpServletRequest request, Class<T> retType, String name) {
        Vector<T> v = new Vector<T>();
        String[] ss = request.getParameterValues(name);
        if (ss == null) {
            return v;
        }
        for (String s : ss) {
            try {
                v.add(Enum.valueOf(retType, s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }

    public static String getString(HttpServletRequest request, String name, String defVal) {
        String s = request.getParameter(name);
        return s == null ? defVal : s;
    }

    static boolean timeInRange(Calendar cal, int h, int m, int dm) {
        boolean result;
        int hNext = h;
        int mNext = m + dm;
        if (mNext >= 60) {
            mNext = 0;
            ++hNext;
        }
        GregorianCalendar t1 = new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5), h, m);
        GregorianCalendar t2 = new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5), hNext, mNext);
        boolean bl = result = t1.compareTo(cal) <= 0 && cal.compareTo(t2) < 0;
        if (result) {
            Logging.info(t1 + " <= " + cal + " < " + t2);
        }
        return result;
    }

    private static String option(Object value, Object text) {
        return Tools.option(value, text, false);
    }

    private static String option(Object value, Object text, boolean selected) {
        return "<OPTION value=\"" + value + "\"" + (selected ? " SELECTED>" : ">") + text + "</OPTION>\n";
    }

    static String mkSelector(String name, Class t, Object old) {
        StringBuffer b = new StringBuffer();
        b.append("<SELECT NAME=\"" + name + "\">\n");
        T[] con = t.getEnumConstants();
        for (int j = 0; j < con.length; ++j) {
            boolean selected = old == null ? j == 0 : old == con[j];
            String text = con.toString();
            b.append(Tools.option(con[j], text, selected));
        }
        b.append("</SELECT>");
        return b.toString();
    }

    static String mkSelectorBoolean(String name, Object old) {
        StringBuffer b = new StringBuffer();
        b.append("<SELECT NAME=\"" + name + "\">\n");
        boolean ov = old == null ? false : (Boolean)old;
        b.append(Tools.option("false", "No", !ov));
        b.append(Tools.option("true", "Yes", ov));
        b.append("</SELECT>");
        return b.toString();
    }
}

