/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class Util {
    public static HashMap<String, String> array2map(String[] a) {
        if (a.length % 2 != 0) {
            throw new IllegalArgumentException("To initialize a hash map, you need an even number of elements!");
        }
        HashMap<String, String> h = new HashMap<String, String>();
        for (int i = 0; i < a.length; i += 2) {
            h.put(a[i], a[i + 1]);
        }
        return h;
    }

    public static HashSet<String> array2set(String ... a) {
        HashSet<String> h = new HashSet<String>();
        for (String x : a) {
            h.add(x);
        }
        return h;
    }

    public static <T> Vector<T> array2vector(T ... a) {
        Vector<T> v = new Vector<T>();
        for (T x : a) {
            v.add(x);
        }
        return v;
    }

    public static <T> String joinNonBlank(String sep, Collection<T> v) {
        Vector<String> w = new Vector<String>();
        for (T q : v) {
            String s;
            if (q == null || (s = q.toString().trim()).length() <= 0) continue;
            w.add(s);
        }
        return Util.join(sep, w);
    }

    public static <T> String joinNonBlank(String sep, T[] z) {
        Vector<String> w = new Vector<String>();
        for (T _q : z) {
            if (_q == null) continue;
            String q = _q.toString();
            if ((q = q.trim()).length() == 0) continue;
            w.add(q);
        }
        return Util.join(sep, w);
    }

    public static <T> String joinNonBlank(String sep, double[] z) {
        Double[] v = new Double[z.length];
        for (int j = 0; j < z.length; ++j) {
            v[j] = new Double(z[j]);
        }
        return Util.joinNonBlank(sep, v);
    }

    public static <T> String joinNonBlank(String sep, NumberFormat fmt, double[] z) {
        String[] v = new String[z.length];
        for (int j = 0; j < z.length; ++j) {
            v[j] = fmt.format(z[j]);
        }
        return Util.joinNonBlank(sep, v);
    }

    public static <T> String join(String sep, Vector<T> v) {
        Object s = "";
        for (T q : v) {
            if (((String)s).length() > 0) {
                s = (String)s + sep;
            }
            s = (String)s + q.toString();
        }
        return s;
    }

    public static <T> String join(String sep, T[] x) {
        Object s = "";
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                s = (String)s + sep;
            }
            s = (String)s + x[i].toString();
        }
        return s;
    }

    public static boolean foundAny(String text, String[] keywords) {
        for (String key : keywords) {
            if (text.indexOf(key) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean foundAnyWordStart(String text, String[] keywords) {
        for (String key : keywords) {
            int k = text.indexOf(key);
            if (k != 0 && (k <= 0 || Character.isLetterOrDigit(text.charAt(k - 1)))) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAny(String text, String[] keywords) {
        for (String key : keywords) {
            if (!text.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] reverseArray(T[] x) {
        T[] y = Arrays.copyOf(x, x.length);
        int j = y.length;
        for (T q : x) {
            y[--j] = q;
        }
        return y;
    }

    public static String plural(String x, int n) {
        if (n <= 1) {
            return x;
        }
        return x + "s";
    }

    public static String roman(int n) {
        RomanNumeral r = new RomanNumeral(n);
        return r.toString();
    }

    public static boolean same(Object a, Object b) {
        return a == null ? b == null : b != null && a.equals(b);
    }

    public static String readTextFile(File f) throws IOException {
        FileReader r = new FileReader(f);
        StringBuffer b = new StringBuffer();
        int x = 0;
        while ((x = r.read()) >= 0) {
            b.append((char)x);
        }
        r.close();
        return b.toString();
    }

    public static void writeTextFile(File f, String data) throws IOException {
        PrintWriter w = new PrintWriter(new FileWriter(f));
        w.print(data);
        w.close();
    }

    public static String cap1(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static boolean anySet(boolean[] w) {
        for (boolean b : w) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public static BitSet toBitSet(Collection<Integer> v) {
        BitSet result = new BitSet();
        for (int i : v) {
            result.set(i);
        }
        return result;
    }

    private static class RomanNumeral {
        private final int n0;
        private int n;
        private final String result;

        private String a(String q, int d) {
            Object s = "";
            while (this.n >= d) {
                s = (String)s + q;
                this.n -= d;
            }
            return s;
        }

        RomanNumeral(int _n) {
            this.n = this.n0 = _n;
            if (this.n <= 0 || this.n >= 4000) {
                throw new IllegalArgumentException("Don't know how to convert " + this.n + " to a Roman numeral");
            }
            this.result = this.a("m", 1000) + this.a("cm", 900) + this.a("d", 500) + this.a("cd", 400) + this.a("c", 100) + this.a("xc", 90) + this.a("l", 50) + this.a("xl", 40) + this.a("x", 10) + this.a("ix", 9) + this.a("v", 5) + this.a("iv", 4) + this.a("i", 1);
        }

        public String toString() {
            return this.result;
        }
    }
}

