/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.web;

import edu.wisc.game.formatter.HTMLFmter;
import edu.wisc.game.parser.Expression;
import edu.wisc.game.parser.Token;
import edu.wisc.game.util.Util;
import edu.wisc.game.web.ResultsBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ArithmeticResult
extends ResultsBase {
    public static final String prefix = "var.";
    public final Vector<String> v = new Vector();
    static final HTMLFmter fmt = HTMLFmter.htmlFmter;

    public ArithmeticResult(HttpServletRequest request, HttpServletResponse response) {
        super(request, response, false);
        if (this.error) {
            return;
        }
        try {
            String exp = request.getParameter("expression");
            if (exp == null || exp.trim().equals("")) {
                this.giveError("No expression specified");
                return;
            }
            HashMap<String, HashSet<Integer>> hh = new HashMap<String, HashSet<Integer>>();
            for (String name : request.getParameterMap().keySet()) {
                if (!name.startsWith(prefix)) continue;
                String key = name.substring(prefix.length());
                String vs = request.getParameter(name);
                if (vs == null || (vs = vs.trim()).length() == 0) continue;
                HashSet<Integer> z = new HashSet<Integer>();
                for (String s : vs.split("[,\\s]+")) {
                    z.add(Integer.valueOf(s));
                }
                hh.put(key, z);
            }
            if (hh.size() == 0) {
                this.v.add("No variables have values set");
            } else {
                this.v.add("Have values set for " + hh.size() + " variables:");
                for (String key : hh.keySet()) {
                    this.v.add(key + "=[" + Util.joinNonBlank(", ", (Collection)hh.get(key)) + "]");
                }
            }
            this.v.add("Expression to process: " + exp);
            Vector<Token> tokens = Token.tokenize(exp);
            this.v.add("Expression tokenized: " + Token.toString(tokens));
            Expression.ArithmeticExpression ex = Expression.mkLongestArithmeticExpression(tokens);
            this.v.add("Expression parsed: " + ex);
            if (tokens.size() > 0) {
                this.v.add("Warning: ignoring the last " + tokens.size() + " tokens of they input, because they don't fit with the expression");
            }
            if (ex instanceof Expression.ArithmeticExpression) {
                Expression.ArithmeticExpression ae = ex;
                HashSet<Integer> hv = ae.evalSet(hh);
                hv = Expression.moduloNB(hv);
                this.v.add(fmt.wrap("strong", "Expression evaluates to [" + Util.joinNonBlank(", ", hv) + "]"));
            } else {
                System.out.println("Error: Not an arithmetic expression");
            }
        }
        catch (Exception e) {
            this.hasException(e);
        }
    }
}

