/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.web;

import edu.wisc.game.sql.User;
import edu.wisc.game.util.Logging;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class ExtendedSessionManagement {
    private static final Random random = new Random(System.currentTimeMillis());
    public static final String COOKIE_NAME = "MyArxivExtendedSession";
    public static final int maxDays = 365;
    private static final int maxHours = 8760;

    static Cookie makeCookie(User u) {
        int maxSec = 31536000;
        Object uid = "" + u.getId();
        String uCode = u.getIdCode();
        try {
            uid = URLEncoder.encode((String)uid, "UTF-8");
            uCode = URLEncoder.encode(uCode, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Date now = new Date();
        Date expiration = new Date(now.getTime() + 31536000000L);
        String val = (String)uid + ":" + uCode;
        Cookie cookie = new Cookie(COOKIE_NAME, val);
        cookie.setMaxAge(31536000);
        cookie.setPath("/");
        Logging.info("Created cookie for user " + (String)uid + " [" + val + "]");
        return cookie;
    }

    static Cookie makeLogoutCookie() {
        Cookie cookie = new Cookie(COOKIE_NAME, "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        return cookie;
    }

    static User getValidEsUser(EntityManager em, Cookie cookie) {
        if (cookie == null) {
            return null;
        }
        String val = cookie.getValue();
        if (val == null) {
            return null;
        }
        String[] z = val.split(":");
        if (z.length != 2) {
            return null;
        }
        String uid = z[0];
        String uCode = z[1];
        try {
            uid = URLDecoder.decode(uid, "UTF-8");
            uCode = URLDecoder.decode(uCode, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String queryText = "select u from User u where u.id=:id and u.idCode=:code";
        Query q = em.createQuery(queryText);
        q.setParameter("id", (Object)new Long(uid));
        q.setParameter("code", (Object)uCode);
        List res = q.getResultList();
        if (res.size() == 0) {
            return null;
        }
        return (User)res.iterator().next();
    }

    static Cookie findCookie(HttpServletRequest request) {
        Cookie[] cs = request.getCookies();
        if (cs == null) {
            return null;
        }
        for (Cookie c : cs) {
            if (!c.getName().equals(COOKIE_NAME)) continue;
            return c;
        }
        return null;
    }
}

