/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.web;

import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.TrialList;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.web.LaunchRulesBase;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LaunchMain
extends LaunchRulesBase {
    public LaunchMain(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
        if (this.error || !this.loggedIn()) {
            return;
        }
        String z = "APP";
        String[] modsLong = new String[]{z + "/" + z + "-no-feedback", z + "/" + z + "2-some-feedback", z + "/" + z + "2-more-feedback", z + "/" + z + "-max-feedback"};
        String z1 = "APP-short";
        String[] modsShort = new String[]{z1 + "/" + z + "-short-no-feedback", z1 + "/" + z + "2-short-some-feedback", z1 + "/" + z + "2-short-more-feedback", z1 + "/" + z + "-short-max-feedback"};
        this.mustUseDevClient = true;
        z = "MLC";
        File launchFile = Files.getLaunchFileMLC();
        this.buildTable(modsShort, modsLong, z, launchFile);
    }

    public void old_LaunchMain(HttpServletRequest request, HttpServletResponse response) {
        if (this.error || !this.loggedIn()) {
            return;
        }
        this.mustUseDevClient = true;
        EntityManager em = Main.getNewEM();
        try {
            this.allPlayers = LaunchMain.findPlayers(em, new Integer(this.uid));
            Vector<String> rows = new Vector<String>();
            String[] hm = new String[]{"No feedback", "Some feedback", "More feedback", "Max feedback"};
            String[] mods = new String[]{"APP/APP-no-feedback", "APP/APP-some-feedback", "APP/APP-more-feedback", "APP/APP-max-feedback"};
            rows.add(this.fm.tr("<TH rowspan=2>Experiment plan</TH><TH colspan=" + hm.length + ">Actions</TH>"));
            Vector<String> cells = new Vector<String>();
            for (String h : hm) {
                cells.add(this.fm.th(h));
            }
            rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
            File launchFile = Files.getLaunchFileMLC();
            if (!launchFile.exists()) {
                throw new IOException("The control file " + launchFile + " does not exist on the server");
            }
            CsvData csv = new CsvData(launchFile, true, false, new int[]{2});
            for (CsvData.LineEntry _e : csv.entries) {
                cells.clear();
                CsvData.BasicLineEntry e = (CsvData.BasicLineEntry)_e;
                String plan = e.getKey();
                String descr = e.getCol(1);
                cells.add(this.fm.td(this.fm.strong(this.fm.code(plan)) + ": " + descr));
                int ntr = 0;
                try {
                    ntr = TrialList.listTrialLists(plan).size();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ntr == 0) {
                    cells.add(this.fm.wrap("td", "colspan=" + mods.length, "Plan not valid - check the plan directory!"));
                    rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
                    continue;
                }
                for (String mod : mods) {
                    String exp = "P:" + plan + ":" + mod;
                    Vector players = (Vector)this.allPlayers.get(exp);
                    Vector<Object> pv = new Vector<Object>();
                    int buttonCnt = 0;
                    if (players != null) {
                        for (PlayerInfo p : players) {
                            Object t;
                            int ne = p.getAllEpisodes().size();
                            if (p.getCompletionCode() != null) {
                                t = "[COMPLETED ROUND (" + ne + " episodes)]";
                            } else {
                                t = this.mkForm("[STARTED (done " + ne + " episodes); ", "]", exp, p.getPlayerId(), "CONTINUE!");
                                ++buttonCnt;
                            }
                            pv.add(t);
                        }
                    }
                    if (buttonCnt == 0) {
                        String bt = pv.size() == 0 ? "PLAY!" : "Play another round!";
                        String t = this.mkForm("", "", exp, null, bt);
                        pv.add(t);
                    }
                    String t = String.join((CharSequence)" ", pv);
                    cells.add(this.fm.td(t));
                }
                rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
            }
            this.tableText = this.fm.table("border=\"1\"", rows);
        }
        catch (Exception ex) {
            this.hasException(ex);
        }
    }
}

