/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.web;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.rest.TrialList;
import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.PlayerInfo;
import edu.wisc.game.util.CsvData;
import edu.wisc.game.util.Tools;
import edu.wisc.game.util.Util;
import edu.wisc.game.web.ResultsBase;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LaunchRulesBase
extends ResultsBase {
    protected HashMap<String, Vector<PlayerInfo>> allPlayers;
    public String tableText = "NO DATA";
    final boolean generatePids = false;
    protected boolean mustUseDevClient = false;

    static HashMap<String, Vector<PlayerInfo>> findPlayers(EntityManager em, int uid) {
        HashMap<String, Vector<PlayerInfo>> h = new HashMap<String, Vector<PlayerInfo>>();
        Query q = em.createQuery("select m from PlayerInfo m where m.user.id=:uid");
        q.setParameter("uid", (Object)uid);
        List res = q.getResultList();
        if (res == null) {
            return h;
        }
        for (PlayerInfo p : res) {
            String exp = p.getExperimentPlan();
            Vector<PlayerInfo> v = h.get(exp);
            if (v == null) {
                v = new Vector();
                h.put(exp, v);
            }
            v.add(p);
        }
        return h;
    }

    protected String mkForm(String text1, String text2, String exp, String pid, String buttonText) {
        boolean isDev = this.cp.startsWith("/w2020-dev");
        String action = this.atHome || isDev || this.mustUseDevClient ? "http://sapir.psych.wisc.edu/rule-game/dev/" : "http://sapir.psych.wisc.edu/rule-game/prod/";
        String text = "<FORM METHOD='GET' ACTION='" + action + "'>\n";
        if (this.atHome) {
            String url = "http://localhost:8080/w2020";
            text = text + Tools.inputHidden("server", url);
        } else if (isDev) {
            String url = "http://sapir.psych.wisc.edu:7150/w2020-dev";
            text = text + Tools.inputHidden("server", url);
        }
        text = text + Tools.inputHidden("intro", false);
        text = text + Tools.inputHidden("exp", exp);
        text = text + Tools.inputHidden("uid", this.uid);
        if (pid == null) {
            // empty if block
        }
        if (pid != null) {
            text = text + Tools.inputHidden("workerId", pid);
        }
        text = text + text1 + this.fm.button(buttonText) + text2 + "\n";
        text = text + "</FORM>";
        return text;
    }

    protected String mkCell(String exp) {
        Vector<PlayerInfo> players = this.allPlayers.get(exp);
        Vector<Object> pv = new Vector<Object>();
        int buttonCnt = 0;
        if (players != null) {
            for (PlayerInfo p : players) {
                Object t;
                int ne = p.getAllEpisodes().size();
                if (p.getCompletionCode() != null) {
                    t = "[COMPLETED ROUND (" + ne + " episodes)]";
                } else {
                    t = this.mkForm("[STARTED (done " + ne + " episodes); ", "]", exp, p.getPlayerId(), "CONTINUE!");
                    ++buttonCnt;
                }
                pv.add(t);
            }
        }
        if (buttonCnt == 0) {
            String bt = pv.size() == 0 ? "PLAY!" : "Play another round!";
            pv.add(this.mkForm("", "", exp, null, bt));
        }
        return this.fm.td(String.join((CharSequence)" ", pv));
    }

    public LaunchRulesBase(HttpServletRequest request, HttpServletResponse response) {
        super(request, response, true);
        if (this.error || !this.loggedIn()) {
            return;
        }
    }

    protected String describeTrialList(TrialList t, HashSet<String> knownRuleSetNames) throws Exception {
        Vector<CallSite> v = new Vector<CallSite>();
        for (ParaSet para : t) {
            String r = para.getRuleSetName();
            knownRuleSetNames.add(r);
            RuleSet ruleSet = AllRuleSets.obtain(r);
            String descr = String.join((CharSequence)"<br>", ruleSet.description);
            v.add((CallSite)((Object)(this.fm.tt(r) + " " + descr)));
        }
        return String.join((CharSequence)"<br>", v);
    }

    private String[] mergePlanLists(CsvData launchList, String[] allPlanNames, HashMap<String, String> csvPlanDescriptions) {
        if (launchList == null) {
            return allPlanNames;
        }
        Vector<Object> q = new Vector<Object>();
        for (CsvData.LineEntry _e : launchList.entries) {
            CsvData.BasicLineEntry e = (CsvData.BasicLineEntry)_e;
            String plan = e.getKey();
            q.add(plan);
            String descr = e.getCol(1);
            csvPlanDescriptions.put(plan, descr);
        }
        for (String plan : allPlanNames) {
            if (csvPlanDescriptions.containsKey(plan)) continue;
            q.add(plan);
        }
        return q.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildTable(String[] modsShort, String[] modsLong, String z, File launchFile) {
        if (!launchFile.exists()) {
            this.infomsg = this.infomsg + " [The control file " + launchFile + " does not exist on the server]";
        }
        CsvData launchList = null;
        try {
            launchList = new CsvData(launchFile, true, false, new int[]{2});
        }
        catch (Exception ex) {
            this.infomsg = this.infomsg + "[Ignoring the control file " + launchFile + " due to an error: " + ex.getMessage() + "]";
        }
        EntityManager em = Main.getNewEM();
        try {
            String[] stringArray;
            String exp;
            this.allPlayers = LaunchRulesBase.findPlayers(em, new Integer(this.uid));
            Vector<String> rows = new Vector<String>();
            Vector<String> cells = new Vector<String>();
            String[] hm = new String[]{"No feedback", "Some feedback", "More feedback", "Max feedback"};
            this.tableText = this.fm.para("Part A: Experiment plans from <tt>trial-lists/" + z + "</tt>");
            rows.add(this.fm.tr("<TH rowspan=2>Experiment plan &amp; its rule set(s)</TH><TH colspan=" + hm.length + ">Actions</TH>"));
            cells.clear();
            for (String string : hm) {
                cells.add(this.fm.th(string));
            }
            rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
            HashSet<String> knownRuleSetNames = new HashSet<String>();
            String[] allPlanNames = Files.listSAllExperimentPlansInTree(z);
            HashMap<String, String> csvPlanDescriptions = new HashMap<String, String>();
            for (String p : allPlanNames = this.mergePlanLists(launchList, allPlanNames, csvPlanDescriptions)) {
                cells.clear();
                Vector<String> trialLists = TrialList.listTrialLists(p);
                if (trialLists.size() != 1) {
                    cells.add(this.fm.td("Cannot use experiment plan " + p + ": it has " + trialLists.size() + " trial lists, and we want exactly 1"));
                    rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
                    continue;
                }
                TrialList tlist = new TrialList(p, trialLists.get(0));
                String descr2 = csvPlanDescriptions.get(p);
                String descr = "Plan: " + this.fm.strong(this.fm.tt(p));
                if (descr2 != null) {
                    descr = descr + " " + descr2;
                }
                descr = descr + ":<br>" + this.describeTrialList(tlist, knownRuleSetNames);
                cells.add(this.fm.td(descr));
                for (String mod : modsShort) {
                    exp = "P:" + p + ":" + mod;
                    cells.add(this.mkCell(exp));
                }
                rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
            }
            this.tableText = this.tableText + this.fm.para("This table covers " + knownRuleSetNames.size() + " rule sets: " + Util.joinNonBlank(", ", knownRuleSetNames));
            this.tableText = this.tableText + this.fm.table("border=\"1\"", rows);
            this.tableText = this.tableText + this.fm.para("Part B: Rule sets from <tt>rules/" + z + "</tt> not covered in Part A");
            rows.clear();
            rows.add(this.fm.tr("<TH rowspan=2>Rule Set</TH><TH colspan=" + hm.length + ">Actions</TH>"));
            cells.clear();
            for (String h : hm) {
                cells.add(this.fm.th(h));
            }
            rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
            for (String r : stringArray = Files.listAllRuleSetsInTree(z)) {
                RuleSet ruleSet = AllRuleSets.obtain(r);
                String descr = String.join((CharSequence)"<br>", ruleSet.description);
                cells.clear();
                String text = this.fm.tt(r) + " " + descr;
                cells.add(this.fm.td(text));
                if (knownRuleSetNames.contains(r)) {
                    cells.add(this.fm.wrap("td", "colspan=" + modsLong.length, "See Part A"));
                } else {
                    for (String mod : modsLong) {
                        exp = "R:" + r + ":" + mod;
                        cells.add(this.mkCell(exp));
                    }
                }
                rows.add(this.fm.tr(String.join((CharSequence)"", cells)));
            }
            this.tableText = this.tableText + this.fm.table("border=\"1\"", rows);
        }
        catch (Exception ex) {
            this.hasException(ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
    }
}

