/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.web;

import edu.wisc.game.rest.UserResponse;
import edu.wisc.game.sql.User;
import edu.wisc.game.util.Logging;
import edu.wisc.game.web.ExtendedSessionManagement;
import edu.wisc.game.web.SessionData;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServlet
extends HttpServlet {
    static final String START_PAGE = "/launch/index.jsp";

    private String getParameter(HttpServletRequest request, String name) {
        String x = request.getParameter(name);
        return x == null ? x : x.trim();
    }

    private String getParameter1(HttpServletRequest request, String name) {
        String x = this.getParameter(request, name);
        return x == null || x.equals("") ? null : x;
    }

    private boolean getAnon(HttpServletRequest request) {
        String x = this.getParameter1(request, "anon");
        return x != null && x.toLowerCase().equals("true");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        String sp = this.getParameter1(request, "sp");
        String qs = request.getParameter("qs");
        if (qs != null && qs.equals("null")) {
            qs = null;
        }
        String nickname = this.getParameter1(request, "nickname");
        String email = this.getParameter1(request, "email");
        UserResponse ur = new UserResponse(email, nickname, this.getAnon(request));
        if (ur.getError()) {
            try {
                response.sendError(401, ur.getErrmsg());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        User u = ur.getUser();
        SessionData sd = SessionData.getSessionData(request);
        sd.storeUserInfo(u);
        Object redirect = START_PAGE;
        if (sp != null && !sp.equals("null")) {
            redirect = sp;
            if (qs != null) {
                redirect = (String)redirect + "?" + qs;
            }
        }
        String cp = request.getContextPath();
        String eurl = response.encodeRedirectURL(cp + "/" + (String)redirect);
        Cookie cookie = ExtendedSessionManagement.makeCookie(u);
        if (cookie != null) {
            Logging.info("LoginServlet: [Sending cookie=" + cookie.getValue() + "]");
            response.addCookie(cookie);
        }
        try {
            response.sendRedirect(eurl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

