/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.web;

import edu.wisc.game.formatter.HTMLFmter;
import edu.wisc.game.util.Hosts;
import edu.wisc.game.util.Logging;
import edu.wisc.game.web.SessionData;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResultsBase {
    boolean error = false;
    String errmsg = null;
    public String infomsg = "";
    final HttpServletRequest request;
    final String cp;
    SessionData sd;
    public String uid = null;
    public String displayName = null;
    boolean atHome;
    final HTMLFmter fm = HTMLFmter.htmlFmter;
    Exception ex = null;

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean _error) {
        this.error = _error;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setErrmsg(String _errmsg) {
        this.errmsg = _errmsg;
    }

    protected void giveError(String msg) {
        this.setError(true);
        this.setErrmsg(msg);
    }

    public boolean loggedIn() {
        return this.uid != null;
    }

    public String getDisplayText() {
        if (this.uid == null) {
            return "You are not logged in";
        }
        return "User No. " + this.uid + " (" + this.displayName + ")";
    }

    ResultsBase(HttpServletRequest _request, HttpServletResponse response, boolean requiresUser) {
        long tid = Thread.currentThread().getId();
        this.request = _request;
        this.cp = this.request.getContextPath();
        this.infomsg = this.infomsg + " [cp=" + this.cp + "]";
        if (!requiresUser) {
            return;
        }
        this.sd = SessionData.getSessionData(this.request);
        this.infomsg = this.infomsg + " [sd=" + this.sd + "]";
        StringBuffer msgBuffer = new StringBuffer();
        this.uid = this.sd.getRemoteUser(this.request, msgBuffer);
        this.infomsg = this.infomsg + msgBuffer;
        this.displayName = this.sd.getStoredDisplayName();
        this.atHome = Hosts.atHome();
    }

    ResultsBase(boolean _error, String _errmsg) {
        this.request = null;
        this.cp = null;
        this.setError(_error);
        this.setErrmsg(_errmsg);
    }

    void hasException(Exception _ex) {
        this.ex = _ex;
        this.setError(true);
        Object msg = this.ex.getMessage();
        if (msg == null) {
            msg = "Unknown internal error (" + this.ex + "); see stack trace in the server logs";
        }
        this.setErrmsg((String)msg);
        Logging.error("" + this.ex);
        this.ex.printStackTrace(System.err);
    }

    public Exception getEx() {
        return this.ex;
    }

    public String exceptionTrace() {
        StringWriter sw = new StringWriter();
        try {
            if (this.ex == null) {
                return "No exception was caught";
            }
            this.ex.printStackTrace(new PrintWriter(sw));
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

