/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.web;

import edu.wisc.game.sql.Main;
import edu.wisc.game.sql.User;
import edu.wisc.game.util.Logging;
import edu.wisc.game.web.ExtendedSessionManagement;
import edu.wisc.game.web.WebException;
import java.io.IOException;
import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionData {
    private final HttpSession session;
    private static String whoSync = null;
    private static final String ATTRIBUTE_SD = "sd";
    private String storedUserName = null;
    private String storedDisplayName = null;

    static String getWhoSync() {
        return whoSync;
    }

    private static void addSync(String msg) {
        Logging.info(msg);
        whoSync = whoSync + "; " + msg;
    }

    public String toString() {
        return "(SD)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionData(HttpSession _session) {
        long tid = Thread.currentThread().getId();
        whoSync = "SessionData.in(" + tid + ")";
        try {
            this.session = _session;
            SessionData.addSync("SD.SD.A");
        }
        finally {
            whoSync = "SessionData.out";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SessionData getSessionData(HttpServletRequest request) {
        whoSync = "getSessionData.in";
        try {
            SessionData.addSync("SD.gSD.A, request is " + (request == null ? "null" : "not null"));
            if (request == null) {
                SessionData sessionData = new SessionData(null);
                return sessionData;
            }
            HttpSession session = request.getSession();
            SessionData sd = null;
            SessionData.addSync("SD.gSD.B");
            Object object = session;
            synchronized (object) {
                SessionData.addSync("SD.gSD.C");
                sd = (SessionData)session.getAttribute(ATTRIBUTE_SD);
                SessionData.addSync("SD.gSD.D, old sd= " + sd);
                if (sd == null) {
                    sd = new SessionData(session);
                    session.setAttribute(ATTRIBUTE_SD, (Object)sd);
                }
            }
            object = sd;
            return object;
        }
        finally {
            whoSync = "getSessionData.out";
        }
    }

    static synchronized void discardSessionData(HttpServletRequest request) throws WebException, IOException {
        whoSync = "discardSD.in";
        try {
            HttpSession session = request.getSession();
            session.invalidate();
        }
        finally {
            whoSync = "discardSD.out";
        }
    }

    ServletContext getServletContext() {
        return this.session.getServletContext();
    }

    public String getStoredUserName() {
        return this.storedUserName;
    }

    public String getStoredDisplayName() {
        return this.storedDisplayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRemoteUser(HttpServletRequest request, StringBuffer msgBuffer) {
        msgBuffer.setLength(0);
        String u = this.storedUserName;
        String msg = "gRemoteUser: stored=" + u;
        if (u == null) {
            Cookie cookie = ExtendedSessionManagement.findCookie(request);
            if (cookie != null) {
                msg = msg + "; cookie.val=" + cookie.getValue();
                EntityManager em = Main.getNewEM();
                try {
                    User user = ExtendedSessionManagement.getValidEsUser(em, cookie);
                    if (user != null) {
                        this.storeUserInfo(user);
                        u = this.storedUserName;
                        msg = msg + "; user=" + user.getId();
                    }
                    msg = msg + "; no user";
                }
                finally {
                    try {
                        em.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                msg = msg + "; no cookie";
            }
        }
        msgBuffer.append(" [" + msg + "]");
        return u != null ? u : null;
    }

    public void storeUserInfo(User user) {
        String u = "" + user.getId();
        this.storedUserName = u;
        String nickname = user.getNickname();
        String email = user.getEmail();
        this.storedDisplayName = nickname != null ? nickname : (email != null ? email : "An anonymous session-based user");
    }
}

